/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import net.sf.gogui.go.BoardConstants;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.gui.GuiField;
import net.sf.gogui.gui.GuiUtils;

public class GuiBoardDrawer {
    private final boolean m_fastPaint;
    private int m_fieldSize;
    private int m_fieldOffset;
    private int m_size;
    private int m_width;
    private static final AlphaComposite COMPOSITE_3;
    private BoardConstants m_constants;
    private final Image m_image;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GuiBoardDrawer(boolean bl) {
        this.m_fastPaint = bl;
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource("net/sf/gogui/images/wood.png");
        this.m_image = uRL != null ? new ImageIcon(uRL).getImage() : null;
    }

    public void draw(Graphics graphics, GuiField[][] guiFieldArray, int n, boolean bl) {
        if (!this.m_fastPaint) {
            GuiUtils.setAntiAlias(graphics);
        }
        this.m_width = n;
        this.m_size = guiFieldArray.length;
        if (this.m_constants == null || this.m_constants.getSize() != this.m_size) {
            this.m_constants = new BoardConstants(this.m_size);
        }
        if (!$assertionsDisabled && this.m_size > 25) {
            throw new AssertionError();
        }
        if (bl) {
            this.m_fieldSize = n / (this.m_size + 2);
            this.m_fieldOffset = (n - (this.m_size + 2) * this.m_fieldSize) / 2 + this.m_fieldSize;
        } else {
            this.m_fieldSize = 5 * n / (5 * this.m_size + 2);
            this.m_fieldOffset = (n - this.m_size * this.m_fieldSize) / 2;
        }
        this.drawBackground(graphics);
        this.drawGrid(graphics);
        if (bl) {
            this.drawGridLabels(graphics);
        }
        this.drawShadows(graphics, guiFieldArray);
        this.drawFields(graphics, guiFieldArray);
    }

    public Point getCenter(int n, int n2) {
        Point point = this.getLocation(n, n2);
        point.x += this.m_fieldSize / 2;
        point.y += this.m_fieldSize / 2;
        return point;
    }

    public int getFieldSize() {
        return this.m_fieldSize;
    }

    public Point getLocation(int n, int n2) {
        Point point = new Point();
        point.x = this.m_fieldOffset + n * this.m_fieldSize;
        point.y = this.m_fieldOffset + (this.m_size - n2 - 1) * this.m_fieldSize;
        return point;
    }

    public GoPoint getPoint(Point point) {
        int n = ((int)point.getX() - this.m_fieldOffset) / this.m_fieldSize;
        int n2 = ((int)point.getY() - this.m_fieldOffset) / this.m_fieldSize;
        n2 = this.m_size - n2 - 1;
        if (n >= 0 && n < this.m_size && n2 >= 0 && n2 < this.m_size) {
            return GoPoint.get(n, n2);
        }
        return null;
    }

    public int getShadowOffset() {
        return (this.m_fieldSize - 2 * GuiField.getStoneMargin(this.m_fieldSize)) / 12;
    }

    private void drawFields(Graphics graphics, GuiField[][] guiFieldArray) {
        if (!$assertionsDisabled && guiFieldArray.length != this.m_size) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.m_size; ++i) {
            if (!$assertionsDisabled && guiFieldArray[i].length != this.m_size) {
                throw new AssertionError();
            }
            for (int j = 0; j < this.m_size; ++j) {
                Point point = this.getLocation(i, j);
                guiFieldArray[i][j].draw(graphics, this.m_fieldSize, point.x, point.y, this.m_fastPaint);
            }
        }
    }

    private void drawBackground(Graphics graphics) {
        if (this.m_image != null && !this.m_fastPaint) {
            graphics.drawImage(this.m_image, 0, 0, this.m_width, this.m_width, null);
        } else {
            graphics.setColor(new Color(212, 167, 102));
            graphics.fillRect(0, 0, this.m_width, this.m_width);
        }
    }

    private void drawGrid(Graphics graphics) {
        Point point;
        Point point2;
        int n;
        if (this.m_fieldSize < 2) {
            return;
        }
        graphics.setColor(Color.darkGray);
        for (n = 0; n < this.m_size; ++n) {
            point2 = this.getCenter(0, n);
            point = this.getCenter(this.m_size - 1, n);
            graphics.drawLine(point2.x, point2.y, point.x, point.y);
        }
        for (n = 0; n < this.m_size; ++n) {
            point2 = this.getCenter(n, 0);
            point = this.getCenter(n, this.m_size - 1);
            graphics.drawLine(point2.x, point2.y, point.x, point.y);
        }
        n = this.m_fieldSize / 10;
        for (int i = 0; i < this.m_size; ++i) {
            if (!this.m_constants.isHandicapLine(i)) continue;
            for (int j = 0; j < this.m_size; ++j) {
                if (!this.m_constants.isHandicapLine(j)) continue;
                Point point3 = this.getCenter(i, j);
                graphics.fillOval(point3.x - n, point3.y - n, 2 * n + 1, 2 * n + 1);
            }
        }
    }

    private void drawGridLabels(Graphics graphics) {
        String string;
        int n;
        graphics.setColor(Color.darkGray);
        graphics.setFont(UIManager.getFont("Label.font"));
        int n2 = graphics.getFontMetrics().stringWidth("XX");
        if (this.m_fieldSize < n2) {
            return;
        }
        char c = 'A';
        for (n = 0; n < this.m_size; ++n) {
            string = Character.toString(c);
            this.drawLabel(graphics, this.getLocation(n, -1), string);
            this.drawLabel(graphics, this.getLocation(n, this.m_size), string);
            c = (char)(c + '\u0001');
            if (c != 73) continue;
            c = (char)(c + '\u0001');
        }
        for (n = 0; n < this.m_size; ++n) {
            string = Integer.toString(n + 1);
            this.drawLabel(graphics, this.getLocation(-1, n), string);
            this.drawLabel(graphics, this.getLocation(this.m_size, n), string);
        }
    }

    private void drawShadows(Graphics graphics, GuiField[][] guiFieldArray) {
        Graphics2D graphics2D;
        if (this.m_fieldSize <= 5) {
            return;
        }
        Graphics2D graphics2D2 = graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        if (graphics2D == null || this.m_fastPaint) {
            return;
        }
        graphics2D.setComposite(COMPOSITE_3);
        int n = this.m_fieldSize - 2 * GuiField.getStoneMargin(this.m_fieldSize);
        int n2 = this.getShadowOffset();
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                if (guiFieldArray[i][j].getColor() == GoColor.EMPTY) continue;
                Point point = this.getCenter(i, j);
                graphics.setColor(Color.black);
                graphics.fillOval(point.x - n / 2 + n2, point.y - n / 2 + n2, n, n);
            }
        }
        graphics.setPaintMode();
    }

    private void drawLabel(Graphics graphics, Point point, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getAscent();
        int n3 = Math.max((this.m_fieldSize - n) / 2, 0);
        int n4 = n2 + (this.m_fieldSize - n2) / 2;
        graphics.drawString(string, point.x + n3, point.y + n4);
    }

    static {
        $assertionsDisabled = !GuiBoardDrawer.class.desiredAssertionStatus();
        COMPOSITE_3 = AlphaComposite.getInstance(3, 0.3f);
    }
}

