/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.gogui.gui.Bookmark;
import net.sf.gogui.gui.SimpleDialogs;

public class BookmarkDialog
extends JOptionPane {
    private static final long serialVersionUID = 0L;
    private final JPanel m_panelLeft;
    private final JPanel m_panelRight;
    private JTextField m_name;
    private JTextField m_file;
    private JTextField m_move;
    private JTextField m_variation;

    public static boolean show(Component component, String string, Bookmark bookmark, boolean bl) {
        BookmarkDialog bookmarkDialog = new BookmarkDialog(bookmark);
        JDialog jDialog = bookmarkDialog.createDialog(component, string);
        boolean bl2 = false;
        while (!bl2) {
            if (bl) {
                bookmarkDialog.m_name.selectAll();
                bookmarkDialog.m_name.requestFocusInWindow();
            }
            jDialog.setVisible(true);
            Object object = bookmarkDialog.getValue();
            if (!(object instanceof Integer) || (Integer)object != 0) {
                return false;
            }
            bl2 = bookmarkDialog.validate(component);
        }
        bookmark.m_name = bookmarkDialog.m_name.getText().trim();
        bookmark.m_file = new File(bookmarkDialog.m_file.getText());
        bookmark.m_move = bookmarkDialog.getMove();
        bookmark.m_variation = bookmarkDialog.m_variation.getText().trim();
        jDialog.dispose();
        return true;
    }

    public BookmarkDialog(Bookmark bookmark) {
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        this.m_panelLeft = new JPanel(new GridLayout(0, 1, 0, 2));
        jPanel.add((Component)this.m_panelLeft, "West");
        this.m_panelRight = new JPanel(new GridLayout(0, 1, 0, 2));
        jPanel.add((Component)this.m_panelRight, "Center");
        this.m_name = this.createEntry("Name:", bookmark.m_name);
        String string = "";
        if (bookmark.m_file != null) {
            string = bookmark.m_file.toString();
        }
        this.m_file = this.createEntry("File:", string);
        String string2 = "";
        if (bookmark.m_move > 0) {
            string2 = Integer.toString(bookmark.m_move);
        }
        this.m_move = this.createEntry("Move:", string2);
        this.m_variation = this.createEntry("Variation:", bookmark.m_variation);
        this.setMessage(jPanel);
        this.setOptionType(2);
    }

    private JTextField createEntry(String string, String string2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(2);
        this.m_panelLeft.add(jLabel);
        JTextField jTextField = new JTextField(string2);
        jTextField.setColumns(25);
        this.m_panelRight.add(jTextField);
        return jTextField;
    }

    private int getMove() {
        String string = this.m_move.getText().trim();
        if (string.equals("")) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private boolean validate(Component component) {
        if (this.m_name.getText().trim().equals("")) {
            SimpleDialogs.showError(component, "Name cannot be empty");
            return false;
        }
        if (this.getMove() < 0) {
            SimpleDialogs.showError(component, "Invalid move number");
            return false;
        }
        File file = new File(this.m_file.getText().trim());
        if (!file.exists()) {
            SimpleDialogs.showError(component, "File does not exist");
            return false;
        }
        return true;
    }
}

