/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.diylc.common.ComponentType;
import org.diylc.core.IDIYComponent;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.presenter.ComponentProcessor;
import org.diylc.utils.BomEntry;

public class BomMaker {
    private static BomMaker instance;

    public static BomMaker getInstance() {
        if (instance == null) {
            instance = new BomMaker();
        }
        return instance;
    }

    private BomMaker() {
    }

    public List<BomEntry> createBom(List<IDIYComponent<?>> list) {
        LinkedHashMap<String, BomEntry> linkedHashMap = new LinkedHashMap<String, BomEntry>();
        ArrayList arrayList = new ArrayList(list);
        Collections.sort(arrayList, new Comparator<IDIYComponent<?>>(){

            @Override
            public int compare(IDIYComponent<?> iDIYComponent, IDIYComponent<?> iDIYComponent2) {
                String string = iDIYComponent.getName();
                String string2 = iDIYComponent2.getName();
                Pattern pattern = Pattern.compile("(\\D+)(\\d+)");
                Matcher matcher = pattern.matcher(string);
                Matcher matcher2 = pattern.matcher(string2);
                if (matcher.matches() && matcher2.matches()) {
                    String string3 = matcher.group(1);
                    int n = Integer.parseInt(matcher.group(2));
                    String string4 = matcher2.group(1);
                    int n2 = Integer.parseInt(matcher2.group(2));
                    int n3 = string3.compareToIgnoreCase(string4);
                    if (n3 != 0) {
                        return n3;
                    }
                    return new Integer(n).compareTo(n2);
                }
                return string.compareToIgnoreCase(string2);
            }
        });
        for (IDIYComponent iDIYComponent : arrayList) {
            String string;
            ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(iDIYComponent.getClass());
            if (componentType.getBomPolicy() == BomPolicy.NEVER_SHOW) continue;
            String string2 = iDIYComponent.getName();
            try {
                string = iDIYComponent.getValueForDisplay();
            }
            catch (Exception exception) {
                string = "<undefined>";
            }
            if (string2 == null || string == null) continue;
            String string3 = componentType.getName() + "|" + string;
            if (linkedHashMap.containsKey(string3)) {
                BomEntry bomEntry = (BomEntry)linkedHashMap.get(string3);
                bomEntry.setQuantity(bomEntry.getQuantity() + 1);
                if (componentType.getBomPolicy() != BomPolicy.SHOW_ALL_NAMES) continue;
                bomEntry.setName(bomEntry.getName() + ", " + string2);
                continue;
            }
            linkedHashMap.put(string3, new BomEntry(componentType.getName(), componentType.getBomPolicy() == BomPolicy.SHOW_ALL_NAMES ? string2 : componentType.getName(), string, 1));
        }
        ArrayList arrayList2 = new ArrayList(linkedHashMap.values());
        return arrayList2;
    }
}

