/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;

public class Prefs {
    private static Preferences prefs;
    private static final Object mutex;
    public static final Pattern xmlCrusher;
    private static PropertyChangeSupport emitter;
    private static Thread flushThread;

    private Prefs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putObj(String key, Object value) {
        Object object = mutex;
        synchronized (object) {
            if (value == null) {
                prefs.remove(key);
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                XMLEncoder e = new XMLEncoder(out);
                e.writeObject(value);
                e.close();
                try {
                    prefs.put(key, xmlCrusher.matcher(new String(out.toByteArray(), "UTF-8")).replaceAll("><"));
                }
                catch (UnsupportedEncodingException excep) {
                    throw new RuntimeException(excep);
                }
            }
            Prefs.flush();
        }
        emitter.firePropertyChange(key, null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flush() {
        Object object = mutex;
        synchronized (object) {
            if (flushThread == null) {
                flushThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Prefs.doFlush();
                    }
                });
                flushThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doFlush() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Object object = mutex;
        synchronized (object) {
            try {
                prefs.flush();
            }
            catch (BackingStoreException excep) {
                Logger.getLogger("global").log(Level.WARNING, "Prefs.doFlush: Error flushing", excep);
            }
            finally {
                flushThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putString(String key, String value) {
        Object object = mutex;
        synchronized (object) {
            if (value == null) {
                prefs.remove(key);
            } else {
                prefs.put(key, value);
            }
            Prefs.flush();
        }
        emitter.firePropertyChange(key, null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putInt(String key, int value) {
        Object object = mutex;
        synchronized (object) {
            prefs.putInt(key, value);
            Prefs.flush();
        }
        emitter.firePropertyChange(key, null, new Integer(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putLong(String key, long value) {
        Object object = mutex;
        synchronized (object) {
            prefs.putLong(key, value);
            Prefs.flush();
        }
        emitter.firePropertyChange(key, null, new Long(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putFloat(String key, float value) {
        Object object = mutex;
        synchronized (object) {
            prefs.putFloat(key, value);
            Prefs.flush();
        }
        emitter.firePropertyChange(key, null, new Float(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putBoolean(String key, boolean value) {
        Object object = mutex;
        synchronized (object) {
            prefs.putBoolean(key, value);
            Prefs.flush();
        }
        emitter.firePropertyChange(key, null, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putBytes(String key, byte[] data) {
        Object object = mutex;
        synchronized (object) {
            prefs.putByteArray(key, data);
            Prefs.flush();
        }
        emitter.firePropertyChange(key, null, data);
    }

    public static Object getObj(String key, Object def) {
        String v = prefs.get(key, null);
        if (v == null) {
            return def;
        }
        try {
            XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(v.getBytes("UTF-8")));
            Object result = decoder.readObject();
            return result == null ? def : result;
        }
        catch (Throwable thrown) {
            return def;
        }
    }

    public static String getString(String key, String def) {
        return prefs.get(key, def);
    }

    public static int getInt(String key, int defValue) {
        return prefs.getInt(key, defValue);
    }

    public static long getLong(String key, long defValue) {
        return prefs.getLong(key, defValue);
    }

    public static float getFloat(String key, float defValue) {
        return prefs.getFloat(key, defValue);
    }

    public static boolean getBoolean(String key, boolean defValue) {
        return prefs.getBoolean(key, defValue);
    }

    public static byte[] getBytes(String key, byte[] def) {
        return prefs.getByteArray(key, def);
    }

    public static void addListener(String key, PropertyChangeListener newListener) {
        emitter.addPropertyChangeListener(key, newListener);
    }

    public static void removeListener(String key, PropertyChangeListener oldListener) {
        emitter.removePropertyChangeListener(key, oldListener);
    }

    public static void load(Class<?> klass) {
        prefs = new NullPrefs();
        if (klass != null) {
            try {
                prefs = Preferences.userNodeForPackage(klass);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static void setImpl(Preferences newPrefs) {
        prefs = newPrefs;
    }

    public static void remove(String key) {
        prefs.remove(key);
        emitter.firePropertyChange(key, null, null);
    }

    public static boolean isLoaded() {
        return prefs != null;
    }

    public static void useSubdirectory(String subdir) {
        prefs = prefs.node(subdir);
    }

    static {
        mutex = new Object();
        xmlCrusher = Pattern.compile(">\\s+<");
        emitter = new PropertyChangeSupport(Prefs.class);
    }

    private static class NullPrefs
    extends AbstractPreferences {
        private final HashMap<String, String> vals = new HashMap();
        private final HashMap<String, NullPrefs> children = new HashMap();

        @Override
        protected void putSpi(String key, String value) {
            this.vals.put(key, value);
        }

        @Override
        protected String getSpi(String key) {
            return this.vals.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this.vals.remove(key);
        }

        @Override
        protected void removeNodeSpi() {
        }

        @Override
        protected String[] keysSpi() {
            return this.flatten(this.vals);
        }

        @Override
        protected String[] childrenNamesSpi() {
            return this.flatten(this.children);
        }

        private String[] flatten(HashMap<String, ?> in) {
            ArrayList<String> out = new ArrayList<String>(in.keySet());
            return out.toArray(new String[0]);
        }

        @Override
        protected AbstractPreferences childSpi(String nodeName) {
            NullPrefs np = new NullPrefs();
            this.children.put(nodeName, np);
            return np;
        }

        @Override
        public void syncSpi() {
        }

        @Override
        public void flushSpi() {
        }

        public NullPrefs() {
            super(null, "");
        }
    }
}

