/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.pool2.DestroyMode;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;

class CPDSConnectionFactory
implements PooledObjectFactory<PooledConnectionAndInfo>,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private final ConnectionPoolDataSource cpds;
    private final String validationQuery;
    private final int validationQueryTimeoutSeconds;
    private final boolean rollbackAfterValidation;
    private ObjectPool<PooledConnectionAndInfo> pool;
    private final String userName;
    private char[] userPassword;
    private long maxConnLifetimeMillis = -1L;
    private final Set<PooledConnection> validatingSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<PooledConnection, PooledConnectionAndInfo> pcMap = new ConcurrentHashMap<PooledConnection, PooledConnectionAndInfo>();

    CPDSConnectionFactory(ConnectionPoolDataSource cpds, String validationQuery, int validationQueryTimeoutSeconds, boolean rollbackAfterValidation, String userName, char[] userPassword) {
        this.cpds = cpds;
        this.validationQuery = validationQuery;
        this.validationQueryTimeoutSeconds = validationQueryTimeoutSeconds;
        this.userName = userName;
        this.userPassword = userPassword;
        this.rollbackAfterValidation = rollbackAfterValidation;
    }

    CPDSConnectionFactory(ConnectionPoolDataSource cpds, String validationQuery, int validationQueryTimeoutSeconds, boolean rollbackAfterValidation, String userName, String userPassword) {
        this(cpds, validationQuery, validationQueryTimeoutSeconds, rollbackAfterValidation, userName, Utils.toCharArray(userPassword));
    }

    char[] getPasswordCharArray() {
        return this.userPassword;
    }

    public ObjectPool<PooledConnectionAndInfo> getPool() {
        return this.pool;
    }

    public void setPool(ObjectPool<PooledConnectionAndInfo> pool) {
        this.pool = pool;
    }

    @Override
    public synchronized PooledObject<PooledConnectionAndInfo> makeObject() {
        PooledConnectionAndInfo pci;
        try {
            PooledConnection pc = null;
            pc = this.userName == null ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(this.userName, Utils.toString(this.userPassword));
            if (pc == null) {
                throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
            }
            pc.addConnectionEventListener(this);
            pci = new PooledConnectionAndInfo(pc, this.userName, this.userPassword);
            this.pcMap.put(pc, pci);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
        return new DefaultPooledObject<PooledConnectionAndInfo>(pci);
    }

    @Override
    public void destroyObject(PooledObject<PooledConnectionAndInfo> p) throws Exception {
        this.doDestroyObject(p.getObject());
    }

    @Override
    public void destroyObject(PooledObject<PooledConnectionAndInfo> p, DestroyMode mode) throws Exception {
        this.destroyObject(p);
    }

    private void doDestroyObject(PooledConnectionAndInfo pci) throws Exception {
        PooledConnection pc = pci.getPooledConnection();
        pc.removeConnectionEventListener(this);
        this.pcMap.remove(pc);
        pc.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateObject(PooledObject<PooledConnectionAndInfo> p) {
        try {
            this.validateLifetime(p);
        }
        catch (Exception e) {
            return false;
        }
        boolean valid = false;
        PooledConnection pconn = p.getObject().getPooledConnection();
        Connection conn = null;
        this.validatingSet.add(pconn);
        if (null == this.validationQuery) {
            int timeoutSeconds = this.validationQueryTimeoutSeconds;
            if (timeoutSeconds < 0) {
                timeoutSeconds = 0;
            }
            try {
                conn = pconn.getConnection();
                valid = conn.isValid(timeoutSeconds);
                return valid;
            }
            catch (SQLException e) {
                valid = false;
                return valid;
            }
            finally {
                Utils.closeQuietly(conn);
                this.validatingSet.remove(pconn);
            }
        }
        Statement stmt = null;
        ResultSet rset = null;
        this.validatingSet.add(pconn);
        try {
            conn = pconn.getConnection();
            stmt = conn.createStatement();
            rset = stmt.executeQuery(this.validationQuery);
            valid = rset.next();
            if (this.rollbackAfterValidation) {
                conn.rollback();
            }
            Utils.closeQuietly(rset);
        }
        catch (Exception e) {
            valid = false;
            return valid;
        }
        Utils.closeQuietly(stmt);
        Utils.closeQuietly(conn);
        this.validatingSet.remove(pconn);
        return valid;
        finally {
            Utils.closeQuietly(rset);
            Utils.closeQuietly(stmt);
            Utils.closeQuietly(conn);
            this.validatingSet.remove(pconn);
        }
    }

    @Override
    public void passivateObject(PooledObject<PooledConnectionAndInfo> p) throws Exception {
        this.validateLifetime(p);
    }

    @Override
    public void activateObject(PooledObject<PooledConnectionAndInfo> p) throws Exception {
        this.validateLifetime(p);
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (!this.validatingSet.contains(pc)) {
            PooledConnectionAndInfo pci = this.pcMap.get(pc);
            if (pci == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this.pool.returnObject(pci);
            }
            catch (Exception e) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pc.removeConnectionEventListener(this);
                try {
                    this.doDestroyObject(pci);
                }
                catch (Exception e2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pci);
                    e2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (null != event.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + event.getSQLException() + ")");
        }
        pc.removeConnectionEventListener(this);
        PooledConnectionAndInfo pci = this.pcMap.get(pc);
        if (pci == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.invalidateObject(pci);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pci);
            e.printStackTrace();
        }
    }

    @Override
    public void invalidate(PooledConnection pc) throws SQLException {
        PooledConnectionAndInfo pci = this.pcMap.get(pc);
        if (pci == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.invalidateObject(pci);
            this.pool.close();
        }
        catch (Exception ex) {
            throw new SQLException("Error invalidating connection", ex);
        }
    }

    public synchronized void setPassword(char[] userPassword) {
        this.userPassword = Utils.clone(userPassword);
    }

    @Override
    public synchronized void setPassword(String userPassword) {
        this.userPassword = Utils.toCharArray(userPassword);
    }

    public void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.maxConnLifetimeMillis = maxConnLifetimeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePool(String userName) throws SQLException {
        CPDSConnectionFactory cPDSConnectionFactory = this;
        synchronized (cPDSConnectionFactory) {
            if (userName == null || !userName.equals(this.userName)) {
                return;
            }
        }
        try {
            this.pool.close();
        }
        catch (Exception ex) {
            throw new SQLException("Error closing connection pool", ex);
        }
    }

    private void validateLifetime(PooledObject<PooledConnectionAndInfo> p) throws Exception {
        long lifetimeMillis;
        if (this.maxConnLifetimeMillis > 0L && (lifetimeMillis = System.currentTimeMillis() - p.getCreateTime()) > this.maxConnLifetimeMillis) {
            throw new Exception(Utils.getMessage("connectionFactory.lifetimeExceeded", lifetimeMillis, this.maxConnLifetimeMillis));
        }
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("[cpds=");
        builder.append(this.cpds);
        builder.append(", validationQuery=");
        builder.append(this.validationQuery);
        builder.append(", validationQueryTimeoutSeconds=");
        builder.append(this.validationQueryTimeoutSeconds);
        builder.append(", rollbackAfterValidation=");
        builder.append(this.rollbackAfterValidation);
        builder.append(", pool=");
        builder.append(this.pool);
        builder.append(", maxConnLifetimeMillis=");
        builder.append(this.maxConnLifetimeMillis);
        builder.append(", validatingSet=");
        builder.append(this.validatingSet);
        builder.append(", pcMap=");
        builder.append(this.pcMap);
        builder.append(']');
        return builder.toString();
    }
}

