/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import org.apache.cassandra.utils.SigarLibrary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HeapUtils {
    private static final Logger logger = LoggerFactory.getLogger(HeapUtils.class);

    public static void logHeapHistogram() {
        try {
            logger.info("Trying to log the heap histogram using jmap");
            Long processId = HeapUtils.getProcessId();
            if (processId == null) {
                logger.error("The process ID could not be retrieved. Skipping heap histogram generation.");
                return;
            }
            String jmapPath = HeapUtils.getJmapPath();
            String jmapCommand = jmapPath == null ? "jmap" : jmapPath;
            String[] histoCommands = new String[]{jmapCommand, "-histo", processId.toString()};
            HeapUtils.logProcessOutput(Runtime.getRuntime().exec(histoCommands));
        }
        catch (Throwable e) {
            logger.error("The heap histogram could not be generated due to the following error: ", e);
        }
    }

    private static String getJmapPath() {
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            return null;
        }
        File javaBinDirectory = new File(javaHome, "bin");
        Object[] files = javaBinDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("jmap");
            }
        });
        return ArrayUtils.isEmpty((Object[])files) ? null : ((File)files[0]).getPath();
    }

    private static void logProcessOutput(Process p) throws IOException {
        String line;
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        StrBuilder builder = new StrBuilder();
        while ((line = input.readLine()) != null) {
            builder.appendln(line);
        }
        logger.info(builder.toString());
    }

    private static Long getProcessId() {
        long pid = SigarLibrary.instance.getPid();
        if (pid >= 0L) {
            return pid;
        }
        return HeapUtils.getProcessIdFromJvmName();
    }

    private static Long getProcessIdFromJvmName() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        try {
            return Long.parseLong(jvmName.split("@")[0]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private HeapUtils() {
    }
}

