/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import org.hyperic.sigar.ResourceLimit;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.jmx.SigarInvokerJMX;

public class Ulimit
extends SigarCommandBase {
    private SigarInvokerJMX invoker;
    private String mode;

    public Ulimit(Shell shell) {
        super(shell);
    }

    public Ulimit() {
    }

    public String getUsageShort() {
        return "Display system resource limits";
    }

    protected boolean validateArgs(String[] args) {
        return true;
    }

    private static String format(long val) {
        if (val == ResourceLimit.INFINITY()) {
            return "unlimited";
        }
        return String.valueOf(val);
    }

    private String getValue(String attr) throws SigarException {
        Long val = (Long)this.invoker.invoke(attr + this.mode);
        return Ulimit.format(val);
    }

    public void output(String[] args) throws SigarException {
        this.mode = "Cur";
        this.invoker = SigarInvokerJMX.getInstance(this.proxy, "Type=ResourceLimit");
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-H")) {
                this.mode = "Max";
                continue;
            }
            if (arg.equals("-S")) {
                this.mode = "Cur";
                continue;
            }
            throw new SigarException("Unknown argument: " + arg);
        }
        this.println("core file size......." + this.getValue("Core"));
        this.println("data seg size........" + this.getValue("Data"));
        this.println("file size............" + this.getValue("FileSize"));
        this.println("pipe size............" + this.getValue("PipeSize"));
        this.println("max memory size......" + this.getValue("Memory"));
        this.println("open files..........." + this.getValue("OpenFiles"));
        this.println("stack size..........." + this.getValue("Stack"));
        this.println("cpu time............." + this.getValue("Cpu"));
        this.println("max user processes..." + this.getValue("Processes"));
        this.println("virtual memory......." + this.getValue("VirtualMemory"));
    }

    public static void main(String[] args) throws Exception {
        new Ulimit().processCommand(args);
    }
}

