/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.attribute.AttributeSignature;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.layout.block.BlockLayoutBlock;
import jd.core.model.layout.block.ByteCodeLayoutBlock;
import jd.core.model.layout.block.CommentDeprecatedLayoutBlock;
import jd.core.model.layout.block.CommentErrorLayoutBlock;
import jd.core.model.layout.block.ExtendsSuperInterfacesLayoutBlock;
import jd.core.model.layout.block.ExtendsSuperTypeLayoutBlock;
import jd.core.model.layout.block.FieldNameLayoutBlock;
import jd.core.model.layout.block.FragmentLayoutBlock;
import jd.core.model.layout.block.ImplementsInterfacesLayoutBlock;
import jd.core.model.layout.block.ImportsLayoutBlock;
import jd.core.model.layout.block.InnerTypeBodyBlockEndLayoutBlock;
import jd.core.model.layout.block.InnerTypeBodyBlockStartLayoutBlock;
import jd.core.model.layout.block.LayoutBlock;
import jd.core.model.layout.block.MarkerLayoutBlock;
import jd.core.model.layout.block.MethodBodyBlockEndLayoutBlock;
import jd.core.model.layout.block.MethodBodyBlockStartLayoutBlock;
import jd.core.model.layout.block.MethodBodySingleLineBlockEndLayoutBlock;
import jd.core.model.layout.block.MethodNameLayoutBlock;
import jd.core.model.layout.block.MethodStaticLayoutBlock;
import jd.core.model.layout.block.PackageLayoutBlock;
import jd.core.model.layout.block.SeparatorLayoutBlock;
import jd.core.model.layout.block.SubListLayoutBlock;
import jd.core.model.layout.block.ThrowsLayoutBlock;
import jd.core.model.layout.block.TypeBodyBlockEndLayoutBlock;
import jd.core.model.layout.block.TypeBodyBlockStartLayoutBlock;
import jd.core.model.layout.block.TypeNameLayoutBlock;
import jd.core.model.layout.section.LayoutSection;
import jd.core.model.reference.Reference;
import jd.core.model.reference.ReferenceMap;
import jd.core.preferences.Preferences;
import jd.core.process.layouter.AnnotationLayouter;
import jd.core.process.layouter.JavaSourceLayouter;
import jd.core.process.layouter.LayoutBlockComparator;
import jd.core.process.layouter.SignatureLayouter;
import jd.core.process.layouter.visitor.InstructionSplitterVisitor;
import jd.core.process.layouter.visitor.MaxLineNumberVisitor;
import jd.core.util.ClassFileUtil;
import jd.core.util.SignatureUtil;
import jd.core.util.TypeNameUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFileLayouter {
    public static int Layout(Preferences preferences, ReferenceMap referenceMap, ClassFile classFile, ArrayList<LayoutBlock> layoutBlockList) {
        int maxLineNumber = ClassFileLayouter.CreateBlocks(preferences, referenceMap, classFile, layoutBlockList);
        if (maxLineNumber != Instruction.UNKNOWN_LINE_NUMBER && preferences.getRealignmentLineNumber()) {
            ClassFileLayouter.LayoutBlocks(layoutBlockList);
        }
        return maxLineNumber;
    }

    private static int CreateBlocks(Preferences preferences, ReferenceMap referenceMap, ClassFile classFile, ArrayList<LayoutBlock> layoutBlockList) {
        int importCount;
        boolean separator = true;
        String internalPackageName = classFile.getInternalPackageName();
        if (internalPackageName != null && internalPackageName.length() > 0) {
            layoutBlockList.add(new PackageLayoutBlock(classFile));
            layoutBlockList.add(new SeparatorLayoutBlock(2, 2));
            separator = false;
        }
        if ((importCount = ClassFileLayouter.GetImportCount(referenceMap, classFile)) > 0) {
            layoutBlockList.add(new ImportsLayoutBlock(classFile, importCount - 1));
            layoutBlockList.add(new SeparatorLayoutBlock(4, 2));
            separator = false;
        }
        if (separator) {
            layoutBlockList.add(new SeparatorLayoutBlock(3, 0));
        }
        return ClassFileLayouter.CreateBlocksForClass(preferences, classFile, layoutBlockList);
    }

    private static int GetImportCount(ReferenceMap referenceMap, ClassFile classFile) {
        Collection<Reference> collection = referenceMap.values();
        if (collection.size() > 0) {
            int importCount = 0;
            String internalPackageName = classFile.getInternalPackageName();
            Iterator<Reference> iterator = collection.iterator();
            while (iterator.hasNext()) {
                String internalReferencePackageName = TypeNameUtil.InternalTypeNameToInternalPackageName(iterator.next().getInternalName());
                if (internalReferencePackageName.equals(internalPackageName) || internalReferencePackageName.equals("java/lang")) continue;
                ++importCount;
            }
            return importCount;
        }
        return 0;
    }

    private static int CreateBlocksForClass(Preferences preferences, ClassFile classFile, List<LayoutBlock> layoutBlockList) {
        MarkerLayoutBlock tmelb;
        MarkerLayoutBlock tmslb = new MarkerLayoutBlock(7, classFile);
        layoutBlockList.add(tmslb);
        boolean displayExtendsOrImplementsFlag = ClassFileLayouter.CreateBlocksForHeader(classFile, layoutBlockList);
        TypeBodyBlockStartLayoutBlock bbslb = new TypeBodyBlockStartLayoutBlock();
        layoutBlockList.add(bbslb);
        int layoutBlockListLength = layoutBlockList.size();
        int maxLineNumber = ClassFileLayouter.CreateBlocksForBody(preferences, classFile, layoutBlockList, displayExtendsOrImplementsFlag);
        if (layoutBlockListLength == layoutBlockList.size()) {
            if (displayExtendsOrImplementsFlag) {
                bbslb.transformToStartEndBlock(1);
            } else {
                bbslb.transformToStartEndBlock(0);
            }
        } else {
            TypeBodyBlockEndLayoutBlock bbelb = new TypeBodyBlockEndLayoutBlock();
            bbslb.other = bbelb;
            bbelb.other = bbslb;
            layoutBlockList.add(bbelb);
        }
        tmslb.other = tmelb = new MarkerLayoutBlock(8, classFile);
        tmelb.other = tmslb;
        layoutBlockList.add(tmelb);
        return maxLineNumber;
    }

    private static boolean CreateBlocksForHeader(ClassFile classFile, List<LayoutBlock> layoutBlockList) {
        boolean displayExtendsOrImplementsFlag = false;
        if (classFile.containsAttributeDeprecated() && !classFile.containsAnnotationDeprecated(classFile)) {
            layoutBlockList.add(new CommentDeprecatedLayoutBlock());
        }
        AnnotationLayouter.CreateBlocksForAnnotations(classFile, classFile.getAttributes(), layoutBlockList);
        AttributeSignature as = classFile.getAttributeSignature();
        if (as == null) {
            layoutBlockList.add(new TypeNameLayoutBlock(classFile));
            if ((classFile.access_flags & 0x2000) == 0) {
                if ((classFile.access_flags & 0x4000) != 0) {
                    displayExtendsOrImplementsFlag = ClassFileLayouter.CreateBlocksForInterfacesImplements(classFile, layoutBlockList);
                } else if ((classFile.access_flags & 0x200) != 0) {
                    int[] interfaceIndexes = classFile.getInterfaces();
                    if (interfaceIndexes != null && interfaceIndexes.length > 0) {
                        displayExtendsOrImplementsFlag = true;
                        layoutBlockList.add(new ExtendsSuperInterfacesLayoutBlock(classFile));
                    }
                } else {
                    String internalSuperClassName = classFile.getSuperClassName();
                    if (internalSuperClassName != null && !"java/lang/Object".equals(internalSuperClassName)) {
                        displayExtendsOrImplementsFlag = true;
                        layoutBlockList.add(new ExtendsSuperTypeLayoutBlock(classFile));
                    }
                    displayExtendsOrImplementsFlag |= ClassFileLayouter.CreateBlocksForInterfacesImplements(classFile, layoutBlockList);
                }
            }
        } else {
            ConstantPool constants = classFile.getConstantPool();
            String signature = constants.getConstantUtf8(as.signature_index);
            displayExtendsOrImplementsFlag = SignatureLayouter.CreateLayoutBlocksForClassSignature(classFile, signature, layoutBlockList);
        }
        return displayExtendsOrImplementsFlag;
    }

    private static boolean CreateBlocksForInterfacesImplements(ClassFile classFile, List<LayoutBlock> layoutBlockList) {
        int[] interfaceIndexes = classFile.getInterfaces();
        if (interfaceIndexes != null && interfaceIndexes.length > 0) {
            layoutBlockList.add(new ImplementsInterfacesLayoutBlock(classFile));
            return true;
        }
        return false;
    }

    public static int CreateBlocksForBodyOfAnonymousClass(Preferences preferences, ClassFile classFile, List<LayoutBlock> layoutBlockList) {
        InnerTypeBodyBlockStartLayoutBlock ibbslb = new InnerTypeBodyBlockStartLayoutBlock();
        layoutBlockList.add(ibbslb);
        int layoutBlockListLength = layoutBlockList.size();
        int maxLineNumber = ClassFileLayouter.CreateBlocksForBody(preferences, classFile, layoutBlockList, false);
        if (layoutBlockListLength == layoutBlockList.size()) {
            ibbslb.transformToStartEndBlock();
        } else {
            InnerTypeBodyBlockEndLayoutBlock ibbelb = new InnerTypeBodyBlockEndLayoutBlock();
            ibbslb.other = ibbelb;
            ibbelb.other = ibbslb;
            layoutBlockList.add(ibbelb);
        }
        return maxLineNumber;
    }

    private static int CreateBlocksForBody(Preferences preferences, ClassFile classFile, List<LayoutBlock> layoutBlockList, boolean displayExtendsOrImplementsFlag) {
        ClassFileLayouter.CreateBlockForEnumValues(preferences, classFile, layoutBlockList);
        List<SubListLayoutBlock> sortedFieldBlockList = ClassFileLayouter.CreateSortedBlocksForFields(preferences, classFile);
        List<SubListLayoutBlock> sortedMethodBlockList = ClassFileLayouter.CreateSortedBlocksForMethods(preferences, classFile);
        List<SubListLayoutBlock> sortedInnerClassBlockList = ClassFileLayouter.CreateSortedBlocksForInnerClasses(preferences, classFile);
        return ClassFileLayouter.MergeBlocks(layoutBlockList, sortedFieldBlockList, sortedMethodBlockList, sortedInnerClassBlockList);
    }

    private static void CreateBlockForEnumValues(Preferences preferences, ClassFile classFile, List<LayoutBlock> layoutBlockList) {
        int valuesLength;
        List<Instruction> values = classFile.getEnumValues();
        if (values != null && (valuesLength = values.size()) > 0) {
            ConstantPool constants = classFile.getConstantPool();
            Field[] fields = classFile.getFields();
            int fieldsLength = fields.length;
            ArrayList<InvokeNew> enumValues = new ArrayList<InvokeNew>(fieldsLength);
            InstructionSplitterVisitor visitor = new InstructionSplitterVisitor();
            int i = 0;
            while (i < valuesLength) {
                GetStatic getStatic = (GetStatic)values.get(i);
                ConstantFieldref cfr = constants.getConstantFieldref(getStatic.index);
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
                int j = fields.length;
                while (j-- > 0) {
                    Field field = fields[j];
                    if (field.name_index != cnat.name_index || field.descriptor_index != cnat.descriptor_index) continue;
                    Field.ValueAndMethod vam = field.getValueAndMethod();
                    InvokeNew invokeNew = (InvokeNew)vam.getValue();
                    invokeNew.transformToEnumValue(getStatic);
                    enumValues.add(invokeNew);
                    break;
                }
                ++i;
            }
            int length = enumValues.size();
            if (length > 0) {
                InvokeNew enumValue = (InvokeNew)enumValues.get(0);
                visitor.start(preferences, layoutBlockList, classFile, classFile.getStaticMethod(), enumValue);
                visitor.visit(enumValue);
                visitor.end();
                int i2 = 1;
                while (i2 < length) {
                    layoutBlockList.add(new FragmentLayoutBlock(85));
                    layoutBlockList.add(new SeparatorLayoutBlock(2, 0));
                    enumValue = (InvokeNew)enumValues.get(i2);
                    visitor.start(preferences, layoutBlockList, classFile, classFile.getStaticMethod(), enumValue);
                    visitor.visit(enumValue);
                    visitor.end();
                    ++i2;
                }
                layoutBlockList.add(new FragmentLayoutBlock(82));
            }
        }
    }

    private static List<SubListLayoutBlock> CreateSortedBlocksForFields(Preferences preferences, ClassFile classFile) {
        Field[] fields = classFile.getFields();
        if (fields == null) {
            return Collections.emptyList();
        }
        int length = fields.length;
        ArrayList<SubListLayoutBlock> sortedFieldBlockList = new ArrayList<SubListLayoutBlock>(length);
        InstructionSplitterVisitor visitor = new InstructionSplitterVisitor();
        int i = 0;
        while (i < length) {
            Field field = fields[i];
            if ((field.access_flags & 0x5000) == 0) {
                MarkerLayoutBlock fmelb;
                ArrayList<LayoutBlock> subLayoutBlockList = new ArrayList<LayoutBlock>(6);
                MarkerLayoutBlock fmslb = new MarkerLayoutBlock(9, classFile);
                subLayoutBlockList.add(fmslb);
                if (field.containsAttributeDeprecated() && !field.containsAnnotationDeprecated(classFile)) {
                    subLayoutBlockList.add(new CommentDeprecatedLayoutBlock());
                }
                AnnotationLayouter.CreateBlocksForAnnotations(classFile, field.getAttributes(), subLayoutBlockList);
                subLayoutBlockList.add(new FieldNameLayoutBlock(classFile, field));
                int firstLineNumber = Instruction.UNKNOWN_LINE_NUMBER;
                int lastLineNumber = Instruction.UNKNOWN_LINE_NUMBER;
                int preferedLineNumber = Integer.MAX_VALUE;
                if (field.getValueAndMethod() != null) {
                    Field.ValueAndMethod valueAndMethod = field.getValueAndMethod();
                    Instruction value = valueAndMethod.getValue();
                    Method method = valueAndMethod.getMethod();
                    firstLineNumber = value.lineNumber;
                    lastLineNumber = MaxLineNumberVisitor.visit(value);
                    preferedLineNumber = lastLineNumber - firstLineNumber;
                    visitor.start(preferences, subLayoutBlockList, classFile, method, value);
                    visitor.visit(value);
                    visitor.end();
                    subLayoutBlockList.add(new FragmentLayoutBlock(82));
                }
                fmslb.other = fmelb = new MarkerLayoutBlock(10, classFile);
                fmelb.other = fmslb;
                subLayoutBlockList.add(fmelb);
                sortedFieldBlockList.add(new SubListLayoutBlock(58, subLayoutBlockList, firstLineNumber, lastLineNumber, preferedLineNumber));
            }
            ++i;
        }
        return ClassFileLayouter.SortBlocks(sortedFieldBlockList);
    }

    /*
     * Unable to fully structure code
     */
    private static List<SubListLayoutBlock> CreateSortedBlocksForMethods(Preferences preferences, ClassFile classFile) {
        methods = classFile.getMethods();
        if (methods == null) {
            return Collections.emptyList();
        }
        constants = classFile.getConstantPool();
        multipleConstructorFlag = ClassFileUtil.ContainsMultipleConstructor(classFile);
        length = methods.length;
        sortedMethodBlockList = new ArrayList<SubListLayoutBlock>(length);
        showDefaultConstructor = preferences.getShowDefaultConstructor();
        javaSourceLayouter = new JavaSourceLayouter();
        i = 0;
        while (i < length) {
            method = methods[i];
            if ((method.access_flags & 4160) == 0) {
                as = method.getAttributeSignature();
                descriptorFlag = as == null;
                signatureIndex = descriptorFlag != false ? method.descriptor_index : as.signature_index;
                signature = constants.getConstantUtf8(signatureIndex);
                if (!((classFile.access_flags & 16384) != 0 && ClassFileUtil.IsAMethodOfEnum(classFile, method, signature) || method.name_index == constants.instanceConstructorIndex && (classFile.getInternalAnonymousClassName() != null || !(multipleConstructorFlag != false || method.getFastNodes() != null && method.getFastNodes().size() != 0 || (exceptionIndexes = method.getExceptionIndexes()) != null && exceptionIndexes.length != 0) && ((classFile.access_flags & 16384) == 0 ? showDefaultConstructor == false && signature.equals("()V") != false : SignatureUtil.GetParameterSignatureCount(signature) == 2)))) {
                    if (method.name_index != constants.classConstructorIndex || method.getFastNodes() != null && method.getFastNodes().size() != 0) {
                        subLayoutBlockList = new ArrayList<LayoutBlock>(30);
                        mmslb = new MarkerLayoutBlock(11, classFile);
                        subLayoutBlockList.add(mmslb);
                        if (method.containsError()) {
                            subLayoutBlockList.add(new CommentErrorLayoutBlock());
                        }
                        if (method.containsAttributeDeprecated() && !method.containsAnnotationDeprecated(classFile)) {
                            subLayoutBlockList.add(new CommentDeprecatedLayoutBlock());
                        }
                        AnnotationLayouter.CreateBlocksForAnnotations(classFile, method.getAttributes(), subLayoutBlockList);
                        nullCodeFlag = method.getCode() == null;
                        displayThrowsFlag = false;
                        if (method.name_index == constants.classConstructorIndex) {
                            subLayoutBlockList.add(new MethodStaticLayoutBlock(classFile));
                        } else if (method.getExceptionIndexes() == null) {
                            subLayoutBlockList.add(new MethodNameLayoutBlock(classFile, method, signature, descriptorFlag, nullCodeFlag));
                        } else {
                            subLayoutBlockList.add(new MethodNameLayoutBlock(classFile, method, signature, descriptorFlag, false));
                            subLayoutBlockList.add(new ThrowsLayoutBlock(classFile, method, nullCodeFlag));
                            displayThrowsFlag = true;
                        }
                        firstLineNumber = Instruction.UNKNOWN_LINE_NUMBER;
                        lastLineNumber = Instruction.UNKNOWN_LINE_NUMBER;
                        preferedLineNumber = 0x7FFFFFFF;
                        if (!nullCodeFlag) {
                            if (method.containsError()) {
                                mbbslb = new MethodBodyBlockStartLayoutBlock();
                                subLayoutBlockList.add(mbbslb);
                                subLayoutBlockList.add(new ByteCodeLayoutBlock(classFile, method));
                                mbbelb = new MethodBodyBlockEndLayoutBlock();
                                subLayoutBlockList.add(mbbelb);
                                mbbslb.other = mbbelb;
                                mbbelb.other = mbbslb;
                            } else {
                                block24: {
                                    list = method.getFastNodes();
                                    mbbslb = new MethodBodyBlockStartLayoutBlock();
                                    subLayoutBlockList.add(mbbslb);
                                    subLayoutBlockListLength = subLayoutBlockList.size();
                                    singleLine = false;
                                    if (list.size() > 0) {
                                        try {
                                            beforeIndex = subLayoutBlockList.size();
                                            singleLine = javaSourceLayouter.createBlocks(preferences, subLayoutBlockList, classFile, method, list);
                                            afterIndex = subLayoutBlockList.size();
                                            firstLineNumber = ClassFileLayouter.SearchFirstLineNumber(subLayoutBlockList, beforeIndex, afterIndex);
                                            lastLineNumber = ClassFileLayouter.SearchLastLineNumber(subLayoutBlockList, beforeIndex, afterIndex);
                                            break block24;
                                        }
                                        catch (Exception e) {
                                            currentLength = subLayoutBlockList.size();
                                            ** while (currentLength > subLayoutBlockListLength)
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            subLayoutBlockList.remove(--currentLength);
                                            continue;
                                        }
lbl82:
                                        // 1 sources

                                        subLayoutBlockList.add(new ByteCodeLayoutBlock(classFile, method));
                                    }
                                }
                                if (subLayoutBlockListLength == subLayoutBlockList.size()) {
                                    if (displayThrowsFlag) {
                                        mbbslb.transformToStartEndBlock(1);
                                    } else {
                                        mbbslb.transformToStartEndBlock(0);
                                    }
                                } else if (singleLine) {
                                    mbbslb.transformToSingleLineBlock();
                                    mbssbelb = new MethodBodySingleLineBlockEndLayoutBlock();
                                    mbbslb.other = mbssbelb;
                                    mbssbelb.other = mbbslb;
                                    subLayoutBlockList.add(mbssbelb);
                                } else {
                                    mbbelb = new MethodBodyBlockEndLayoutBlock();
                                    mbbslb.other = mbbelb;
                                    mbbelb.other = mbbslb;
                                    subLayoutBlockList.add(mbbelb);
                                }
                            }
                        }
                        mmslb.other = mmelb = new MarkerLayoutBlock(12, classFile);
                        mmelb.other = mmslb;
                        subLayoutBlockList.add(mmelb);
                        sortedMethodBlockList.add(new SubListLayoutBlock(59, subLayoutBlockList, firstLineNumber, lastLineNumber, preferedLineNumber));
                    }
                }
            }
            ++i;
        }
        return ClassFileLayouter.SortBlocks(sortedMethodBlockList);
    }

    private static List<SubListLayoutBlock> CreateSortedBlocksForInnerClasses(Preferences preferences, ClassFile classFile) {
        ArrayList<ClassFile> innerClassFiles = classFile.getInnerClassFiles();
        if (innerClassFiles == null) {
            return Collections.emptyList();
        }
        int length = innerClassFiles.size();
        ArrayList<SubListLayoutBlock> sortedInnerClassBlockList = new ArrayList<SubListLayoutBlock>(length);
        int i = 0;
        while (i < length) {
            ClassFile innerClassFile = innerClassFiles.get(i);
            if ((innerClassFile.access_flags & 0x1000) == 0 && innerClassFile.getInternalAnonymousClassName() == null) {
                ArrayList<LayoutBlock> innerClassLayoutBlockList = new ArrayList<LayoutBlock>(100);
                ClassFileLayouter.CreateBlocksForClass(preferences, innerClassFile, innerClassLayoutBlockList);
                int afterIndex = innerClassLayoutBlockList.size();
                int firstLineNumber = ClassFileLayouter.SearchFirstLineNumber(innerClassLayoutBlockList, 0, afterIndex);
                int lastLineNumber = ClassFileLayouter.SearchLastLineNumber(innerClassLayoutBlockList, 0, afterIndex);
                int preferedLineCount = Integer.MAX_VALUE;
                if (firstLineNumber != Instruction.UNKNOWN_LINE_NUMBER && lastLineNumber != Instruction.UNKNOWN_LINE_NUMBER) {
                    preferedLineCount = lastLineNumber - firstLineNumber;
                }
                sortedInnerClassBlockList.add(new SubListLayoutBlock(60, innerClassLayoutBlockList, firstLineNumber, lastLineNumber, preferedLineCount));
            }
            ++i;
        }
        return ClassFileLayouter.SortBlocks(sortedInnerClassBlockList);
    }

    private static int SearchFirstLineNumber(List<LayoutBlock> layoutBlockList, int firstIndex, int afterIndex) {
        int index = firstIndex;
        while (index < afterIndex) {
            int firstLineNumber = layoutBlockList.get((int)index).firstLineNumber;
            if (firstLineNumber != Instruction.UNKNOWN_LINE_NUMBER) {
                return firstLineNumber;
            }
            ++index;
        }
        return Instruction.UNKNOWN_LINE_NUMBER;
    }

    private static int SearchLastLineNumber(List<LayoutBlock> layoutBlockList, int firstIndex, int afterIndex) {
        while (afterIndex-- > firstIndex) {
            int lastLineNumber = layoutBlockList.get((int)afterIndex).lastLineNumber;
            if (lastLineNumber == Instruction.UNKNOWN_LINE_NUMBER) continue;
            return lastLineNumber;
        }
        return Instruction.UNKNOWN_LINE_NUMBER;
    }

    private static List<SubListLayoutBlock> SortBlocks(List<SubListLayoutBlock> blockList) {
        int length = blockList.size();
        int lineNumber = Instruction.UNKNOWN_LINE_NUMBER;
        int order = 0;
        int i = 0;
        while (i < length) {
            SubListLayoutBlock layoutBlock = blockList.get(i);
            int newLineNumber = layoutBlock.lastLineNumber;
            if (newLineNumber != Instruction.UNKNOWN_LINE_NUMBER) {
                if (lineNumber != Instruction.UNKNOWN_LINE_NUMBER) {
                    if (order == 0) {
                        order = lineNumber < newLineNumber ? 1 : 2;
                    } else if (order == 1) {
                        if (lineNumber > newLineNumber) {
                            order = 3;
                            break;
                        }
                    } else if (order == 2 && lineNumber < newLineNumber) {
                        order = 3;
                        break;
                    }
                }
                lineNumber = newLineNumber;
            }
            ++i;
        }
        switch (order) {
            case 2: {
                Collections.reverse(blockList);
                break;
            }
            case 3: {
                i = 0;
                while (i < length) {
                    blockList.get((int)i).index = i;
                    ++i;
                }
                Collections.sort(blockList, new LayoutBlockComparator());
            }
        }
        return blockList;
    }

    private static int MergeBlocks(List<LayoutBlock> layoutBlockList, List<SubListLayoutBlock> sortedFieldBlockList, List<SubListLayoutBlock> sortedMethodBlockList, List<SubListLayoutBlock> sortedInnerClassBlockList) {
        int maxLineNumber = Instruction.UNKNOWN_LINE_NUMBER;
        Collections.reverse(sortedFieldBlockList);
        Collections.reverse(sortedMethodBlockList);
        Collections.reverse(sortedInnerClassBlockList);
        int minLineNumberMethod = ClassFileLayouter.SearchMinimalLineNumber(sortedMethodBlockList);
        int minLineNumberInnerClass = ClassFileLayouter.SearchMinimalLineNumber(sortedInnerClassBlockList);
        while (sortedFieldBlockList.size() > 0) {
            if (minLineNumberMethod == Instruction.UNKNOWN_LINE_NUMBER) {
                if (minLineNumberInnerClass == Instruction.UNKNOWN_LINE_NUMBER) {
                    maxLineNumber = ClassFileLayouter.MergeFieldBlockList(layoutBlockList, sortedFieldBlockList, maxLineNumber);
                    break;
                }
                maxLineNumber = ClassFileLayouter.ExclusiveMergeFieldBlockList(layoutBlockList, sortedFieldBlockList, minLineNumberInnerClass, maxLineNumber);
                maxLineNumber = ClassFileLayouter.MergeBlockList(layoutBlockList, sortedMethodBlockList, maxLineNumber);
                maxLineNumber = ClassFileLayouter.InclusiveMergeBlockList(layoutBlockList, sortedInnerClassBlockList, minLineNumberInnerClass, maxLineNumber);
                minLineNumberInnerClass = ClassFileLayouter.SearchMinimalLineNumber(sortedInnerClassBlockList);
                continue;
            }
            if (minLineNumberInnerClass == Instruction.UNKNOWN_LINE_NUMBER || minLineNumberMethod < minLineNumberInnerClass) {
                maxLineNumber = ClassFileLayouter.ExclusiveMergeFieldBlockList(layoutBlockList, sortedFieldBlockList, minLineNumberMethod, maxLineNumber);
                maxLineNumber = ClassFileLayouter.InclusiveMergeBlockList(layoutBlockList, sortedMethodBlockList, minLineNumberMethod, maxLineNumber);
                minLineNumberMethod = ClassFileLayouter.SearchMinimalLineNumber(sortedMethodBlockList);
                continue;
            }
            maxLineNumber = ClassFileLayouter.ExclusiveMergeFieldBlockList(layoutBlockList, sortedFieldBlockList, minLineNumberInnerClass, maxLineNumber);
            maxLineNumber = ClassFileLayouter.ExclusiveMergeMethodOrInnerClassBlockList(layoutBlockList, sortedMethodBlockList, minLineNumberInnerClass, maxLineNumber);
            maxLineNumber = ClassFileLayouter.InclusiveMergeBlockList(layoutBlockList, sortedInnerClassBlockList, minLineNumberInnerClass, maxLineNumber);
            minLineNumberInnerClass = ClassFileLayouter.SearchMinimalLineNumber(sortedInnerClassBlockList);
        }
        while (sortedMethodBlockList.size() > 0) {
            if (minLineNumberInnerClass == Instruction.UNKNOWN_LINE_NUMBER) {
                maxLineNumber = ClassFileLayouter.MergeBlockList(layoutBlockList, sortedMethodBlockList, maxLineNumber);
                break;
            }
            maxLineNumber = ClassFileLayouter.ExclusiveMergeMethodOrInnerClassBlockList(layoutBlockList, sortedMethodBlockList, minLineNumberInnerClass, maxLineNumber);
            maxLineNumber = ClassFileLayouter.InclusiveMergeBlockList(layoutBlockList, sortedInnerClassBlockList, minLineNumberInnerClass, maxLineNumber);
            minLineNumberInnerClass = ClassFileLayouter.SearchMinimalLineNumber(sortedInnerClassBlockList);
        }
        maxLineNumber = ClassFileLayouter.MergeBlockList(layoutBlockList, sortedInnerClassBlockList, maxLineNumber);
        return maxLineNumber;
    }

    private static int ExclusiveMergeMethodOrInnerClassBlockList(List<LayoutBlock> destination, List<SubListLayoutBlock> source, int minLineNumber, int maxLineNumber) {
        byte lastTag = destination.get((int)(destination.size() - 1)).tag;
        int index = source.size();
        while (index > 0) {
            SubListLayoutBlock sllb = source.get(index - 1);
            int lineNumber = sllb.lastLineNumber;
            if (lineNumber != Instruction.UNKNOWN_LINE_NUMBER && lineNumber >= minLineNumber) break;
            switch (lastTag) {
                case 10: {
                    destination.add(new SeparatorLayoutBlock(2, 1));
                    break;
                }
                case 2: 
                case 13: 
                case 16: 
                case 19: 
                case 22: 
                case 25: 
                case 31: {
                    break;
                }
                default: {
                    destination.add(new SeparatorLayoutBlock(2, 2));
                }
            }
            destination.addAll(sllb.subList);
            int lastLineNumber = sllb.lastLineNumber;
            if (lastLineNumber != Instruction.UNKNOWN_LINE_NUMBER && (maxLineNumber == Instruction.UNKNOWN_LINE_NUMBER || maxLineNumber < lastLineNumber)) {
                maxLineNumber = lastLineNumber;
            }
            source.remove(--index);
            lastTag = 0;
        }
        return maxLineNumber;
    }

    private static int ExclusiveMergeFieldBlockList(List<LayoutBlock> destination, List<SubListLayoutBlock> source, int minLineNumber, int maxLineNumber) {
        int lastTag = destination.get((int)(destination.size() - 1)).tag;
        int index = source.size();
        while (index > 0) {
            SubListLayoutBlock sllb = source.get(index - 1);
            int lineNumber = sllb.lastLineNumber;
            if (lineNumber != Instruction.UNKNOWN_LINE_NUMBER && lineNumber >= minLineNumber) break;
            switch (lastTag) {
                case 10: {
                    destination.add(new SeparatorLayoutBlock(2, 1));
                    break;
                }
                case 2: 
                case 13: 
                case 16: 
                case 19: 
                case 22: 
                case 25: 
                case 31: {
                    break;
                }
                default: {
                    destination.add(new SeparatorLayoutBlock(2, 2));
                }
            }
            source.remove(--index);
            destination.addAll(sllb.subList);
            int lastLineNumber = sllb.lastLineNumber;
            if (lastLineNumber != Instruction.UNKNOWN_LINE_NUMBER && (maxLineNumber == Instruction.UNKNOWN_LINE_NUMBER || maxLineNumber < lastLineNumber)) {
                maxLineNumber = lastLineNumber;
            }
            lastTag = 10;
        }
        return maxLineNumber;
    }

    private static int InclusiveMergeBlockList(List<LayoutBlock> destination, List<SubListLayoutBlock> source, int minLineNumber, int maxLineNumber) {
        byte lastTag = destination.get((int)(destination.size() - 1)).tag;
        int index = source.size();
        while (index > 0) {
            SubListLayoutBlock sllb = source.get(index - 1);
            int lineNumber = sllb.lastLineNumber;
            if (lineNumber != Instruction.UNKNOWN_LINE_NUMBER && lineNumber > minLineNumber) break;
            switch (lastTag) {
                case 2: 
                case 13: 
                case 16: 
                case 19: 
                case 22: 
                case 25: 
                case 31: {
                    break;
                }
                default: {
                    destination.add(new SeparatorLayoutBlock(2, 2));
                }
            }
            destination.addAll(sllb.subList);
            int lastLineNumber = sllb.lastLineNumber;
            if (lastLineNumber != Instruction.UNKNOWN_LINE_NUMBER && (maxLineNumber == Instruction.UNKNOWN_LINE_NUMBER || maxLineNumber < lastLineNumber)) {
                maxLineNumber = lastLineNumber;
            }
            source.remove(--index);
            if (lineNumber == minLineNumber) break;
            lastTag = 0;
        }
        return maxLineNumber;
    }

    private static int MergeBlockList(List<LayoutBlock> destination, List<SubListLayoutBlock> source, int maxLineNumber) {
        byte lastTag = destination.get((int)(destination.size() - 1)).tag;
        int index = source.size();
        while (index-- > 0) {
            switch (lastTag) {
                case 2: 
                case 13: 
                case 16: 
                case 19: 
                case 22: 
                case 25: 
                case 31: {
                    break;
                }
                default: {
                    destination.add(new SeparatorLayoutBlock(2, 2));
                }
            }
            SubListLayoutBlock sllb = source.remove(index);
            destination.addAll(sllb.subList);
            int lastLineNumber = sllb.lastLineNumber;
            if (lastLineNumber != Instruction.UNKNOWN_LINE_NUMBER && (maxLineNumber == Instruction.UNKNOWN_LINE_NUMBER || maxLineNumber < lastLineNumber)) {
                maxLineNumber = lastLineNumber;
            }
            lastTag = 0;
        }
        return maxLineNumber;
    }

    private static int MergeFieldBlockList(List<LayoutBlock> destination, List<SubListLayoutBlock> source, int maxLineNumber) {
        int lastTag = destination.get((int)(destination.size() - 1)).tag;
        int index = source.size();
        while (index-- > 0) {
            switch (lastTag) {
                case 10: {
                    destination.add(new SeparatorLayoutBlock(2, 1));
                    break;
                }
                case 2: 
                case 13: 
                case 16: 
                case 19: 
                case 22: 
                case 25: 
                case 31: {
                    break;
                }
                default: {
                    destination.add(new SeparatorLayoutBlock(2, 2));
                }
            }
            SubListLayoutBlock sllb = source.remove(index);
            destination.addAll(sllb.subList);
            int lastLineNumber = sllb.lastLineNumber;
            if (lastLineNumber != Instruction.UNKNOWN_LINE_NUMBER && (maxLineNumber == Instruction.UNKNOWN_LINE_NUMBER || maxLineNumber < lastLineNumber)) {
                maxLineNumber = lastLineNumber;
            }
            lastTag = 10;
        }
        return maxLineNumber;
    }

    private static int SearchMinimalLineNumber(List<? extends LayoutBlock> list) {
        int index = list.size();
        while (index-- > 0) {
            int lineNumber = list.get((int)index).lastLineNumber;
            if (lineNumber == Instruction.UNKNOWN_LINE_NUMBER) continue;
            return lineNumber;
        }
        return Instruction.UNKNOWN_LINE_NUMBER;
    }

    private static void LayoutBlocks(ArrayList<LayoutBlock> layoutBlockList) {
        ArrayList<LayoutSection> layoutSectionList = new ArrayList<LayoutSection>();
        ClassFileLayouter.CreateSections(layoutBlockList, layoutSectionList);
        ClassFileLayouter.InitializeBlocks(layoutBlockList, layoutSectionList);
        int layoutCount = 20;
        do {
            ClassFileLayouter.LayoutSections(layoutBlockList, layoutSectionList);
            ClassFileLayouter.ScoreSections(layoutBlockList, layoutSectionList);
            if (!ClassFileLayouter.SliceDownBlocks(layoutBlockList, layoutSectionList)) break;
            ClassFileLayouter.ResetLineCounts(layoutBlockList, layoutSectionList);
        } while (layoutCount-- > 0);
        layoutCount = 20;
        do {
            ClassFileLayouter.LayoutSections(layoutBlockList, layoutSectionList);
            ClassFileLayouter.ScoreSections(layoutBlockList, layoutSectionList);
            if (!ClassFileLayouter.SliceUpBlocks(layoutBlockList, layoutSectionList)) break;
            ClassFileLayouter.ResetLineCounts(layoutBlockList, layoutSectionList);
        } while (layoutCount-- > 0);
    }

    private static void CreateSections(ArrayList<LayoutBlock> layoutBlockList, ArrayList<LayoutSection> layoutSectionList) {
        int blockLength = layoutBlockList.size();
        int layoutSectionListSize = 0;
        int firstBlockIndex = 0;
        int firstLineNumber = 1;
        boolean containsError = false;
        int blockIndex = 1;
        while (blockIndex < blockLength) {
            LayoutBlock lb = layoutBlockList.get(blockIndex);
            if (lb.tag == 56) {
                containsError = true;
            }
            if (lb.firstLineNumber != Instruction.UNKNOWN_LINE_NUMBER) {
                if (firstLineNumber > lb.firstLineNumber) {
                    containsError = true;
                }
                layoutSectionList.add(new LayoutSection(layoutSectionListSize++, firstBlockIndex, blockIndex - 1, firstLineNumber, lb.firstLineNumber, containsError));
                firstBlockIndex = blockIndex + 1;
                firstLineNumber = lb.lastLineNumber;
                containsError = false;
            }
            ++blockIndex;
        }
        if (firstBlockIndex < blockLength - 1) {
            layoutSectionList.add(new LayoutSection(layoutSectionListSize++, firstBlockIndex, blockLength - 1, firstLineNumber, Instruction.UNKNOWN_LINE_NUMBER, containsError));
        }
    }

    private static void InitializeBlocks(ArrayList<LayoutBlock> layoutBlockList, ArrayList<LayoutSection> layoutSectionList) {
        int blockIndex = 0;
        int sectionLength = layoutSectionList.size();
        int sectionIndex = 0;
        while (sectionIndex < sectionLength) {
            LayoutSection section = layoutSectionList.get(sectionIndex);
            int lastBlockIndex = section.lastBlockIndex;
            blockIndex = section.firstBlockIndex;
            while (blockIndex <= lastBlockIndex) {
                LayoutBlock lb = layoutBlockList.get(blockIndex);
                lb.index = blockIndex++;
                lb.section = section;
            }
            ++sectionIndex;
        }
    }

    private static void ResetLineCounts(ArrayList<LayoutBlock> layoutBlockList, ArrayList<LayoutSection> layoutSectionList) {
        int sectionLength = layoutSectionList.size();
        int sectionIndex = 0;
        while (sectionIndex < sectionLength) {
            LayoutSection section = layoutSectionList.get(sectionIndex);
            if (section.relayout) {
                int lastBlockIndex = section.lastBlockIndex;
                int blockIndex = section.firstBlockIndex;
                while (blockIndex <= lastBlockIndex) {
                    LayoutBlock lb = layoutBlockList.get(blockIndex);
                    lb.lineCount = lb.preferedLineCount;
                    ++blockIndex;
                }
            }
            ++sectionIndex;
        }
    }

    private static void LayoutSections(ArrayList<LayoutBlock> layoutBlockList, ArrayList<LayoutSection> layoutSectionList) {
        int sectionLength = layoutSectionList.size();
        if (sectionLength > 0) {
            int currentLineCount;
            int originalLineCount;
            LayoutSection section;
            int sectionIndex;
            boolean redo;
            --sectionLength;
            int layoutCount = 5;
            do {
                redo = false;
                sectionIndex = 0;
                while (sectionIndex < sectionLength) {
                    section = layoutSectionList.get(sectionIndex);
                    if (section.relayout && !section.containsError) {
                        section.relayout = false;
                        originalLineCount = section.originalLineCount;
                        currentLineCount = ClassFileLayouter.GetLineCount(layoutBlockList, section.firstBlockIndex, section.lastBlockIndex);
                        if (originalLineCount > currentLineCount) {
                            ClassFileLayouter.ExpandBlocksWithHeuristics(layoutBlockList, section.firstBlockIndex, section.lastBlockIndex, originalLineCount - currentLineCount);
                            redo = true;
                        } else if (currentLineCount > originalLineCount) {
                            ClassFileLayouter.CompactBlocksWithHeuristics(layoutBlockList, section.firstBlockIndex, section.lastBlockIndex, currentLineCount - originalLineCount);
                            redo = true;
                        }
                    }
                    ++sectionIndex;
                }
                layoutSectionList.get((int)sectionLength).relayout = false;
            } while (redo && layoutCount-- > 0);
            if (redo) {
                sectionIndex = 0;
                while (sectionIndex < sectionLength) {
                    section = layoutSectionList.get(sectionIndex);
                    if (section.relayout && !section.containsError) {
                        section.relayout = false;
                        originalLineCount = section.originalLineCount;
                        currentLineCount = ClassFileLayouter.GetLineCount(layoutBlockList, section.firstBlockIndex, section.lastBlockIndex);
                        if (originalLineCount > currentLineCount) {
                            ClassFileLayouter.ExpandBlocks(layoutBlockList, section.firstBlockIndex, section.lastBlockIndex, originalLineCount - currentLineCount);
                        } else if (currentLineCount > originalLineCount) {
                            ClassFileLayouter.CompactBlocks(layoutBlockList, section.firstBlockIndex, section.lastBlockIndex, currentLineCount - originalLineCount);
                        }
                    }
                    ++sectionIndex;
                }
                layoutSectionList.get((int)sectionLength).relayout = false;
            }
        }
    }

    private static int GetLineCount(ArrayList<LayoutBlock> layoutBlockList, int firstIndex, int lastIndex) {
        int sum = 0;
        int index = firstIndex;
        while (index <= lastIndex) {
            int lineCount = layoutBlockList.get((int)index).lineCount;
            if (lineCount != Integer.MAX_VALUE) {
                sum += lineCount;
            }
            ++index;
        }
        return sum;
    }

    private static void CompactBlocksWithHeuristics(ArrayList<LayoutBlock> layoutBlockList, int firstIndex, int lastIndex, int delta) {
        BlockLayoutBlock blb;
        LayoutBlock lb;
        int i;
        int oldDelta;
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 2: 
                    case 5: {
                        if (lb.lineCount <= 2) break;
                        --lb.lineCount;
                        --delta;
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 45: 
                    case 49: 
                    case 53: {
                        if (lb.lineCount <= 0) break;
                        --lb.lineCount;
                        --delta;
                    }
                }
                --i;
            }
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 43: 
                    case 44: 
                    case 47: 
                    case 48: {
                        if (lb.lineCount <= 0) break;
                        --lb.lineCount;
                        --delta;
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        i = lastIndex;
        while (i >= firstIndex && delta > 0) {
            lb = layoutBlockList.get(i);
            switch (lb.tag) {
                case 6: {
                    if (lb.lineCount <= 0) break;
                    if (lb.lineCount >= delta) {
                        lb.lineCount -= delta;
                        delta = 0;
                        break;
                    }
                    delta -= lb.lineCount;
                    lb.lineCount = 0;
                }
            }
            --i;
        }
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 13: 
                    case 16: 
                    case 19: 
                    case 22: 
                    case 25: 
                    case 28: 
                    case 31: {
                        if (lb.lineCount <= 1 || lb.lineCount <= lb.minimalLineCount) break;
                        --lb.lineCount;
                        --delta;
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 5: {
                        if (lb.lineCount <= 1) break;
                        --lb.lineCount;
                        --delta;
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 14: 
                    case 17: 
                    case 20: 
                    case 23: 
                    case 26: 
                    case 29: 
                    case 32: {
                        if (lb.lineCount <= 1 || lb.lineCount <= lb.minimalLineCount) break;
                        --lb.lineCount;
                        --delta;
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 65: 
                    case 66: 
                    case 67: {
                        if (lb.lineCount <= 0) break;
                        --lb.lineCount;
                        --delta;
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 29: {
                        if (lb.lineCount <= lb.minimalLineCount) break;
                        --lb.lineCount;
                        --delta;
                    }
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 33: 
                    case 34: {
                        if (lb.lineCount <= 0) break;
                        --lb.lineCount;
                        --delta;
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 22: 
                    case 23: {
                        if (lb.lineCount <= lb.minimalLineCount) break;
                        blb = (BlockLayoutBlock)lb;
                        --lb.lineCount;
                        --delta;
                        if (lb.lineCount > 1) break;
                        if (blb.section == blb.other.section) {
                            if (blb.other.lineCount > delta) {
                                blb.other.lineCount -= delta;
                                delta = 0;
                                break;
                            }
                            delta -= blb.other.lineCount;
                            blb.other.lineCount = 0;
                            break;
                        }
                        blb.other.section.relayout = true;
                        blb.other.lineCount = 0;
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 13: 
                    case 16: 
                    case 19: 
                    case 25: 
                    case 31: {
                        if (lb.lineCount <= lb.minimalLineCount) break;
                        --lb.lineCount;
                        --delta;
                        break;
                    }
                    case 28: {
                        if (lb.lineCount <= lb.minimalLineCount) break;
                        --lb.lineCount;
                        --delta;
                        if (lb.lineCount != 0) break;
                        blb = (BlockLayoutBlock)lb;
                        if (blb.section == blb.other.section) {
                            if (blb.other.lineCount > delta) {
                                blb.other.lineCount -= delta;
                                delta = 0;
                                break;
                            }
                            delta -= blb.other.lineCount;
                            blb.other.lineCount = 0;
                            break;
                        }
                        blb.other.section.relayout = true;
                        blb.other.lineCount = 0;
                    }
                }
                --i;
            }
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 14: 
                    case 17: 
                    case 20: 
                    case 26: 
                    case 32: {
                        if (lb.lineCount <= lb.minimalLineCount) break;
                        --lb.lineCount;
                        --delta;
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 2: 
                    case 5: {
                        if (lb.lineCount <= 0) break;
                        --lb.lineCount;
                        --delta;
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 40: {
                        if (lb.lineCount <= 0) break;
                        --lb.lineCount;
                        --delta;
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
    }

    private static void ExpandBlocksWithHeuristics(ArrayList<LayoutBlock> layoutBlockList, int firstIndex, int lastIndex, int delta) {
        BlockLayoutBlock blb;
        LayoutBlock lb;
        int i;
        int oldDelta;
        do {
            oldDelta = delta;
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 44: 
                    case 45: 
                    case 48: 
                    case 49: {
                        if (lb.lineCount >= lb.maximalLineCount) break;
                        ++lb.lineCount;
                        --delta;
                    }
                }
                ++i;
            }
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 43: 
                    case 47: {
                        if (lb.lineCount >= lb.maximalLineCount) break;
                        ++lb.lineCount;
                        --delta;
                    }
                }
                ++i;
            }
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 3: 
                    case 4: {
                        lb.lineCount += delta;
                        delta = 0;
                    }
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 37: {
                        if (lb.lineCount >= lb.maximalLineCount) break;
                        ++lb.lineCount;
                        --delta;
                    }
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 34: {
                        if (lb.lineCount != 0) break;
                        ++lb.lineCount;
                        --delta;
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 14: 
                    case 17: 
                    case 20: 
                    case 26: 
                    case 29: 
                    case 32: {
                        if (lb.lineCount != 0) break;
                        blb = (BlockLayoutBlock)lb;
                        ++lb.lineCount;
                        --delta;
                        if (blb.other.lineCount != 0) break;
                        if (blb.section == blb.other.section) {
                            if (delta <= 0) break;
                            blb.other.lineCount = blb.other.lineCount + 1;
                            --delta;
                            break;
                        }
                        blb.other.section.relayout = true;
                        blb.other.lineCount = 1;
                    }
                }
                ++i;
            }
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 13: 
                    case 16: 
                    case 19: 
                    case 25: 
                    case 31: {
                        if (lb.lineCount != 0) break;
                        blb = (BlockLayoutBlock)lb;
                        ++lb.lineCount;
                        --delta;
                        if (blb.section == blb.other.section) {
                            int d = 2 - blb.other.lineCount;
                            if (d > delta) {
                                blb.other.lineCount += delta;
                                delta = 0;
                                break;
                            }
                            delta -= d;
                            blb.other.lineCount = 2;
                            break;
                        }
                        blb.other.section.relayout = true;
                        blb.other.lineCount = 2;
                    }
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 2: 
                    case 5: {
                        ++lb.lineCount;
                        --delta;
                    }
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 34: {
                        if (lb.lineCount >= lb.maximalLineCount) break;
                        ++lb.lineCount;
                        --delta;
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 14: 
                    case 17: 
                    case 20: 
                    case 23: 
                    case 26: 
                    case 29: 
                    case 32: {
                        if (lb.lineCount >= lb.maximalLineCount) break;
                        ++lb.lineCount;
                        --delta;
                    }
                }
                ++i;
            }
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                lb = layoutBlockList.get(i);
                switch (lb.tag) {
                    case 13: 
                    case 16: 
                    case 19: 
                    case 22: 
                    case 25: 
                    case 28: 
                    case 31: {
                        if (lb.lineCount >= lb.maximalLineCount) break;
                        blb = (BlockLayoutBlock)lb;
                        ++lb.lineCount;
                        --delta;
                        if (lb.lineCount <= 1 || blb.other.lineCount != 0) break;
                        if (blb.section == blb.other.section) {
                            if (delta <= 0) break;
                            blb.other.lineCount = 1;
                            --delta;
                            break;
                        }
                        blb.other.section.relayout = true;
                        blb.other.lineCount = 1;
                    }
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
    }

    private static void CompactBlocks(ArrayList<LayoutBlock> layoutBlockList, int firstIndex, int lastIndex, int delta) {
        int oldDelta;
        do {
            oldDelta = delta;
            int i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if (lb.lineCount > lb.minimalLineCount) {
                    --lb.lineCount;
                    --delta;
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
    }

    private static void ExpandBlocks(ArrayList<LayoutBlock> layoutBlockList, int firstIndex, int lastIndex, int delta) {
        int oldDelta;
        do {
            oldDelta = delta;
            int i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if (lb.lineCount < lb.maximalLineCount) {
                    ++lb.lineCount;
                    --delta;
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
    }

    private static void ScoreSections(ArrayList<LayoutBlock> layoutBlockList, ArrayList<LayoutSection> layoutSectionList) {
        int sectionLength = layoutSectionList.size();
        if (sectionLength > 0) {
            --sectionLength;
            int sectionIndex = 0;
            while (sectionIndex < sectionLength) {
                LayoutSection section = layoutSectionList.get(sectionIndex);
                int lastBlockIndex = section.lastBlockIndex;
                int score = 0;
                int sumScore = 0;
                int blockIndex = section.firstBlockIndex;
                while (blockIndex <= lastBlockIndex) {
                    LayoutBlock lb = layoutBlockList.get(blockIndex);
                    switch (lb.tag) {
                        case 2: {
                            if (lb.lineCount < lb.preferedLineCount) {
                                sumScore += lb.preferedLineCount - lb.lineCount;
                                if (lb.lineCount <= 0) break;
                                score += sumScore * sumScore;
                                sumScore = 0;
                                break;
                            }
                            if (lb.lineCount <= lb.preferedLineCount) break;
                            int delta = lb.lineCount - lb.preferedLineCount;
                            score -= delta * delta;
                        }
                    }
                    ++blockIndex;
                }
                section.score = score += sumScore * sumScore;
                ++sectionIndex;
            }
        }
    }

    private static boolean SliceDownBlocks(ArrayList<LayoutBlock> layoutBlockList, ArrayList<LayoutSection> layoutSectionList) {
        int sectionLenght = layoutSectionList.size();
        ArrayList<LayoutSection> sortedLayoutSectionList = new ArrayList<LayoutSection>(sectionLenght);
        sortedLayoutSectionList.addAll(layoutSectionList);
        Collections.sort(sortedLayoutSectionList);
        int sectionSourceIndex = 0;
        while (sectionSourceIndex < sectionLenght) {
            LayoutSection lsSource = (LayoutSection)sortedLayoutSectionList.get(sectionSourceIndex);
            if (lsSource.score <= 0) break;
            if (ClassFileLayouter.SliceDownBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, lsSource)) {
                return true;
            }
            ++sectionSourceIndex;
        }
        return false;
    }

    private static boolean SliceUpBlocks(ArrayList<LayoutBlock> layoutBlockList, ArrayList<LayoutSection> layoutSectionList) {
        int sectionLenght = layoutSectionList.size();
        ArrayList<LayoutSection> sortedLayoutSectionList = new ArrayList<LayoutSection>(sectionLenght);
        sortedLayoutSectionList.addAll(layoutSectionList);
        Collections.sort(sortedLayoutSectionList);
        int sectionSourceIndex = 0;
        while (sectionSourceIndex < sectionLenght) {
            LayoutSection lsSource = (LayoutSection)sortedLayoutSectionList.get(sectionSourceIndex);
            if (lsSource.score <= 0) break;
            if (ClassFileLayouter.SliceUpBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, lsSource)) {
                return true;
            }
            ++sectionSourceIndex;
        }
        return false;
    }

    private static boolean SliceDownBlocks(ArrayList<LayoutBlock> layoutBlockList, ArrayList<LayoutSection> layoutSectionList, int sectionSourceIndex, LayoutSection lsSource) {
        int firstBlockIndex = lsSource.firstBlockIndex;
        int blockIndex = lsSource.lastBlockIndex;
        while (blockIndex >= firstBlockIndex) {
            LayoutBlock lb = layoutBlockList.get(blockIndex);
            switch (lb.tag) {
                case 7: {
                    if (ClassFileLayouter.SliceDownBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, blockIndex, lsSource, 11, 12)) {
                        return true;
                    }
                    if (!ClassFileLayouter.SliceDownBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, blockIndex, lsSource, 9, 10)) break;
                    return true;
                }
                case 9: {
                    if (ClassFileLayouter.SliceDownBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, blockIndex, lsSource, 7, 8)) {
                        return true;
                    }
                    if (!ClassFileLayouter.SliceDownBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, blockIndex, lsSource, 11, 12)) break;
                    return true;
                }
                case 11: {
                    if (ClassFileLayouter.SliceDownBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, blockIndex, lsSource, 7, 8)) {
                        return true;
                    }
                    if (!ClassFileLayouter.SliceDownBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, blockIndex, lsSource, 9, 10)) break;
                    return true;
                }
            }
            --blockIndex;
        }
        return false;
    }

    private static boolean SliceDownBlocks(ArrayList<LayoutBlock> layoutBlockList, ArrayList<LayoutSection> layoutSectionList, int sectionSourceIndex, int blockIndex, LayoutSection lsSource, int markerStartTag, int markerEndTag) {
        int firstBlockIndex = lsSource.firstBlockIndex;
        while (firstBlockIndex < blockIndex) {
            LayoutBlock lb = layoutBlockList.get(--blockIndex);
            if (lb.tag == markerEndTag) {
                int preferedLineCount;
                MarkerLayoutBlock mlb = (MarkerLayoutBlock)lb;
                if (mlb.section != mlb.other.section) {
                    return false;
                }
                if (mlb.other.index <= firstBlockIndex) {
                    return false;
                }
                int lastEndTagBlockIndex = blockIndex;
                int counter = 1;
                blockIndex = mlb.other.index;
                while (firstBlockIndex < blockIndex) {
                    lb = layoutBlockList.get(--blockIndex);
                    if (lb.tag == 13) break;
                    if (lb.tag == markerEndTag) {
                        mlb = (MarkerLayoutBlock)lb;
                        if (mlb.section != mlb.other.section || mlb.other.index <= firstBlockIndex) break;
                        ++counter;
                        blockIndex = mlb.other.index;
                        continue;
                    }
                    if (lb.tag == 10 || lb.tag == 12 || lb.tag == 8) break;
                }
                int blockLenght = layoutBlockList.size();
                blockIndex = lastEndTagBlockIndex;
                int lowerScore = lsSource.score;
                int lowerScoreBlockIndex = blockIndex;
                while (++blockIndex < blockLenght) {
                    lb = layoutBlockList.get(blockIndex);
                    if (lb.tag == 14 || lb.tag == markerStartTag) {
                        if (lowerScore <= lb.section.score) break;
                        lowerScore = lb.section.score;
                        lowerScoreBlockIndex = blockIndex;
                        break;
                    }
                    if (lb.tag != 9 && lb.tag != 11 && lb.tag != 7) continue;
                    if (lb.section != null && lowerScore > lb.section.score) {
                        lowerScore = lb.section.score;
                        lowerScoreBlockIndex = blockIndex;
                    }
                    blockIndex = ((MarkerLayoutBlock)lb).other.index;
                }
                if (lowerScore == lsSource.score) break;
                counter = (counter + 1) / 2;
                int firstStartTagBlockIndex = blockIndex = lastEndTagBlockIndex;
                while (firstBlockIndex < blockIndex) {
                    lb = layoutBlockList.get(blockIndex);
                    if (lb.tag == 13) break;
                    if (lb.tag == markerEndTag) {
                        firstStartTagBlockIndex = blockIndex = ((MarkerLayoutBlock)lb).other.index;
                        if (--counter == 0) break;
                    }
                    --blockIndex;
                }
                LayoutBlock insertionLayoutBlock = layoutBlockList.get(lowerScoreBlockIndex);
                LayoutSection lsTarget = insertionLayoutBlock.section;
                int sourceDeltaIndex = lastEndTagBlockIndex - firstStartTagBlockIndex + 1;
                ArrayList<LayoutBlock> layoutBlockListToMove = new ArrayList<LayoutBlock>(sourceDeltaIndex);
                blockIndex = lastEndTagBlockIndex;
                while (blockIndex >= firstStartTagBlockIndex) {
                    lb = layoutBlockList.remove(blockIndex);
                    lb.section = lsTarget;
                    layoutBlockListToMove.add(lb);
                    --blockIndex;
                }
                Collections.reverse(layoutBlockListToMove);
                if (layoutBlockList.get((int)(blockIndex + 1)).tag == 2) {
                    layoutBlockList.remove(blockIndex + 1);
                    ++sourceDeltaIndex;
                }
                if (layoutBlockList.get((int)blockIndex).tag == 2) {
                    layoutBlockList.get((int)blockIndex).preferedLineCount = 2;
                }
                lowerScoreBlockIndex -= sourceDeltaIndex;
                int targetDeltaIndex = 0;
                if (insertionLayoutBlock.tag == 14) {
                    int preferedLineCount2 = 2;
                    if (markerEndTag == 10 && layoutBlockList.get((int)(lowerScoreBlockIndex - 1)).tag == 10) {
                        preferedLineCount2 = 1;
                    }
                    layoutBlockList.add(lowerScoreBlockIndex, new SeparatorLayoutBlock(2, preferedLineCount2));
                    ++targetDeltaIndex;
                } else {
                    LayoutBlock beforeLayoutBlock = layoutBlockList.get(lowerScoreBlockIndex - 1);
                    preferedLineCount = 2;
                    if (markerEndTag == 10 && layoutBlockList.get((int)(lowerScoreBlockIndex - 2)).tag == 10) {
                        preferedLineCount = 1;
                    }
                    beforeLayoutBlock.preferedLineCount = preferedLineCount;
                }
                int layoutBlockListToMoveSize = layoutBlockListToMove.size();
                layoutBlockList.addAll(lowerScoreBlockIndex + targetDeltaIndex, layoutBlockListToMove);
                targetDeltaIndex += layoutBlockListToMoveSize;
                if (insertionLayoutBlock.tag != 14) {
                    preferedLineCount = 2;
                    if (markerStartTag == 9) {
                        preferedLineCount = 1;
                    }
                    layoutBlockList.add(lowerScoreBlockIndex + targetDeltaIndex, new SeparatorLayoutBlock(2, preferedLineCount));
                    ++targetDeltaIndex;
                }
                lsSource.lastBlockIndex -= sourceDeltaIndex;
                int sectionIndex = lsSource.index + 1;
                while (sectionIndex <= lsTarget.index - 1) {
                    LayoutSection ls = layoutSectionList.get(sectionIndex);
                    ls.firstBlockIndex -= sourceDeltaIndex;
                    ls.lastBlockIndex -= sourceDeltaIndex;
                    ++sectionIndex;
                }
                lsTarget.firstBlockIndex -= sourceDeltaIndex;
                int delta = sourceDeltaIndex - targetDeltaIndex;
                if (delta != 0) {
                    lsTarget.lastBlockIndex -= delta;
                    int sectionIndex2 = layoutSectionList.size() - 1;
                    while (sectionIndex2 > lsTarget.index) {
                        LayoutSection ls = layoutSectionList.get(sectionIndex2);
                        ls.firstBlockIndex -= delta;
                        ls.lastBlockIndex -= delta;
                        --sectionIndex2;
                    }
                }
                blockLenght = layoutBlockList.size();
                blockIndex = firstStartTagBlockIndex;
                while (blockIndex < blockLenght) {
                    layoutBlockList.get((int)blockIndex).index = blockIndex;
                    ++blockIndex;
                }
                ClassFileLayouter.UpdateRelayoutFlag(layoutBlockList, lsSource);
                ClassFileLayouter.UpdateRelayoutFlag(layoutBlockList, lsTarget);
                return true;
            }
            if (lb.tag == 10 || lb.tag == 12 || lb.tag == 8) {
                blockIndex = ((MarkerLayoutBlock)lb).other.index;
                continue;
            }
            if (lb.tag == 13) break;
        }
        return false;
    }

    private static boolean SliceUpBlocks(ArrayList<LayoutBlock> layoutBlockList, ArrayList<LayoutSection> layoutSectionList, int sectionSourceIndex, LayoutSection lsSource) {
        int lastBlockIndex = lsSource.lastBlockIndex;
        int blockIndex = lsSource.firstBlockIndex;
        while (blockIndex <= lastBlockIndex) {
            LayoutBlock lb = layoutBlockList.get(blockIndex);
            switch (lb.tag) {
                case 8: {
                    if (ClassFileLayouter.SliceUpBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, blockIndex, lsSource, 9, 10)) {
                        return true;
                    }
                    return ClassFileLayouter.SliceUpBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, blockIndex, lsSource, 11, 12);
                }
                case 10: {
                    if (ClassFileLayouter.SliceUpBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, blockIndex, lsSource, 11, 12)) {
                        return true;
                    }
                    return ClassFileLayouter.SliceUpBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, blockIndex, lsSource, 7, 8);
                }
                case 12: {
                    if (ClassFileLayouter.SliceUpBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, blockIndex, lsSource, 9, 10)) {
                        return true;
                    }
                    return ClassFileLayouter.SliceUpBlocks(layoutBlockList, layoutSectionList, sectionSourceIndex, blockIndex, lsSource, 7, 8);
                }
            }
            ++blockIndex;
        }
        return false;
    }

    private static boolean SliceUpBlocks(ArrayList<LayoutBlock> layoutBlockList, ArrayList<LayoutSection> layoutSectionList, int sectionSourceIndex, int blockIndex, LayoutSection lsSource, int markerStartTag, int markerEndTag) {
        int lastBlockIndex = lsSource.lastBlockIndex;
        while (blockIndex < lastBlockIndex) {
            LayoutBlock lb = layoutBlockList.get(++blockIndex);
            if (lb.tag == markerStartTag) {
                MarkerLayoutBlock mlb = (MarkerLayoutBlock)lb;
                if (mlb.section != mlb.other.section) {
                    return false;
                }
                if (mlb.other.index >= lastBlockIndex) {
                    return false;
                }
                int firstStartTagBlockIndex = blockIndex;
                int counter = 1;
                blockIndex = mlb.other.index;
                while (blockIndex < lastBlockIndex) {
                    lb = layoutBlockList.get(++blockIndex);
                    if (lb.tag == 14) break;
                    if (lb.tag == markerStartTag) {
                        mlb = (MarkerLayoutBlock)lb;
                        if (mlb.section != mlb.other.section || mlb.other.index >= lastBlockIndex) break;
                        ++counter;
                        blockIndex = mlb.other.index;
                        continue;
                    }
                    if (lb.tag == 9 || lb.tag == 11 || lb.tag == 7) break;
                }
                blockIndex = firstStartTagBlockIndex;
                int lowerScore = lsSource.score;
                int lowerScoreBlockIndex = blockIndex;
                while (blockIndex-- > 0) {
                    lb = layoutBlockList.get(blockIndex);
                    if (lb.tag == 13 || lb.tag == markerEndTag) {
                        if (lowerScore <= lb.section.score) break;
                        lowerScore = lb.section.score;
                        lowerScoreBlockIndex = blockIndex;
                        break;
                    }
                    if (lb.tag != 10 && lb.tag != 12 && lb.tag != 8) continue;
                    if (lb.section != null && lowerScore > lb.section.score) {
                        lowerScore = lb.section.score;
                        lowerScoreBlockIndex = blockIndex;
                    }
                    blockIndex = ((MarkerLayoutBlock)lb).other.index;
                }
                if (lowerScore == lsSource.score) break;
                counter = (counter + 1) / 2;
                int lastEndTagBlockIndex = blockIndex = firstStartTagBlockIndex;
                while (blockIndex > 0) {
                    lb = layoutBlockList.get(blockIndex);
                    if (lb.tag == 14) break;
                    if (lb.tag == markerStartTag) {
                        lastEndTagBlockIndex = blockIndex = ((MarkerLayoutBlock)lb).other.index;
                        if (--counter == 0) break;
                    }
                    ++blockIndex;
                }
                LayoutBlock insertionLayoutBlock = layoutBlockList.get(lowerScoreBlockIndex);
                LayoutSection lsTarget = insertionLayoutBlock.section;
                int sourceDeltaIndex = lastEndTagBlockIndex - firstStartTagBlockIndex + 1;
                ArrayList<LayoutBlock> layoutBlockListToMove = new ArrayList<LayoutBlock>(sourceDeltaIndex);
                blockIndex = lastEndTagBlockIndex;
                while (blockIndex >= firstStartTagBlockIndex) {
                    lb = layoutBlockList.remove(blockIndex);
                    lb.section = lsTarget;
                    layoutBlockListToMove.add(lb);
                    --blockIndex;
                }
                Collections.reverse(layoutBlockListToMove);
                if (layoutBlockList.get((int)(blockIndex + 1)).tag == 2) {
                    layoutBlockList.remove(blockIndex + 1);
                    ++sourceDeltaIndex;
                }
                if (layoutBlockList.get((int)blockIndex).tag == 2) {
                    layoutBlockList.get((int)blockIndex).preferedLineCount = 2;
                }
                ++lowerScoreBlockIndex;
                int targetDeltaIndex = 0;
                if (insertionLayoutBlock.tag != 13) {
                    int preferedLineCount = 2;
                    if (markerEndTag == 10) {
                        preferedLineCount = 1;
                    }
                    layoutBlockList.add(lowerScoreBlockIndex, new SeparatorLayoutBlock(2, preferedLineCount));
                    ++targetDeltaIndex;
                }
                int layoutBlockListToMoveSize = layoutBlockListToMove.size();
                layoutBlockList.addAll(lowerScoreBlockIndex + targetDeltaIndex, layoutBlockListToMove);
                targetDeltaIndex += layoutBlockListToMoveSize;
                if (insertionLayoutBlock.tag == 13) {
                    int preferedLineCount = 2;
                    if (markerEndTag == 10 && layoutBlockList.get((int)(lowerScoreBlockIndex + targetDeltaIndex)).tag == 10) {
                        preferedLineCount = 1;
                    }
                    layoutBlockList.add(lowerScoreBlockIndex + targetDeltaIndex, new SeparatorLayoutBlock(2, preferedLineCount));
                    ++targetDeltaIndex;
                } else {
                    LayoutBlock afterLayoutBlock = layoutBlockList.get(lowerScoreBlockIndex + targetDeltaIndex);
                    int preferedLineCount = 2;
                    if (markerStartTag == 9 && layoutBlockList.get((int)(lowerScoreBlockIndex + targetDeltaIndex + 1)).tag == 9) {
                        preferedLineCount = 1;
                    }
                    afterLayoutBlock.preferedLineCount = preferedLineCount;
                }
                lsTarget.lastBlockIndex += targetDeltaIndex;
                int sectionIndex = lsTarget.index + 1;
                while (sectionIndex <= lsSource.index - 1) {
                    LayoutSection ls = layoutSectionList.get(sectionIndex);
                    ls.firstBlockIndex += targetDeltaIndex;
                    ls.lastBlockIndex += targetDeltaIndex;
                    ++sectionIndex;
                }
                lsSource.firstBlockIndex += targetDeltaIndex;
                int delta = sourceDeltaIndex - targetDeltaIndex;
                if (delta != 0) {
                    lsSource.lastBlockIndex -= delta;
                    int sectionIndex2 = layoutSectionList.size() - 1;
                    while (sectionIndex2 > lsSource.index) {
                        LayoutSection ls = layoutSectionList.get(sectionIndex2);
                        ls.firstBlockIndex -= delta;
                        ls.lastBlockIndex -= delta;
                        --sectionIndex2;
                    }
                }
                int blockLenght = layoutBlockList.size();
                blockIndex = lowerScoreBlockIndex;
                while (blockIndex < blockLenght) {
                    layoutBlockList.get((int)blockIndex).index = blockIndex;
                    ++blockIndex;
                }
                ClassFileLayouter.UpdateRelayoutFlag(layoutBlockList, lsSource);
                ClassFileLayouter.UpdateRelayoutFlag(layoutBlockList, lsTarget);
                return true;
            }
            if (lb.tag == 9 || lb.tag == 11 || lb.tag == 7) {
                blockIndex = ((MarkerLayoutBlock)lb).other.index;
                continue;
            }
            if (lb.tag == 14) break;
        }
        return false;
    }

    private static void UpdateRelayoutFlag(ArrayList<LayoutBlock> layoutBlockList, LayoutSection section) {
        section.relayout = true;
        int lastBlockIndex = section.lastBlockIndex;
        int blockIndex = section.firstBlockIndex;
        while (blockIndex < lastBlockIndex) {
            LayoutBlock block = layoutBlockList.get(blockIndex);
            switch (block.tag) {
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 31: 
                case 32: {
                    BlockLayoutBlock blb = (BlockLayoutBlock)block;
                    LayoutSection otherSection = blb.other.section;
                    if (otherSection.relayout) break;
                    ClassFileLayouter.UpdateRelayoutFlag(layoutBlockList, otherSection);
                }
            }
            ++blockIndex;
        }
    }
}

