/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;

public class HasTreeItemsParser
implements ElementParser {
    static final String BAD_CHILD = "Only TreeItem or Widget subclasses are valid children";

    @Override
    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        JClassType itemType = writer.getOracle().findType(TreeItem.class.getName());
        JClassType widgetType = writer.getOracle().findType(Widget.class.getName());
        JClassType isWidgetType = writer.getOracle().findType(IsWidget.class.getName());
        for (XMLElement child : elem.consumeChildElements()) {
            FieldWriter childField;
            JClassType childType = writer.findFieldType(child);
            if (itemType.isAssignableFrom(childType)) {
                childField = writer.parseElementToField(child);
                writer.addStatement("%1$s.addItem(%2$s);", new Object[]{fieldName, childField.getNextReference()});
                continue;
            }
            if (widgetType.isAssignableFrom(childType) || isWidgetType.isAssignableFrom(childType)) {
                childField = writer.parseElementToField(child);
                writer.addStatement("%1$s.addItem(%2$s);", new Object[]{fieldName, childField.getNextReference()});
                continue;
            }
            writer.die(child, BAD_CHILD, new Object[0]);
        }
    }
}

