/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.continuous;

import java.io.File;
import java.util.function.Supplier;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.execution.plan.SingleFileTreeElementMatcher;
import org.gradle.execution.plan.ValuedVfsHierarchy;
import org.gradle.internal.collect.PersistentList;
import org.gradle.internal.file.Stat;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.VfsRelativePath;

public class BuildInputHierarchy {
    private volatile ValuedVfsHierarchy<InputDeclaration> root;
    private final SingleFileTreeElementMatcher matcher;
    private static final InputDeclaration ALL_CHILDREN_ARE_INPUTS = childPath -> true;

    public BuildInputHierarchy(CaseSensitivity caseSensitivity, Stat stat) {
        this.root = ValuedVfsHierarchy.emptyHierarchy((CaseSensitivity)caseSensitivity);
        this.matcher = new SingleFileTreeElementMatcher(stat);
    }

    public boolean isInput(String location) {
        InputDeclarationVisitor visitor = new InputDeclarationVisitor();
        this.root.visitValues(location, (ValuedVfsHierarchy.ValueVisitor)visitor);
        return visitor.isInput();
    }

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public synchronized void recordInputs(Iterable<String> inputLocations) {
        for (String location : inputLocations) {
            VfsRelativePath relativePath = VfsRelativePath.of((String)location);
            this.root = this.root.recordValue(relativePath, (Object)ALL_CHILDREN_ARE_INPUTS);
        }
    }

    public synchronized void recordFilteredInput(String fileTreeRoot, Spec<FileTreeElement> filter) {
        VfsRelativePath relativePath = VfsRelativePath.of((String)fileTreeRoot);
        this.root = this.root.recordValue(relativePath, (Object)new FilteredInputDeclaration(filter));
    }

    private class FilteredInputDeclaration
    implements InputDeclaration {
        private final Spec<FileTreeElement> spec;

        public FilteredInputDeclaration(Spec<FileTreeElement> spec) {
            this.spec = spec;
        }

        @Override
        public boolean contains(VfsRelativePath childPath) {
            return BuildInputHierarchy.this.matcher.elementWithRelativePathMatches(this.spec, new File(childPath.getAbsolutePath()), childPath.getAsString());
        }
    }

    private static interface InputDeclaration {
        public boolean contains(VfsRelativePath var1);
    }

    private static class InputDeclarationVisitor
    implements ValuedVfsHierarchy.ValueVisitor<InputDeclaration> {
        private boolean input = false;

        private InputDeclarationVisitor() {
        }

        private void foundInput() {
            this.input = true;
        }

        public void visitExact(InputDeclaration value) {
            this.foundInput();
        }

        public void visitAncestor(InputDeclaration ancestor, VfsRelativePath pathToVisitedLocation) {
            if (ancestor.contains(pathToVisitedLocation)) {
                this.foundInput();
            }
        }

        public void visitChildren(PersistentList<InputDeclaration> values, Supplier<String> relativePathSupplier) {
        }

        public boolean isInput() {
            return this.input;
        }
    }
}

