/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProvider;
import org.gradle.api.internal.artifacts.transform.DefaultTransformDependencies;
import org.gradle.api.internal.artifacts.transform.FilteredResultFactory;
import org.gradle.api.internal.artifacts.transform.TransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformStep;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.api.specs.Spec;
import org.gradle.execution.plan.PostExecutionNodeAwareActionNode;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.internal.Describables;
import org.gradle.internal.Try;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;
import org.gradle.operations.dependencies.configurations.ConfigurationIdentity;

public class DefaultTransformUpstreamDependenciesResolver
implements TransformUpstreamDependenciesResolver {
    public static final TransformDependencies NO_RESULT = new TransformDependencies(){

        @Override
        public Optional<FileCollection> getFiles() {
            return Optional.empty();
        }
    };
    public static final TransformUpstreamDependencies NO_DEPENDENCIES = new TransformUpstreamDependencies(){

        @Override
        @Nullable
        public ConfigurationIdentity getConfigurationIdentity() {
            return null;
        }

        @Override
        public FileCollection selectedArtifacts() {
            throw DefaultTransformUpstreamDependenciesResolver.failure();
        }

        @Override
        public void finalizeIfNotAlready() {
        }

        @Override
        public Try<TransformDependencies> computeArtifacts() {
            return Try.successful((Object)NO_RESULT);
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
        }
    };
    private final ComponentIdentifier componentIdentifier;
    private final ConfigurationIdentity configurationIdentity;
    private final ResolutionResultProvider<ResolvedComponentResult> rootComponentProvider;
    private final DomainObjectContext owner;
    private final FilteredResultFactory filteredResultFactory;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private Set<ComponentIdentifier> buildDependencies;
    private Set<ComponentIdentifier> dependencies;

    public DefaultTransformUpstreamDependenciesResolver(ComponentIdentifier componentIdentifier, ConfigurationIdentity configurationIdentity, ResolutionResultProvider<ResolvedComponentResult> rootComponentProvider, DomainObjectContext owner, FilteredResultFactory filteredResultFactory, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.componentIdentifier = componentIdentifier;
        this.configurationIdentity = configurationIdentity;
        this.rootComponentProvider = rootComponentProvider;
        this.owner = owner;
        this.filteredResultFactory = filteredResultFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    private static IllegalStateException failure() {
        return new IllegalStateException("Transform does not use artifact dependencies.");
    }

    @Override
    public TransformUpstreamDependencies dependenciesFor(TransformStep transformStep) {
        if (!transformStep.requiresDependencies()) {
            return NO_DEPENDENCIES;
        }
        return new TransformUpstreamDependenciesImpl(this.configurationIdentity, transformStep, this.calculatedValueContainerFactory);
    }

    private FileCollectionInternal selectedArtifactsFor(ImmutableAttributes fromAttributes) {
        if (this.dependencies == null) {
            this.dependencies = this.computeDependencies(this.rootComponentProvider.getValue(), false);
        }
        return this.filteredResultFactory.resultsMatching(fromAttributes, DefaultTransformUpstreamDependenciesResolver.selectDependenciesWithId(this.dependencies));
    }

    private void computeDependenciesFor(ImmutableAttributes fromAttributes, TaskDependencyResolveContext context) {
        if (this.buildDependencies == null) {
            this.buildDependencies = this.computeDependencies(this.rootComponentProvider.getTaskDependencyValue(), true);
        }
        FileCollectionInternal files = this.filteredResultFactory.resultsMatching(fromAttributes, DefaultTransformUpstreamDependenciesResolver.selectDependenciesWithId(this.buildDependencies));
        context.add((Object)files);
    }

    private static Spec<ComponentIdentifier> selectDependenciesWithId(Set<ComponentIdentifier> dependencies) {
        return SerializableLambdas.spec((SerializableLambdas.SerializableSpec & Serializable)element -> dependencies.contains(element));
    }

    private Set<ComponentIdentifier> computeDependencies(ResolvedComponentResult value, boolean strict) {
        ResolvedComponentResult targetComponent = DefaultTransformUpstreamDependenciesResolver.findComponent(value, this.componentIdentifier);
        if (targetComponent == null) {
            if (strict) {
                throw new AssertionError((Object)("Could not find component " + this.componentIdentifier + " in provided results."));
            }
            return Collections.emptySet();
        }
        HashSet<ComponentIdentifier> buildDependencies = new HashSet<ComponentIdentifier>();
        DefaultTransformUpstreamDependenciesResolver.collectReachableComponents(buildDependencies, new HashSet<ComponentIdentifier>(), targetComponent.getDependencies());
        return buildDependencies;
    }

    @Nullable
    public static ResolvedComponentResult findComponent(ResolvedComponentResult rootComponent, ComponentIdentifier componentIdentifier) {
        HashSet<ResolvedComponentResult> seen = new HashSet<ResolvedComponentResult>();
        ArrayDeque<ResolvedComponentResult> pending = new ArrayDeque<ResolvedComponentResult>();
        pending.push(rootComponent);
        while (!pending.isEmpty()) {
            ResolvedComponentResult component = (ResolvedComponentResult)pending.pop();
            if (component.getId().equals(componentIdentifier)) {
                return component;
            }
            for (DependencyResult d : component.getDependencies()) {
                ResolvedDependencyResult resolved;
                ResolvedComponentResult selected;
                if (!(d instanceof ResolvedDependencyResult) || !seen.add(selected = (resolved = (ResolvedDependencyResult)d).getSelected())) continue;
                pending.push(selected);
            }
        }
        return null;
    }

    private static void collectReachableComponents(Set<ComponentIdentifier> dependenciesIdentifiers, Set<ComponentIdentifier> visited, Set<? extends DependencyResult> dependencies) {
        for (DependencyResult dependencyResult : dependencies) {
            if (!(dependencyResult instanceof ResolvedDependencyResult) || dependencyResult.isConstraint()) continue;
            ResolvedDependencyResult resolvedDependency = (ResolvedDependencyResult)dependencyResult;
            ResolvedComponentResult selected = resolvedDependency.getSelected();
            dependenciesIdentifiers.add(selected.getId());
            if (!visited.add(selected.getId())) continue;
            DefaultTransformUpstreamDependenciesResolver.collectReachableComponents(dependenciesIdentifiers, visited, selected.getDependencies());
        }
    }

    private class TransformUpstreamDependenciesImpl
    implements TransformUpstreamDependencies {
        private final ConfigurationIdentity configurationIdentity;
        private final CalculatedValueContainer<TransformDependencies, FinalizeTransformDependencies> transformDependencies;
        private final ImmutableAttributes fromAttributes;

        public TransformUpstreamDependenciesImpl(ConfigurationIdentity configurationIdentity, TransformStep transformStep, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.configurationIdentity = configurationIdentity;
            this.fromAttributes = transformStep.getFromAttributes();
            this.transformDependencies = calculatedValueContainerFactory.create(Describables.of((Object)"dependencies for", (Object)DefaultTransformUpstreamDependenciesResolver.this.componentIdentifier, (Object)this.fromAttributes), (ValueCalculator)new FinalizeTransformDependenciesFromSelectedArtifacts(transformStep.getFromAttributes()));
        }

        @Override
        public ConfigurationIdentity getConfigurationIdentity() {
            return this.configurationIdentity;
        }

        @Override
        public FileCollection selectedArtifacts() {
            return DefaultTransformUpstreamDependenciesResolver.this.selectedArtifactsFor(this.fromAttributes);
        }

        @Override
        public Try<TransformDependencies> computeArtifacts() {
            return this.transformDependencies.getValue();
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.transformDependencies);
        }

        @Override
        public void finalizeIfNotAlready() {
            this.transformDependencies.finalizeIfNotAlready();
        }
    }

    private static class CollectingTaskDependencyResolveContext
    implements TaskDependencyResolveContext {
        private final TaskNodeFactory taskNodeFactory;
        private final Collection<TaskNode> tasks;

        public CollectingTaskDependencyResolveContext(Collection<TaskNode> tasks, TaskNodeFactory taskNodeFactory) {
            this.tasks = tasks;
            this.taskNodeFactory = taskNodeFactory;
        }

        public void add(Object dependency) {
            if (dependency instanceof Task) {
                this.tasks.add(this.taskNodeFactory.getNode((Task)dependency));
            }
        }

        public void visitFailure(Throwable failure) {
        }

        @Nullable
        public Task getTask() {
            return null;
        }
    }

    public class FinalizeTransformDependenciesFromSelectedArtifacts
    extends FinalizeTransformDependencies {
        private final ImmutableAttributes fromAttributes;

        public FinalizeTransformDependenciesFromSelectedArtifacts(ImmutableAttributes fromAttributes) {
            this.fromAttributes = fromAttributes;
        }

        public FileCollectionInternal selectedArtifacts() {
            return DefaultTransformUpstreamDependenciesResolver.this.selectedArtifactsFor(this.fromAttributes);
        }

        public boolean usesMutableProjectState() {
            return DefaultTransformUpstreamDependenciesResolver.this.owner.getProject() != null;
        }

        public ProjectInternal getOwningProject() {
            return DefaultTransformUpstreamDependenciesResolver.this.owner.getProject();
        }

        @Nullable
        public WorkNodeAction getPreExecutionAction() {
            return new CalculateFinalDependencies();
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            DefaultTransformUpstreamDependenciesResolver.this.computeDependenciesFor(this.fromAttributes, context);
        }

        public class CalculateFinalDependencies
        implements PostExecutionNodeAwareActionNode {
            final List<TaskNode> tasks = new ArrayList<TaskNode>();

            public boolean usesMutableProjectState() {
                return FinalizeTransformDependenciesFromSelectedArtifacts.this.usesMutableProjectState();
            }

            @Nullable
            public Project getOwningProject() {
                return FinalizeTransformDependenciesFromSelectedArtifacts.this.getOwningProject();
            }

            public void run(NodeExecutionContext context) {
                TaskNodeFactory taskNodeFactory = (TaskNodeFactory)context.getService(TaskNodeFactory.class);
                FinalizeTransformDependenciesFromSelectedArtifacts.this.selectedArtifacts().visitDependencies((TaskDependencyResolveContext)new CollectingTaskDependencyResolveContext(this.tasks, taskNodeFactory));
            }

            public List<TaskNode> getPostExecutionNodes() {
                return this.tasks;
            }
        }
    }

    public static abstract class FinalizeTransformDependencies
    implements ValueCalculator<TransformDependencies> {
        public abstract FileCollection selectedArtifacts();

        public TransformDependencies calculateValue(NodeExecutionContext context) {
            FileCollection files = this.selectedArtifacts();
            files.getFiles();
            return new DefaultTransformDependencies(files);
        }
    }
}

