/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.drag.outline.x11;

import java.awt.Rectangle;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flexdock.docking.drag.outline.x11.Connection;
import org.flexdock.docking.drag.outline.x11.ConnectionResponse;
import org.flexdock.docking.drag.outline.x11.DataBuffer;

public class Graphics {
    private static Log log = LogFactory.getLog((Class)Graphics.class);
    public static final char MOST_SIGNIFICANT_BIT_FIRST = 'B';
    public static final int MAJOR_VERSION = 11;
    public static final int MINOR_VERSION = 0;
    public static final int DEFAULT_AUTH_NAME_LENGTH = 0;
    public static final int DEFAULT_AUTH_DATA_LENGTH = 0;
    public static final int CREATE_GC_OPCODE = 55;
    public static final int CHANGE_GC_OPCODE = 56;
    public static final int POLY_RECT_OPCODE = 67;
    public static final int BITMASK_FUNCTION = 1;
    public static final int BITMASK_FOREGROUND = 4;
    public static final int BITMASK_BACKGROUND = 8;
    public static final int BITMASK_SUBWIN_MODE = 32768;
    public static final int XOR_MODE = 6;
    public static final int SUBWIN_MODE_CLIP_BY_CHILDREN = 0;
    public static final int SUBWIN_MODE_INCLUDE_INFERIORS = 1;
    private static final Graphics SINGLETON = Graphics.create();
    private Connection connection;
    private int rootWindowId;
    private int rootGraphicsId;
    private int blackPixel;
    private int whitePixel;

    private static Graphics create() {
        Graphics.setupShutdownHooks();
        try {
            Connection conn = new Connection();
            DataBuffer connectionBuffer = Graphics.getConnectionRequest();
            DataBuffer replyBuffer = conn.sendRequest(connectionBuffer, true);
            ConnectionResponse reply = new ConnectionResponse(replyBuffer);
            return new Graphics(conn, reply);
        }
        catch (IOException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Graphics getGraphics() {
        return SINGLETON;
    }

    private Graphics(Connection conn, ConnectionResponse serverInfo) {
        this.connection = conn;
        this.rootWindowId = serverInfo.getRootWindowID(0);
        this.blackPixel = serverInfo.getBlackPixel(0);
        this.whitePixel = serverInfo.getWhitePixel(0);
        this.rootGraphicsId = serverInfo.getNextResourceId();
        this.initGraphicsContext();
    }

    private void initGraphicsContext() {
        DataBuffer buffer = new DataBuffer();
        buffer.appendByte(55);
        buffer.appendByte(0);
        buffer.appendTwoBytes(6);
        buffer.appendFourBytes(this.rootGraphicsId);
        buffer.appendFourBytes(this.rootWindowId);
        buffer.appendFourBytes(12);
        buffer.appendFourBytes(this.blackPixel);
        buffer.appendFourBytes(this.whitePixel);
        this.sendRequest(buffer);
    }

    public void setForeground(int color) {
        this.changeGraphicsAttrib(4, color);
    }

    public void setSubWindowMode(int winMode) {
        if (winMode != 0) {
            winMode = 1;
        }
        this.changeGraphicsAttrib(32768, winMode);
    }

    public void setXor() {
        this.changeGraphicsAttrib(1, 6);
    }

    private void changeGraphicsAttrib(int bitmask, int value) {
        DataBuffer buffer = new DataBuffer();
        buffer.appendByte(56);
        buffer.appendByte(0);
        buffer.appendTwoBytes(4);
        buffer.appendFourBytes(this.rootGraphicsId);
        buffer.appendFourBytes(bitmask);
        buffer.appendFourBytes(value);
        this.sendRequest(buffer);
    }

    private static DataBuffer getConnectionRequest() {
        DataBuffer buffer = new DataBuffer();
        buffer.appendByte(66);
        buffer.appendByte(0);
        buffer.appendTwoBytes(11);
        buffer.appendTwoBytes(0);
        buffer.appendTwoBytes(0);
        buffer.appendTwoBytes(0);
        buffer.appendTwoBytes(0);
        return buffer;
    }

    public void dragRectange(int x, int y, int width, int height) {
        this.drawRectangle(new Rectangle(x, y, width, height));
    }

    public void drawRectangle(Rectangle r) {
        if (r == null) {
            return;
        }
        DataBuffer buffer = new DataBuffer();
        buffer.appendByte(67);
        buffer.appendByte(0);
        buffer.appendTwoBytes(5);
        buffer.appendFourBytes(this.rootWindowId);
        buffer.appendFourBytes(this.rootGraphicsId);
        buffer.appendTwoBytes(r.x);
        buffer.appendTwoBytes(r.y);
        buffer.appendTwoBytes(r.width);
        buffer.appendTwoBytes(r.height);
        this.sendRequest(buffer);
    }

    public int getWhitePixel() {
        return this.whitePixel;
    }

    public int getBlackPixel() {
        return this.blackPixel;
    }

    private void sendRequest(DataBuffer buffer) {
        try {
            this.connection.sendRequest(buffer);
        }
        catch (IOException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void cleanup() {
        if (SINGLETON != null && Graphics.SINGLETON.connection != null) {
            try {
                Graphics.SINGLETON.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void finalize() {
        Graphics.cleanup();
    }

    private static void setupShutdownHooks() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                block2: {
                    try {
                        Graphics.cleanup();
                    }
                    catch (Throwable t) {
                        if (!Boolean.getBoolean("rubberband.debug")) break block2;
                        log.debug((Object)t.getMessage(), t);
                    }
                }
            }
        });
    }
}

