.TH FBPS 1 25-Jun-90
.CM 3
.SH NAME
fbps \- convert grayscale to postscript
.SH SYNOPSIS
.nf
fbps [-tT] [-pP] [ -s ] [ -w<width> ] < grayscale > foo.PS
.fi
.SH DESCRIPTION
.PP
Converts an fbm format file into a postscript file for printing. The
.B -s
flag generates a file suitable for including in a postscript document
(for example, Scribe or LaTex output) with no document structuring,
titles, or trailing "showpage".  By default, the image's title is
printed in a large font centered over the image, and a small banner
giving the size is printed under the lower right corner.
The
.B -T
and 
.B -P
arguments disable the title and print size options.
.sp
There really ought to be an option to print the credits instead of the
size, but I haven't done it yet.
.SH EXAMPLE
.PP
To convert a Sun 8bit grayscale rasterfile to a full page postscript file:
.sp
	% fbps < foo.8bit > foo.PS
.sp
To convert a color GIF file to a 3 inch wide grayscale postscript file
for inclusion in a Scribe or TeX document:
.sp
	% clr2gray < foo.gif | fbps -s -w3.0 > foo.PS
.sp
To print a 1 bit deep Sun rasterfile in postscript, use fbcat and
pbm2ps:
.sp
	% fbcat -P < foo.1bit | pbm2ps > foo.PS
.SH SEE ALSO
fbcat(1) and pbm2ps(1) for converting 1 bit deep files to PostScript.
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
