/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.sql.analysis.index.EsIndex;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.EsField;

public class EsRelation
extends LeafPlan {
    private final EsIndex index;
    private final List<Attribute> attrs;
    private static final int TO_STRING_LIMIT = 52;

    public EsRelation(Source source, EsIndex index) {
        super(source);
        this.index = index;
        this.attrs = EsRelation.flatten(source, index.mapping());
    }

    @Override
    protected NodeInfo<EsRelation> info() {
        return NodeInfo.create(this, EsRelation::new, this.index);
    }

    private static List<Attribute> flatten(Source source, Map<String, EsField> mapping) {
        return EsRelation.flatten(source, mapping, null);
    }

    private static List<Attribute> flatten(Source source, Map<String, EsField> mapping, FieldAttribute parent) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (Map.Entry<String, EsField> entry : mapping.entrySet()) {
            String name = entry.getKey();
            EsField t = entry.getValue();
            if (t == null) continue;
            FieldAttribute f = new FieldAttribute(source, parent, parent != null ? parent.name() + "." + name : name, t);
            list.add(f);
            if (t.getProperties().isEmpty()) continue;
            list.addAll(EsRelation.flatten(source, t.getProperties(), f));
        }
        return list;
    }

    public EsIndex index() {
        return this.index;
    }

    @Override
    public List<Attribute> output() {
        return this.attrs;
    }

    @Override
    public boolean expressionsResolved() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EsRelation other = (EsRelation)obj;
        return Objects.equals(this.index, other.index);
    }

    private static <E> String limitedToString(Collection<E> c) {
        Iterator<E> it = c.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(56);
        sb.append('[');
        while (true) {
            E e;
            String next;
            String string = next = (e = it.next()) == c ? "(this Collection)" : String.valueOf(e);
            if (next.length() + sb.length() > 52) {
                sb.append(next.substring(0, Math.max(0, 52 - sb.length())));
                sb.append('.').append('.').append(']');
                return sb.toString();
            }
            sb.append(next);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public String nodeString() {
        return this.nodeName() + "[" + this.index + "]" + EsRelation.limitedToString(this.attrs);
    }
}

