/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.online.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.diylc.swingframework.ButtonDialog;

public class LoginDialog
extends ButtonDialog {
    private static final long serialVersionUID = 1L;
    private JPanel mainPanel;
    private JTextField userNameField;
    private JPasswordField passwordField;
    private String userName;
    private String password;

    public LoginDialog(JFrame jFrame) {
        super(jFrame, "Login", new String[]{"OK", "Cancel"});
        this.setMinimumSize(new Dimension(240, 32));
        this.layoutGui();
        this.refreshState();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.mainPanel.add((Component)new JLabel("User Name:"), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.mainPanel.add((Component)new JLabel("Password:"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            this.mainPanel.add((Component)this.getUserNameField(), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.mainPanel.add((Component)this.getPasswordField(), gridBagConstraints);
        }
        return this.mainPanel;
    }

    private void refreshState() {
        this.userName = this.getUserNameField().getText();
        this.password = new String(this.getPasswordField().getPassword());
        JButton jButton = this.getButton("OK");
        jButton.setEnabled(this.userName.length() > 0 && this.password.length() > 0);
    }

    private JTextField getUserNameField() {
        if (this.userNameField == null) {
            this.userNameField = new JTextField();
            this.userNameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    LoginDialog.this.refreshState();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    LoginDialog.this.refreshState();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    LoginDialog.this.refreshState();
                }
            });
        }
        return this.userNameField;
    }

    private JPasswordField getPasswordField() {
        if (this.passwordField == null) {
            this.passwordField = new JPasswordField();
            this.passwordField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    LoginDialog.this.refreshState();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    LoginDialog.this.refreshState();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    LoginDialog.this.refreshState();
                }
            });
        }
        return this.passwordField;
    }
}

