dnl
dnl AC_PROG_APPLE_OBJECTIVEC
dnl
dnl (copied from aclocal.m4 distributed with obgtk-1.0.0)
dnl
AC_DEFUN(AC_PROG_APPLE_OBJECTIVE_C,[
	AC_CHECK_PROGS(OBJC, $OBJC gcc cc)
	AC_REQUIRE([AC_LIB_PTHREAD])
	OBJCLIBS="-framework Foundation"
	AC_SUBST(OBJCLIBS)

	AC_CACHE_CHECK([if Apple Objective C compiler ($OBJC) works],
	  ac_cv_prog_apple_objc_works, [
	    if test -n "$OBJC"; then
		cat > conftest.m <<EOF
#include <Foundation/NSObject.h>
@interface myRandomObj : NSObject
{
}
@end
@implementation myRandomObj
@end
int main () {
  /* No, you are not seeing double.  Remember that square brackets
     are the autoconf m4 quotes.  */
  id myid = [[myRandomObj alloc]];
  [[myid disalloc]];
  return 0;
}
EOF
		$OBJC -o conftest $LDFLAGS conftest.m $OBJCLIBS 1>&AC_FD_CC 2>&1
		result=$?
		rm -f conftest*

		if test $result -eq 0; then
			ac_cv_prog_apple_objc_works=yes
		else
			ac_cv_prog_apple_objc_works=no
		fi
	    else
      	    	ac_cv_prog_apple_objc_works=no
    	    fi])
	HAVE_APPLE_OBJECTIVE_C=$ac_cv_prog_apple_objc_works
])

