/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.jsp.logic;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.igoweb.igoweb.jsp.logic.Product;
import org.igoweb.igoweb.jsp.logic.TimeUnit;
import org.igoweb.igoweb.shared.PUser;
import org.igoweb.util.DbConn;
import org.igoweb.util.LockOrder;
import org.igoweb.util.jsp.AbstractInvoice;
import org.igoweb.util.jsp.PaymentMethod;

public class Invoice
extends AbstractInvoice {
    public static final LockOrder LOCK_ORDER = new LockOrder(Invoice.class);
    private int subscriptionId;
    public int duration;
    private TimeUnit durationUnits;
    private int tournId;

    public Invoice(DbConn db, int id, PUser user, Product product, double cost, int tournId, PaymentMethod paymentMethod, int duration, TimeUnit durationUnits, String notes) throws SQLException {
        super(db, id, user.id, product.getId(), cost, -1.0, paymentMethod, notes);
        if (tournId != -1 != (paymentMethod == PaymentMethod.TOURNAMENT)) {
            throw new IllegalArgumentException("TournId " + tournId + " with payment method " + (Object)((Object)paymentMethod) + " is not legal.");
        }
        if (tournId != -1 != product.isTournPrize()) {
            throw new IllegalArgumentException("TournId " + tournId + " with product " + product + " is not legal.");
        }
        if (!product.isPurchaseable(user.getAuthLevel(), user.id, db)) {
            throw new IllegalArgumentException("User " + user + " cannot buy " + product);
        }
        if (cost != product.getCost()) {
            throw new IllegalArgumentException("Cost " + cost + " does not match product " + product);
        }
        if (product.getDuration() != 0 && (duration != product.getDuration() || durationUnits != product.getDurationUnits())) {
            throw new IllegalArgumentException("Duration " + duration + " " + (Object)((Object)durationUnits) + " does not match " + product);
        }
        this.subscriptionId = -1;
        this.duration = duration;
        this.durationUnits = durationUnits;
        this.tournId = tournId;
        this.insertIntoDb(db);
    }

    public Invoice(ResultSet rs) throws SQLException {
        super(rs);
    }

    @Override
    protected String getAuxColumns() {
        return ", subscription_id, duration, duration_units, tourn_id";
    }

    @Override
    protected String getAuxWildcards() {
        return ", ?, ?, ?, ?";
    }

    @Override
    protected void setAuxColumns(PreparedStatement ps, int paramIndex) throws SQLException {
        ps.setInt(paramIndex, this.subscriptionId);
        ps.setInt(paramIndex + 1, this.duration);
        ps.setString(paramIndex + 2, this.durationUnits.sqlName);
        if (this.tournId == -1) {
            ps.setNull(paramIndex + 3, 4);
        } else {
            ps.setInt(paramIndex + 3, this.tournId);
        }
    }

    @Override
    protected void loadAuxColumns(ResultSet rs) throws SQLException {
        this.subscriptionId = rs.getInt("subscription_id");
        this.duration = rs.getInt("duration");
        this.durationUnits = TimeUnit.get(rs.getString("duration_units"));
        this.tournId = rs.getInt("tourn_id");
        if (rs.wasNull()) {
            this.tournId = -1;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        Invoice peer = (Invoice)o;
        return this.subscriptionId == peer.subscriptionId && this.duration == peer.duration && this.durationUnits == peer.durationUnits;
    }

    public void setSubscriptionId(DbConn db, int newId) throws SQLException {
        if (this.subscriptionId != newId) {
            this.subscriptionId = newId;
            PreparedStatement ps = db.get("UPDATE invoices  SET subscription_id = ?  WHERE id = ?");
            ps.setInt(1, newId);
            ps.setInt(2, this.id);
            ps.executeUpdate();
        }
    }

    public int getSubscriptionId() {
        return this.subscriptionId;
    }

    public int getDuration() {
        return this.duration;
    }

    public TimeUnit getDurationUnits() {
        return this.durationUnits;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Invoice[");
        super.toString(buf);
        buf.append(", subs=").append(this.subscriptionId).append(", duration=").append(this.duration).append(' ').append((Object)this.durationUnits).append(']');
        return buf.toString();
    }
}

