/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing.sgf.gameInfo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.igoweb.go.Game;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.GCLayout;

public class ResultEditor
extends JPanel
implements ActionListener {
    private final Node rootNode;
    private Errout errWin = null;
    private final JComboBox<String> whoWonBox;
    private final JComboBox<String> wonByBox;
    private final JLabel byLabel;

    public ResultEditor(Node rootNode) {
        super(new GCLayout());
        this.rootNode = rootNode;
        this.wonByBox = new JComboBox<String>(new String[]{Game.SCORE_FORMATTER.format(0.5), Defs.getString(-478254148), Defs.getString(-478254144), Defs.getString(720104008)});
        this.wonByBox.setEditable(true);
        this.whoWonBox = new JComboBox<String>(new String[]{Defs.getString(-478254136), Defs.getString(-478254171), Defs.getString(-478254159), Defs.getString(-478254153), Defs.getString(-478254140), Defs.getString(-478254142)});
        this.add("xGrow=f,yGrow=f", this.whoWonBox);
        this.byLabel = new JLabel(Defs.getString(-478254168));
        this.add(this.byLabel);
        this.add("xGrow=t", this.wonByBox);
        this.wonByBox.addActionListener(this);
        this.whoWonBox.addActionListener(this);
        Prop param = rootNode.findProp(25);
        if (param == null) {
            this.whoWonBox.setSelectedIndex(5);
        } else {
            float score = param.getFloat();
            int winIndex = score > 0.0f ? 0 : 1;
            switch (param.getInt()) {
                case 0: {
                    if ((double)score == 0.0) {
                        this.whoWonBox.setSelectedIndex(2);
                        break;
                    }
                    if ((double)score > 0.0) {
                        this.whoWonBox.setSelectedIndex(0);
                        this.wonByBox.setSelectedItem(Game.SCORE_FORMATTER.format(score));
                        break;
                    }
                    this.whoWonBox.setSelectedIndex(1);
                    this.wonByBox.setSelectedItem(Game.SCORE_FORMATTER.format(-score));
                    break;
                }
                case 1: {
                    this.whoWonBox.setSelectedIndex(winIndex);
                    this.wonByBox.setSelectedIndex(1);
                    break;
                }
                case 2: {
                    this.whoWonBox.setSelectedIndex(winIndex);
                    this.wonByBox.setSelectedIndex(2);
                    break;
                }
                case 3: {
                    this.whoWonBox.setSelectedIndex(winIndex);
                    this.wonByBox.setSelectedIndex(3);
                    break;
                }
                case 4: {
                    this.whoWonBox.setSelectedIndex(3);
                    break;
                }
                case 5: {
                    this.whoWonBox.setSelectedIndex(4);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.whoWonBox) {
            this.whoWonChanged();
        } else {
            this.wonByChanged();
        }
    }

    private void whoWonChanged() {
        boolean useAll = this.whoWonBox.getSelectedIndex() < 2;
        this.byLabel.setEnabled(useAll);
        this.wonByBox.setEnabled(useAll);
    }

    private void wonByChanged() {
        String curVal = (String)this.wonByBox.getSelectedItem();
        int index = this.wonByBox.getSelectedIndex();
        if (index == -1) {
            if (this.parse(false)) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.wonByBox.getModel();
                model.insertElementAt(curVal, 0);
                model.removeElementAt(1);
            }
        } else {
            this.wonByBox.setEditable(index == 0);
        }
    }

    public boolean parse(boolean changeNode) {
        int winType = 0;
        float score = 0.0f;
        switch (this.whoWonBox.getSelectedIndex()) {
            case 0: {
                score = 1.0f;
                break;
            }
            case 1: {
                score = -1.0f;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                winType = 4;
                break;
            }
            case 4: {
                winType = 5;
                break;
            }
            case 5: {
                if (changeNode) {
                    this.rootNode.removeType(25);
                }
                return true;
            }
        }
        if (score != 0.0f) {
            switch (this.wonByBox.getSelectedIndex()) {
                case -1: 
                case 0: {
                    String text = (String)this.wonByBox.getSelectedItem();
                    try {
                        float enteredVal = Game.SCORE_FORMATTER.parse(text).floatValue();
                        if (enteredVal < 0.0f) {
                            this.printErr(text);
                            return false;
                        }
                        score *= enteredVal;
                        break;
                    }
                    catch (ParseException excep) {
                        this.printErr(text);
                        return false;
                    }
                }
                case 1: {
                    winType = 1;
                    break;
                }
                case 2: {
                    winType = 2;
                    break;
                }
                case 3: {
                    winType = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Index " + this.wonByBox.getSelectedIndex() + "?");
                }
            }
        }
        if (changeNode) {
            this.rootNode.add(new Prop(25, winType, score));
        }
        return true;
    }

    private void printErr(String badVal) {
        if (this.errWin != null) {
            this.errWin.dispose();
        }
        this.errWin = new Errout(Defs.getString(-478254169, badVal), (AFrame)this.getTopLevelAncestor());
    }
}

