/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.main;

import edu.umd.marbl.mhap.align.AlignElementDoubleSketch;
import edu.umd.marbl.mhap.align.AlignElementString;
import edu.umd.marbl.mhap.align.Aligner;
import edu.umd.marbl.mhap.align.Alignment;
import edu.umd.marbl.mhap.impl.MinHashBitSequenceSubSketches;
import edu.umd.marbl.mhap.impl.OverlapInfo;
import edu.umd.marbl.mhap.sketch.MinHashBitSketch;
import edu.umd.marbl.mhap.sketch.ZeroNGramsFoundException;
import edu.umd.marbl.mhap.utils.RandomSequenceGenerator;

public class AlignmentTry {
    public static void main(String[] args) throws ZeroNGramsFoundException {
        String a = "bcdefghij1234567890";
        String b = "abcdefghij1234567890";
        RandomSequenceGenerator generator = new RandomSequenceGenerator();
        a = generator.generateRandomSequence(2000);
        b = a.substring(800, 1800);
        a = generator.addPacBioError(a);
        b = generator.addPacBioError(b);
        Aligner<AlignElementString> aligner = new Aligner<AlignElementString>(true, -2.0, -3.4028234663852886E38, 0.0);
        Alignment<AlignElementString> alignment = aligner.localAlignSmithWaterGotoh(new AlignElementString(a), new AlignElementString(b));
        System.err.println(alignment.getOverlapScore(5));
        System.out.println(alignment.outputAlignment());
        System.err.println("A1=" + alignment.getA1());
        System.err.println("B1=" + alignment.getB1());
        System.err.println("A2=" + alignment.getA2());
        System.err.println("B2=" + alignment.getB2());
        MinHashBitSequenceSubSketches m1 = new MinHashBitSequenceSubSketches(a, 7, 200, 20);
        MinHashBitSequenceSubSketches m2 = new MinHashBitSequenceSubSketches(b, 7, 200, 20);
        OverlapInfo info = m1.getOverlapInfo(new Aligner<AlignElementDoubleSketch<MinHashBitSketch>>(true, 0.0, 0.0, -0.52), m2);
        System.err.println("Compressed=");
        System.err.println(info.rawScore);
        System.err.println(info.a1);
        System.err.println(info.b1);
        System.err.println(info.a2);
        System.err.println(info.b2);
        OverlapInfo info2 = m2.getOverlapInfo(new Aligner<AlignElementDoubleSketch<MinHashBitSketch>>(true, 0.0, 0.0, -0.52), m1);
        System.err.println("Swap=");
        System.err.println(info2.rawScore);
        System.err.println(info2.a1);
        System.err.println(info2.b1);
        System.err.println(info2.a2);
        System.err.println(info2.b2);
        System.exit(1);
    }
}

