/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.cli.commands;

import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.apollo.cli.commands.DiskBenchmark$;
import org.apache.activemq.apollo.cli.commands.Helper;
import org.apache.activemq.apollo.cli.commands.Report;
import org.apache.activemq.apollo.util.IOHelper;
import org.apache.activemq.apollo.util.MemoryPropertyEditor;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandSession;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.sys.package$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="apollo", name="disk-benchmark", description="Benchmarks your disk's speed")
@ScalaSignature(bytes="\u0006\u0001\u0005Uw!B\u0001\u0003\u0011\u000by\u0011!\u0004#jg.\u0014UM\\2i[\u0006\u00148N\u0003\u0002\u0004\t\u0005A1m\\7nC:$7O\u0003\u0002\u0006\r\u0005\u00191\r\\5\u000b\u0005\u001dA\u0011AB1q_2dwN\u0003\u0002\n\u0015\u0005A\u0011m\u0019;jm\u0016l\u0017O\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA)a\u0005\u0002\u000e\t&\u001c8NQ3oG\"l\u0017M]6\u0014\u0007E!B\u0004\u0005\u0002\u001655\taC\u0003\u0002\u00181\u0005!A.\u00198h\u0015\u0005I\u0012\u0001\u00026bm\u0006L!a\u0007\f\u0003\r=\u0013'.Z2u!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000b\r\nB\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\u0005y\u0001b\u0002\u0014\u0012\u0005\u0004%)aJ\u0001\u0012!\"K6+S\"B\u0019~kU)T0T\u0013j+U#\u0001\u0015\u0011\u0005UI\u0013B\u0001\u0016\u0017\u0005\u0019\u0019FO]5oO\"1A&\u0005Q\u0001\u000e!\n!\u0003\u0015%Z'&\u001b\u0015\tT0N\u000b6{6+\u0013.FA\u0019!!C\u0001\u0001/'\u0011iCc\f\u000f\u0011\u0005A2T\"A\u0019\u000b\u0005\r\u0011$BA\u001a5\u0003\u00119wnZ8\u000b\u0005UR\u0011!\u00024fY&D\u0018BA\u001c2\u0005\u0019\t5\r^5p]\")1%\fC\u0001sQ\t!\b\u0005\u0002\u0011[!9A(\fa\u0001\n\u0003i\u0014a\u0002<fe\n|7/Z\u000b\u0002}A\u0011QdP\u0005\u0003\u0001z\u0011qAQ8pY\u0016\fg\u000eC\u0004C[\u0001\u0007I\u0011A\"\u0002\u0017Y,'OY8tK~#S-\u001d\u000b\u0003\t\u001e\u0003\"!H#\n\u0005\u0019s\"\u0001B+oSRDq\u0001S!\u0002\u0002\u0003\u0007a(A\u0002yIEBaAS\u0017!B\u0013q\u0014\u0001\u0003<fe\n|7/\u001a\u0011)\r%cu\n\u0015*T!\t\u0001T*\u0003\u0002Oc\t1q\n\u001d;j_:\fAA\\1nK\u0006\n\u0011+A\u0005.[Y,'OY8tK\u0006YA-Z:de&\u0004H/[8oC\u0005!\u0016!F#oC\ndW\r\t<fe\n|7/\u001a\u0011pkR\u0004X\u000f\u001e\u0005\b-6\u0002\r\u0011\"\u0001X\u00039\u0019\u0018-\u001c9mK&sG/\u001a:wC2,\u0012\u0001\u0017\t\u0003;eK!A\u0017\u0010\u0003\t1{gn\u001a\u0005\b96\u0002\r\u0011\"\u0001^\u0003I\u0019\u0018-\u001c9mK&sG/\u001a:wC2|F%Z9\u0015\u0005\u0011s\u0006b\u0002%\\\u0003\u0003\u0005\r\u0001\u0017\u0005\u0007A6\u0002\u000b\u0015\u0002-\u0002\u001fM\fW\u000e\u001d7f\u0013:$XM\u001d<bY\u0002Bca\u0018'PEJ#\u0017%A2\u0002#5j3/Y7qY\u0016l\u0013N\u001c;feZ\fG.I\u0001f\u0003a\"\u0006.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002j\u0017\u000e\u001c7jg\u0016\u001cwN\u001c3tAQ|\u0007e\u001d9f]\u0012\u0004S.Z:ve&tw\r\t9fe\u001a|W.\u00198dK:BqaZ\u0017A\u0002\u0013\u0005q%\u0001\bcY>\u001c7nX:ju\u0016|F\u000f\u001f;\t\u000f%l\u0003\u0019!C\u0001U\u0006\u0011\"\r\\8dW~\u001b\u0018N_3`ib$x\fJ3r)\t!5\u000eC\u0004IQ\u0006\u0005\t\u0019\u0001\u0015\t\r5l\u0003\u0015)\u0003)\u0003=\u0011Gn\\2l?NL'0Z0uqR\u0004\u0003F\u00027M\u001f>\u0014\u0016/I\u0001q\u00031iSF\u00197pG.l3/\u001b>fC\u0005\u0011\u0018A\b+iK\u0002\u001a\u0018N_3!_\u001a\u0004S-Y2iA%{\u0005e\u001c9fe\u0006$\u0018n\u001c8/\u0011\u0015!X\u0006\"\u0001v\u0003)\u0011Gn\\2l?NL'0Z\u000b\u0002mB\u0011Qd^\u0005\u0003qz\u00111!\u00138u\u0011\u001dQX\u00061A\u0005\u0002\u001d\nQBZ5mK~\u001b\u0018N_3`ib$\bb\u0002?.\u0001\u0004%\t!`\u0001\u0012M&dWmX:ju\u0016|F\u000f\u001f;`I\u0015\fHC\u0001#\u007f\u0011\u001dA50!AA\u0002!Bq!!\u0001.A\u0003&\u0001&\u0001\bgS2,wl]5{K~#\b\u0010\u001e\u0011)\u0011}du*!\u0002S\u0003\u0013\t#!a\u0002\u0002\u00175jc-\u001b7f[ML'0Z\u0011\u0003\u0003\u0017\t\u0001\f\u00165fAML'0\u001a\u0011pM\u0002\"\b.\u001a\u0011eCR\f\u0007EZ5mK\u0002\"x\u000eI;tK2\u0002C\u000f[5tAMDw.\u001e7eA\t,\u0007EY5hA\u0015tw.^4iAQ|\u0007E\u001a7vg\"\u0004C\u000f[3!\u001fN\u0003sO]5uK\u0002\u001a\u0017m\u00195f]!1\u0011qB\u0017\u0005\u0002]\u000b\u0011BZ5mK~\u001b\u0018N_3\t\u0011\u0005MQ\u00061A\u0005\u0002\u001d\n\u0001c^1s[~+\boX:ju\u0016|F\u000f\u001f;\t\u0013\u0005]Q\u00061A\u0005\u0002\u0005e\u0011\u0001F<be6|V\u000f]0tSj,w\f\u001e=u?\u0012*\u0017\u000fF\u0002E\u00037A\u0001\u0002SA\u000b\u0003\u0003\u0005\r\u0001\u000b\u0005\b\u0003?i\u0003\u0015)\u0003)\u0003E9\u0018M]7`kB|6/\u001b>f?RDH\u000f\t\u0015\n\u0003;au*a\tS\u0003O\t#!!\n\u0002\u001d5js/\u0019:n[U\u0004Xf]5{K\u0006\u0012\u0011\u0011F\u0001t)\",\u0007%Y7pk:$\be\u001c4!I\u0006$\u0018\rI<fAMDw.\u001e7eA%t\u0017\u000e^5bY\u0002:(/\u001b;fA\t,gm\u001c:fA5,\u0017m];sS:<\u0007\u0005]3sM>\u0014X.\u00198dK\u0002\u001a\u0018-\u001c9mKN\u0004\u0003&^:fI\u0002\"x\u000e\t4mkND\u0007\u0005\u001e5fA=\u001b\u0006e\u001e:ji\u0016\u00043-Y2iK&r\u0003BBA\u0017[\u0011\u0005q+\u0001\u0007xCJlw,\u001e9`g&TX\rC\u0005\u000225\u0002\r\u0011\"\u0001\u00024\u0005!a-\u001b7f+\t\t)\u0004\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\r\tY\u0004G\u0001\u0003S>LA!a\u0010\u0002:\t!a)\u001b7f\u0011%\t\u0019%\fa\u0001\n\u0003\t)%\u0001\u0005gS2,w\fJ3r)\r!\u0015q\t\u0005\n\u0011\u0006\u0005\u0013\u0011!a\u0001\u0003kA\u0001\"a\u0013.A\u0003&\u0011QG\u0001\u0006M&dW\r\t\u0015\u000b\u0003\u0013\nyeTA+%\u0006]\u0003c\u0001\u0019\u0002R%\u0019\u00111K\u0019\u0003\u0011\u0005\u0013x-^7f]R\f#!!\r\"\u0005\u0005e\u0013A\u0011+iK\u00022\u0017\u000e\\3!i\"\fG\u000fI<jY2\u0004#-\u001a\u0011vg\u0016$\u0007\u0005^8!E\u0016t7\r[7be.\u0004\u0013p\\;sA\u0011L7o\u001b\u0011)[V\u001cH\u000f\t(P)\u0002*\u00070[:uS!9\u0011QL\u0017\u0005\u0002\u0005}\u0013aB3yK\u000e,H/\u001a\u000b\u0005\u0003C\n9\u0007E\u0002\u001e\u0003GJ1!!\u001a\u001f\u0005\u0019\te.\u001f*fM\"A\u0011\u0011NA.\u0001\u0004\tY'A\u0004tKN\u001c\u0018n\u001c8\u0011\t\u00055\u0014qO\u0007\u0003\u0003_RA!!\u001d\u0002t\u000591m\\7nC:$'bAA;i\u000591/\u001a:wS\u000e,\u0017\u0002BA=\u0003_\u0012abQ8n[\u0006tGmU3tg&|g\u000e\u0003\u0005\u0002~5\u0002\r\u0011\"\u0001>\u0003\u00191\u0017\u000e\u001c7fI\"I\u0011\u0011Q\u0017A\u0002\u0013\u0005\u00111Q\u0001\u000bM&dG.\u001a3`I\u0015\fHc\u0001#\u0002\u0006\"A\u0001*a \u0002\u0002\u0003\u0007a\bC\u0004\u0002\n6\u0002\u000b\u0015\u0002 \u0002\u000f\u0019LG\u000e\\3eA!9\u0011QR\u0017\u0005\n\u0005=\u0015!B<sSR,Gc\u0002<\u0002\u0012\u0006m\u00151\u0016\u0005\t\u0003'\u000bY\t1\u0001\u0002\u0016\u0006\u0019!/\u00194\u0011\t\u0005]\u0012qS\u0005\u0005\u00033\u000bID\u0001\tSC:$w.\\!dG\u0016\u001c8OR5mK\"A\u0011QTAF\u0001\u0004\ty*\u0001\u0003eCR\f\u0007#B\u000f\u0002\"\u0006\u0015\u0016bAAR=\t)\u0011I\u001d:bsB\u0019Q$a*\n\u0007\u0005%fD\u0001\u0003CsR,\u0007\u0002CAW\u0003\u0017\u0003\r!a,\u0002\u000bUtG/\u001b7\u0011\u000bu\t\t\f\u0017 \n\u0007\u0005MfDA\u0005Gk:\u001cG/[8oc!9\u0011qW\u0017\u0005\n\u0005e\u0016\u0001\u0002:fC\u0012$rA^A^\u0003{\u000by\f\u0003\u0005\u0002\u0014\u0006U\u0006\u0019AAK\u0011!\ti*!.A\u0002\u0005}\u0005\u0002CAW\u0003k\u0003\r!a,)\u001b5\n\u0019-!3\u0002L>\u000biMUAi!\r\u0001\u0014QY\u0005\u0004\u0003\u000f\f$aB\"p[6\fg\u000eZ\u0001\u0006g\u000e|\u0007/Z\u0011\u0002\u000f\u0005\u0012\u0011qZ\u0001\u000fI&\u001c8.\f2f]\u000eDW.\u0019:lC\t\t\u0019.\u0001\u000fCK:\u001c\u0007.\\1sWN\u0004\u0013p\\;sA\u0011L7o[\u0014tAM\u0004X-\u001a3")
public class DiskBenchmark
implements Action,
ScalaObject {
    @Option(name="--verbose", description="Enable verbose output")
    private boolean verbose = false;
    @Option(name="--sample-interval", description="The number of milliseconds to spend mesuring perfomance.")
    private long sampleInterval = 30000L;
    @Option(name="--block-size", description="The size of each IO operation.")
    private String block_size_txt = "4k";
    @Option(name="--file-size", description="The size of the data file to use, this should be big enough to flush the OS write cache.")
    private String file_size_txt = DiskBenchmark$.MODULE$.PHYSICAL_MEM_SIZE();
    @Option(name="--warm-up-size", description="The amount of data we should initial write before measuring performance samples (used to flush the OS write cache).")
    private String warm_up_size_txt = MemoryPropertyEditor.format((long)BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longWrapper(MemoryPropertyEditor.parse((String)"500M")).min((Object)BoxesRunTime.boxToLong((long)(MemoryPropertyEditor.parse((String)DiskBenchmark$.MODULE$.PHYSICAL_MEM_SIZE()) / 2L)))));
    @Argument(name="file", description="The file that will be used to benchmark your disk (must NOT exist)")
    private File file = new File("disk-benchmark.dat");
    private boolean filled = false;

    public static final String PHYSICAL_MEM_SIZE() {
        return DiskBenchmark$.MODULE$.PHYSICAL_MEM_SIZE();
    }

    public boolean verbose() {
        return this.verbose;
    }

    public void verbose_$eq(boolean bl) {
        this.verbose = bl;
    }

    public long sampleInterval() {
        return this.sampleInterval;
    }

    public void sampleInterval_$eq(long l) {
        this.sampleInterval = l;
    }

    public String block_size_txt() {
        return this.block_size_txt;
    }

    public void block_size_txt_$eq(String string) {
        this.block_size_txt = string;
    }

    public int block_size() {
        return (int)MemoryPropertyEditor.parse((String)this.block_size_txt());
    }

    public String file_size_txt() {
        return this.file_size_txt;
    }

    public void file_size_txt_$eq(String string) {
        this.file_size_txt = string;
    }

    public long file_size() {
        return MemoryPropertyEditor.parse((String)this.file_size_txt());
    }

    public String warm_up_size_txt() {
        return this.warm_up_size_txt;
    }

    public void warm_up_size_txt_$eq(String string) {
        this.warm_up_size_txt = string;
    }

    public long warm_up_size() {
        return MemoryPropertyEditor.parse((String)this.warm_up_size_txt());
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File file) {
        this.file = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(CommandSession session$1) {
        try {
            Object object;
            if (this.file().exists()) {
                this.out$1(session$1).println(new StringBuilder().append((Object)"File ").append((Object)this.file()).append((Object)" allready exists, will not benchmark.").toString());
                return null;
            }
            this.out$1(session$1).println(new StringBuilder().append((Object)"Benchmark using data file: ").append((Object)this.file().getCanonicalPath()).toString());
            byte[] data = new byte[this.block_size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(97 + i % 26);
            }
            Report report = new Report();
            report.block_size_$eq(this.block_size());
            ObjectRef raf$1 = new ObjectRef((Object)new RandomAccessFile(this.file(), "rw"));
            this.out$1(session$1).println(new StringBuilder().append((Object)"Pre-allocating data file of size: ").append((Object)this.file_size_txt()).toString());
            ((RandomAccessFile)raf$1.elem).setLength(this.file_size());
            ((RandomAccessFile)raf$1.elem).seek(this.file_size() - 1L);
            ((RandomAccessFile)raf$1.elem).writeByte(0);
            IOHelper.sync((FileDescriptor)((RandomAccessFile)raf$1.elem).getFD());
            if (this.warm_up_size() > 0L) {
                long max$1 = this.warm_up_size();
                this.out$1(session$1).println(new StringBuilder().append((Object)"Warming up... writing async ").append((Object)this.warm_up_size_txt()).append((Object)" so that async writes don't have that much of an advantage due to the OS write cache.").toString());
                object = BoxesRunTime.boxToInteger((int)this.write((RandomAccessFile)raf$1.elem, data, (Function1<Object, Object>)new Serializable(this, max$1){
                    public static final long serialVersionUID;
                    private final long max$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(long count) {
                        return this.apply$mcZJ$sp(count);
                    }

                    public boolean apply$mcZJ$sp(long v1) {
                        return v1 > this.max$1;
                    }
                    {
                        this.max$1 = l;
                    }
                }));
            } else {
                object = BoxedUnit.UNIT;
            }
            this.out$1(session$1).println("Benchmarking async writes");
            LongRef start$1 = new LongRef(System.nanoTime());
            LongRef end$1 = new LongRef(start$1.elem);
            report.async_writes_$eq(this.write((RandomAccessFile)raf$1.elem, data, (Function1<Object, Object>)new Serializable(this, start$1, end$1){
                public static final long serialVersionUID;
                private final DiskBenchmark $outer;
                private final LongRef start$1;
                private final LongRef end$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(long count) {
                    return this.apply$mcZJ$sp(count);
                }

                public boolean apply$mcZJ$sp(long v1) {
                    this.end$1.elem = System.nanoTime();
                    return TimeUnit.NANOSECONDS.toMillis(this.end$1.elem - this.start$1.elem) > this.$outer.sampleInterval();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.start$1 = longRef;
                    this.end$1 = longRef2;
                }
            }));
            report.async_write_duration_$eq(TimeUnit.NANOSECONDS.toMillis(end$1.elem - start$1.elem));
            this.out$1(session$1).println("Syncing previous writes before measuring sync write performance.. (might take a while if your OS has a big write cache)");
            IOHelper.sync((FileDescriptor)((RandomAccessFile)raf$1.elem).getFD());
            this.out$1(session$1).println("Benchmarking sync writes");
            end$1.elem = start$1.elem = System.nanoTime();
            report.sync_writes_$eq(this.write((RandomAccessFile)raf$1.elem, data, (Function1<Object, Object>)new Serializable(this, raf$1, start$1, end$1){
                public static final long serialVersionUID;
                private final DiskBenchmark $outer;
                private final ObjectRef raf$1;
                private final LongRef start$1;
                private final LongRef end$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(long count) {
                    return this.apply$mcZJ$sp(count);
                }

                public boolean apply$mcZJ$sp(long v1) {
                    IOHelper.sync((FileDescriptor)((RandomAccessFile)this.raf$1.elem).getFD());
                    this.end$1.elem = System.nanoTime();
                    return TimeUnit.NANOSECONDS.toMillis(this.end$1.elem - this.start$1.elem) > this.$outer.sampleInterval();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.raf$1 = objectRef;
                    this.start$1 = longRef;
                    this.end$1 = longRef2;
                }
            }));
            report.sync_write_duration_$eq(TimeUnit.NANOSECONDS.toMillis(end$1.elem - start$1.elem));
            if (!this.filled()) {
                this.file_size_txt_$eq(String.valueOf(BoxesRunTime.boxToLong((long)((RandomAccessFile)raf$1.elem).getFilePointer())));
                this.out$1(session$1).println(new StringBuilder().append((Object)"File was not fully written, read benchmark will be operating against: ").append((Object)BoxesRunTime.boxToFloat((float)((float)((double)this.file_size() / 1048576.0)))).append((Object)" megs of data").toString());
                ((RandomAccessFile)raf$1.elem).seek(0L);
            }
            this.out$1(session$1).println("Benchmarking reads");
            end$1.elem = start$1.elem = System.nanoTime();
            report.reads_$eq(this.read((RandomAccessFile)raf$1.elem, data, (Function1<Object, Object>)new Serializable(this, start$1, end$1){
                public static final long serialVersionUID;
                private final DiskBenchmark $outer;
                private final LongRef start$1;
                private final LongRef end$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(long count) {
                    return this.apply$mcZJ$sp(count);
                }

                public boolean apply$mcZJ$sp(long v1) {
                    this.end$1.elem = System.nanoTime();
                    return TimeUnit.NANOSECONDS.toMillis(this.end$1.elem - this.start$1.elem) > this.$outer.sampleInterval();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.start$1 = longRef;
                    this.end$1 = longRef2;
                }
            }));
            report.read_duration_$eq(TimeUnit.NANOSECONDS.toMillis(end$1.elem - start$1.elem));
            this.file().delete();
            this.out$1(session$1).println(report);
            return null;
            finally {
                this.out$1(session$1).println("Closing.");
                ((RandomAccessFile)raf$1.elem).close();
            }
        }
        catch (Throwable throwable) {
            if (this.verbose()) {
                this.out$1(session$1).println("ERROR:");
                throwable.printStackTrace(System.out);
                return null;
            }
            this.out$1(session$1).println(new StringBuilder().append((Object)"ERROR: ").append((Object)throwable).toString());
            return null;
        }
        catch (Helper.Failure failure) {
            throw package$.MODULE$.error(failure.getMessage());
        }
    }

    public boolean filled() {
        return this.filled;
    }

    public void filled_$eq(boolean bl) {
        this.filled = bl;
    }

    private int write(RandomAccessFile raf, byte[] data, Function1<Object, Object> until) {
        long file_position = raf.getFilePointer();
        int counter = 0;
        while (!until.apply$mcZJ$sp((long)counter * (long)data.length)) {
            if (file_position + (long)data.length >= this.file_size()) {
                this.filled_$eq(true);
                file_position = 0L;
                raf.seek(file_position);
            }
            raf.write(data);
            ++counter;
            file_position += (long)data.length;
        }
        return counter;
    }

    private int read(RandomAccessFile raf, byte[] data, Function1<Object, Object> until) {
        long file_position = raf.getFilePointer();
        int counter = 0;
        while (!until.apply$mcZJ$sp((long)counter * (long)data.length)) {
            if (file_position + (long)data.length >= this.file_size()) {
                file_position = 0L;
                raf.seek(file_position);
            }
            raf.readFully(data);
            ++counter;
            file_position += (long)data.length;
        }
        return counter;
    }

    private final PrintStream out$1(CommandSession commandSession) {
        return commandSession.getConsole();
    }
}

