/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;

final class Threads {
    private static final EnumMap<Thread.State, String> lockInfoStrings = new EnumMap(Thread.State.class);

    private Threads() {
    }

    public static String threadName(Thread t) {
        return "Thread[id=" + t.getId() + ", name=" + t.getName() + ", state=" + (Object)((Object)t.getState()) + ", group=" + Threads.groupName(t.getThreadGroup()) + "]";
    }

    private static String groupName(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            return "{null group}";
        }
        return threadGroup.getName();
    }

    public static void append(StringBuilder b, ThreadInfo ti) {
        b.append('\"').append(ti.getThreadName()).append('\"');
        b.append(" ID=").append(ti.getThreadId());
        Thread.State threadState = ti.getThreadState();
        b.append(" ").append((Object)threadState);
        if (ti.getLockName() != null) {
            b.append(" on ").append(ti.getLockName());
        }
        if (ti.getLockOwnerName() != null) {
            b.append(" owned by \"").append(ti.getLockOwnerName()).append("\" ID=").append(ti.getLockOwnerId());
        }
        b.append(ti.isSuspended() ? " (suspended)" : "");
        b.append(ti.isInNative() ? " (in native code)" : "");
        b.append("\n");
        StackTraceElement[] stack = ti.getStackTrace();
        LockInfo lockInfo = ti.getLockInfo();
        MonitorInfo[] monitorInfos = ti.getLockedMonitors();
        for (int i = 0; i < stack.length; ++i) {
            b.append("\tat ").append(stack[i]).append("\n");
            if (i == 0 && lockInfo != null) {
                b.append("\t- ").append(lockInfoStrings.get((Object)threadState)).append(lockInfo).append("\n");
            }
            for (LockInfo lockInfo2 : monitorInfos) {
                if (((MonitorInfo)lockInfo2).getLockedStackDepth() != i) continue;
                b.append("\t- locked ").append(lockInfo2).append("\n");
            }
        }
        LockInfo[] lockInfos = ti.getLockedSynchronizers();
        if (lockInfos.length > 0) {
            b.append("\tLocked synchronizers:\n");
            for (LockInfo lockInfo3 : ti.getLockedSynchronizers()) {
                b.append("\t- ").append(lockInfo3).append("\n");
            }
        }
        b.append("\n");
    }

    public static HashSet<Thread> getAllThreads() {
        ThreadGroup tg = Threads.getTopThreadGroup();
        return Threads.getThreads(tg);
    }

    public static HashSet<Thread> getThreads(ThreadGroup tg) {
        int maxIndex;
        Thread[] threads = new Thread[2];
        while ((maxIndex = Threads.doEnumerate(tg, threads, true)) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        return new HashSet<Thread>(Arrays.asList(threads).subList(0, maxIndex));
    }

    private static int doEnumerate(final ThreadGroup tg, final Thread[] threads, final boolean recurse) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return tg.enumerate(threads, recurse);
            }
        });
    }

    public static ThreadGroup getTopThreadGroup() {
        ThreadGroup tg = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

            @Override
            public ThreadGroup run() {
                ThreadGroup tg;
                for (tg = Thread.currentThread().getThreadGroup(); tg != null && tg.getParent() != null; tg = tg.getParent()) {
                }
                return tg;
            }
        });
        if (tg == null) {
            throw new RuntimeException("No root ThreadGroup for thread: " + Thread.currentThread());
        }
        return tg;
    }

    static {
        lockInfoStrings.put(Thread.State.BLOCKED, "blocked on ");
        lockInfoStrings.put(Thread.State.WAITING, "waiting on ");
        lockInfoStrings.put(Thread.State.TIMED_WAITING, "timed waiting on ");
        lockInfoStrings.put(Thread.State.TERMINATED, "terminated? on ");
        lockInfoStrings.put(Thread.State.RUNNABLE, "runnable? on ");
        lockInfoStrings.put(Thread.State.NEW, "new? on ");
    }
}

