/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.search.function.MultiStringFunction;

public class ConcatStringFunction
extends MultiStringFunction {
    public static final String NAME = "concat";

    public ConcatStringFunction(ValueSource[] sources) {
        super(sources);
    }

    @Override
    protected String name() {
        return NAME;
    }

    @Override
    protected String func(int doc, FunctionValues[] valsArr) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (FunctionValues val : valsArr) {
            String v = val.strVal(doc);
            if (v == null) {
                return null;
            }
            sb.append(v);
        }
        return sb.toString();
    }
}

