/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate.values;

import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.stress.generate.values.GeneratorConfig;
import org.apache.cassandra.stress.settings.OptionDistribution;

public abstract class Generator<T> {
    public final String name;
    public final AbstractType<T> type;
    public final Class<?> clazz;
    final long salt;
    final Distribution identityDistribution;
    final Distribution sizeDistribution;
    public final Distribution clusteringDistribution;

    public Generator(AbstractType<T> type, GeneratorConfig config, String name, Class<?> clazz) {
        this.type = type;
        this.name = name;
        this.clazz = clazz;
        this.salt = config.salt;
        this.identityDistribution = config.getIdentityDistribution(this.defaultIdentityDistribution());
        this.sizeDistribution = config.getSizeDistribution(this.defaultSizeDistribution());
        this.clusteringDistribution = config.getClusteringDistribution(this.defaultClusteringDistribution());
    }

    public void setSeed(long seed) {
        this.identityDistribution.setSeed(seed ^ this.salt);
        this.clusteringDistribution.setSeed(seed ^ (this.salt ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public abstract T generate();

    DistributionFactory defaultIdentityDistribution() {
        return OptionDistribution.get("uniform(1..100B)");
    }

    DistributionFactory defaultSizeDistribution() {
        return OptionDistribution.get("uniform(4..8)");
    }

    DistributionFactory defaultClusteringDistribution() {
        return OptionDistribution.get("fixed(1)");
    }
}

