/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.utils.CoreUtils$;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.utils.KafkaThread;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u0001\u001d\u0011abS1gW\u0006\u001c6\r[3ek2,'O\u0003\u0002\u0004\t\u0005)Q\u000f^5mg*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001AaB\u0005\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!!C*dQ\u0016$W\u000f\\3s!\ty1#\u0003\u0002\u0015\u0005\t9Aj\\4hS:<\u0007\u0002\u0003\f\u0001\u0005\u000b\u0007I\u0011A\f\u0002\u000fQD'/Z1egV\t\u0001\u0004\u0005\u0002\n3%\u0011!D\u0003\u0002\u0004\u0013:$\b\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\u0011QD'/Z1eg\u0002B\u0001B\b\u0001\u0003\u0006\u0004%\taH\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb,\u0012\u0001\t\t\u0003C!r!A\t\u0014\u0011\u0005\rRQ\"\u0001\u0013\u000b\u0005\u00152\u0011A\u0002\u001fs_>$h(\u0003\u0002(\u0015\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9#\u0002\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003!\u0003E!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010\t\u0005\t]\u0001\u0011\t\u0011)A\u0005_\u00051A-Y3n_:\u0004\"!\u0003\u0019\n\u0005ER!a\u0002\"p_2,\u0017M\u001c\u0005\u0006g\u0001!\t\u0001N\u0001\u0007y%t\u0017\u000e\u001e \u0015\tU2t\u0007\u000f\t\u0003\u001f\u0001AQA\u0006\u001aA\u0002aAqA\b\u001a\u0011\u0002\u0003\u0007\u0001\u0005C\u0004/eA\u0005\t\u0019A\u0018\t\u000fi\u0002\u0001\u0019!C\u0005w\u0005AQ\r_3dkR|'/F\u0001=!\tiD)D\u0001?\u0015\ty\u0004)\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u0011\"\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0007\u0006!!.\u0019<b\u0013\t)eHA\u000eTG\",G-\u001e7fIRC'/Z1e!>|G.\u0012=fGV$xN\u001d\u0005\b\u000f\u0002\u0001\r\u0011\"\u0003I\u00031)\u00070Z2vi>\u0014x\fJ3r)\tIE\n\u0005\u0002\n\u0015&\u00111J\u0003\u0002\u0005+:LG\u000fC\u0004N\r\u0006\u0005\t\u0019\u0001\u001f\u0002\u0007a$\u0013\u0007\u0003\u0004P\u0001\u0001\u0006K\u0001P\u0001\nKb,7-\u001e;pe\u0002Bq!\u0015\u0001C\u0002\u0013%!+A\ttG\",G-\u001e7feRC'/Z1e\u0013\u0012,\u0012a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-z\na!\u0019;p[&\u001c\u0017B\u0001-V\u00055\tEo\\7jG&sG/Z4fe\"1!\f\u0001Q\u0001\nM\u000b!c]2iK\u0012,H.\u001a:UQJ,\u0017\rZ%eA!)A\f\u0001C!;\u000691\u000f^1siV\u0004H#A%\t\u000b}\u0003A\u0011I/\u0002\u0011MDW\u000f\u001e3po:DQ!\u0019\u0001\u0005\u0002\t\f\u0001b]2iK\u0012,H.\u001a\u000b\u0007\u0013\u000e,'n\\9\t\u000b\u0011\u0004\u0007\u0019\u0001\u0011\u0002\t9\fW.\u001a\u0005\u0006M\u0002\u0004\raZ\u0001\u0004MVt\u0007cA\u0005i\u0013&\u0011\u0011N\u0003\u0002\n\rVt7\r^5p]BBqa\u001b1\u0011\u0002\u0003\u0007A.A\u0003eK2\f\u0017\u0010\u0005\u0002\n[&\u0011aN\u0003\u0002\u0005\u0019>tw\rC\u0004qAB\u0005\t\u0019\u00017\u0002\rA,'/[8e\u0011\u001d\u0011\b\r%AA\u0002M\fA!\u001e8jiB\u0011Q\b^\u0005\u0003kz\u0012\u0001\u0002V5nKVs\u0017\u000e\u001e\u0005\u0006o\u0002!\t\u0001_\u0001\u0011e\u0016\u001c\u0018N_3UQJ,\u0017\r\u001a)p_2$\"!S=\t\u000bi4\b\u0019\u0001\r\u0002\u000f9,woU5{K\")A\u0010\u0001C\u0001{\u0006I\u0011n]*uCJ$X\rZ\u000b\u0002_!)q\u0010\u0001C\u0005;\u0006iQM\\:ve\u0016\u0014VO\u001c8j]\u001eD3\u0001AA\u0002!\ry\u0011QA\u0005\u0004\u0003\u000f\u0011!A\u0003;ie\u0016\fGm]1gK\u001eI\u00111\u0002\u0002\u0002\u0002#\u0005\u0011QB\u0001\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s!\ry\u0011q\u0002\u0004\t\u0003\t\t\t\u0011#\u0001\u0002\u0012M\u0019\u0011q\u0002\u0005\t\u000fM\ny\u0001\"\u0001\u0002\u0016Q\u0011\u0011Q\u0002\u0005\u000b\u00033\ty!%A\u0005\u0002\u0005m\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u001e)\u001a\u0001%a\b,\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003[i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u000b\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003_\t)CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a\r\u0002\u0010E\u0005I\u0011AA\u001b\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0007\u0016\u0004_\u0005}\u0001")
public class KafkaScheduler
implements Scheduler,
Logging {
    private final int threads;
    private final String threadNamePrefix;
    public final boolean kafka$utils$KafkaScheduler$$daemon;
    private ScheduledThreadPoolExecutor executor;
    private final AtomicInteger kafka$utils$KafkaScheduler$$schedulerThreadId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return KafkaScheduler$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return KafkaScheduler$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public long schedule$default$3() {
        return Scheduler.schedule$default$3$(this);
    }

    @Override
    public long schedule$default$4() {
        return Scheduler.schedule$default$4$(this);
    }

    @Override
    public TimeUnit schedule$default$5() {
        return Scheduler.schedule$default$5$(this);
    }

    private Logger logger$lzycompute() {
        KafkaScheduler kafkaScheduler = this;
        synchronized (kafkaScheduler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int threads() {
        return this.threads;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private ScheduledThreadPoolExecutor executor() {
        return this.executor;
    }

    private void executor_$eq(ScheduledThreadPoolExecutor x$1) {
        this.executor = x$1;
    }

    public AtomicInteger kafka$utils$KafkaScheduler$$schedulerThreadId() {
        return this.kafka$utils$KafkaScheduler$$schedulerThreadId;
    }

    @Override
    public void startup() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Initializing task scheduler.");
        KafkaScheduler kafkaScheduler = this;
        synchronized (kafkaScheduler) {
            if (this.isStarted()) {
                throw new IllegalStateException("This scheduler has already been started!");
            }
            this.executor_$eq(new ScheduledThreadPoolExecutor(this.threads()));
            this.executor().setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.executor().setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.executor().setThreadFactory(new ThreadFactory(this){
                private final /* synthetic */ KafkaScheduler $outer;

                public Thread newThread(Runnable runnable) {
                    return new KafkaThread(this.$outer.threadNamePrefix() + this.$outer.kafka$utils$KafkaScheduler$$schedulerThreadId().getAndIncrement(), runnable, this.$outer.kafka$utils$KafkaScheduler$$daemon);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    @Override
    public void shutdown() {
        block3: {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down task scheduler.");
            ScheduledThreadPoolExecutor cachedExecutor = this.executor();
            if (cachedExecutor == null) break block3;
            KafkaScheduler kafkaScheduler = this;
            synchronized (kafkaScheduler) {
                cachedExecutor.shutdown();
                this.executor_$eq(null);
            }
            cachedExecutor.awaitTermination(1L, TimeUnit.DAYS);
        }
    }

    @Override
    public void schedule(String name, Function0<BoxedUnit> fun, long delay, long period, TimeUnit unit) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Scheduling task %s with initial delay %d ms and period %d ms.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.convert(delay, unit)), BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.convert(period, unit))})));
        KafkaScheduler kafkaScheduler = this;
        synchronized (kafkaScheduler) {
            this.ensureRunning();
            Runnable runnable = CoreUtils$.MODULE$.runnable((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                try {
                    try {
                        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning execution of scheduled task '%s'.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                        fun.apply$mcV$sp();
                    }
                    catch (Throwable t) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Uncaught exception in scheduled task '" + name + "'", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    }
                }
                finally {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Completed execution of scheduled task '%s'.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                }
            });
            ScheduledFuture<?> scheduledFuture = period >= 0L ? this.executor().scheduleAtFixedRate(runnable, delay, period, unit) : this.executor().schedule(runnable, delay, unit);
        }
    }

    public void resizeThreadPool(int newSize) {
        this.executor().setCorePoolSize(newSize);
    }

    @Override
    public synchronized boolean isStarted() {
        return this.executor() != null;
    }

    private void ensureRunning() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Kafka scheduler is not running.");
        }
    }

    public KafkaScheduler(int threads, String threadNamePrefix, boolean daemon) {
        this.threads = threads;
        this.threadNamePrefix = threadNamePrefix;
        this.kafka$utils$KafkaScheduler$$daemon = daemon;
        Logging.$init$(this);
        this.executor = null;
        this.kafka$utils$KafkaScheduler$$schedulerThreadId = new AtomicInteger(0);
    }
}

