#############################################################################
##
#W  grpperm.gd                  GAP library                    Heiko Thei"sen
##
#H  @(#)$Id: grpperm.gd,v 4.46 2002/04/15 10:04:52 sal Exp $
##
#Y  Copyright (C)  1997,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
#Y  (C) 1998 School Math and Comp. Sci., University of St.  Andrews, Scotland
#Y  Copyright (C) 2002 The GAP Group
##
Revision.grpperm_gd :=
    "@(#)$Id: grpperm.gd,v 4.46 2002/04/15 10:04:52 sal Exp $";


#############################################################################
##
#C  IsPermGroup( <obj> )
##
##  A permutation group is a  group of permutations on  a finite set
##  $\Omega$ of  positive integers. {\GAP} does *not*  require the user to
##  specify the operation domain  $\Omega$ when a permutation  group is
##  defined.
##
DeclareSynonym( "IsPermGroup", IsGroup and IsPermCollection );


#############################################################################
##
#M  IsSubsetLocallyFiniteGroup( <G> ) . . . . . .  for magmas of permutations
##
#T  Here we assume implicitly that all permutations are finitary!
#T  (What would be a permutation with unbounded largest moved point?
#T  Perhaps a permutation of possibly infinite order?)
##
InstallTrueMethod( IsSubsetLocallyFiniteGroup, IsPermCollection );


#############################################################################
##
#M  CanEasilySortElements
##
InstallTrueMethod( CanEasilySortElements, IsPermGroup and IsFinite );

#############################################################################
##
#M  KnowsHowToDecompose( <G> )  . . . . . . . .  always true for perm. groups
##
InstallTrueMethod( KnowsHowToDecompose, IsPermGroup );


#############################################################################
##
#M  IsGeneratorsOfMagmaWithInverses( <permcoll> ) . . . true for perm. colls.
##
InstallTrueMethod( IsGeneratorsOfMagmaWithInverses, IsPermCollection );


#############################################################################
##
#F  MinimizeExplicitTransversal
##
DeclareGlobalFunction( "MinimizeExplicitTransversal" );


#############################################################################
##
#F  AddCosetInfoStabChain
##
DeclareGlobalFunction( "AddCosetInfoStabChain" );


#############################################################################
##
#F  NumberCoset
#F  CosetNumber
##
DeclareGlobalFunction( "NumberCoset" );

DeclareGlobalFunction( "CosetNumber" );


#############################################################################
##
#F  IndependentGeneratorsAbelianPPermGroup
##
DeclareGlobalFunction( "IndependentGeneratorsAbelianPPermGroup" );


#############################################################################
##
#F  OrbitPerms( <perms>, <pnt> )
##
##  returns the orbit of the positive integer <pnt>
##  under the group generated by the permutations in the list <perms>.
##
DeclareGlobalFunction( "OrbitPerms" );


#############################################################################
##
#F  OrbitsPerms( <perms>, <D> )
##
##  returns the list of orbits of the positive integers in the list <D>
##  under the group generated by the permutations in the list <perms>.
##
DeclareGlobalFunction( "OrbitsPerms" );


#############################################################################
##
#F  SylowSubgroupPermGroup
##
DeclareGlobalFunction( "SylowSubgroupPermGroup" );


#############################################################################
##
#F  SignPermGroup
##
DeclareGlobalFunction( "SignPermGroup" );


#############################################################################
##
#F  CycleStructuresGroup
##
DeclareGlobalFunction( "CycleStructuresGroup" );


#############################################################################
##
#F  ApproximateSuborbitsStabilizerPermGroup( <G>, <pnt> )
##
##  returns an approximation of the orbits of `Stabilizer( <G>, <pnt> )'
##  on all points of the orbit `Orbit( <G>, <pnt> )',
##  without computing the full point stabilizer;
##  As not all Schreier generators are used,
##  the result may represent the orbits of only a subgroup of the point
##  stabilizer.
##
DeclareGlobalFunction("ApproximateSuborbitsStabilizerPermGroup");


#############################################################################
##
#A  AllBlocks( <G> )
##
##  computes a list of representatives of all block systems for a
##  permutation group <G> acting transitively on the points moved by the
##  group.
##
DeclareAttribute( "AllBlocks", IsPermGroup );


#############################################################################
##
#A  TransitiveIdentification( <G> )
##
##  Let <G> be a permutation group, acting transitively on a set  of up to 30
##  points.  Then `TransitiveIdentification' will return the position of this
##  group in the transitive  groups library.  This means,  if <G> acts on
##  $m$ points and    `TransitiveIdentification'  returns $n$,  then <G>   is
##  permutation isomorphic to the group `TransitiveGroup(m,n)'.
##
##  Note: The points moved do *not* need to be [1..<n>], the group
##  $\langle (2,3,4),(2,3)\rangle$ is considered to be transitive on 3
##  points. If the group has several orbits on the points moved by it the
##  result of `TransitiveIdentification' is undefined.
##
DeclareAttribute( "TransitiveIdentification", IsPermGroup );

#############################################################################
##
#A  PrimitiveIdentification( <G> )
##
##  For a primitive permutation group for which an $S_n$-conjugate exists in
##  the library of primitive permutation groups (see~"Primitive Permutation
##  Groups"), this attribute returns the index position. That is <G> is
##  conjugate to
##  `PrimitiveGroup(NrMovedPoints(<G>),PrimitiveIdentification(<G>)'.
##
##  Methods only exist if the primitive groups library is installed.
##
##  Note: As this function uses the primitive groups library, the result is
##  only guaranteed to the same extent as this library. If it is incomplete,
##  `PrimitiveIdentification' might return an existing index number for a
##  group not in the library.
##
DeclareAttribute( "PrimitiveIdentification", IsPermGroup );

#############################################################################
##
#A  ONanScottType( <G> )
##
##  returns the type of <G> of a primitive permutation group <G>, according
##  to the O'Nan-Scott classification. The labelling of the different types
##  is not consistent in the literature, we use the following:
##  \beginlist
##  \item{1} Affine.
##  \item{2} Almost simple.
##  \item{3a} Diagonal, Socle consists of two normal subgroups.
##  \item{3b} Diagonal, Socle is minimal normal.
##  \item{4a} Product action with the first factor primitive of type 3a.
##  \item{4b} Product action with the first factor primitive of type 3b.
##  \item{4c} Product action with the first factor primitive of type 2.
##  \item{5} Twisted wreath product
##  \endlist
##  %%  See \cite{eickhulpkeXX} for correspondence to other labellings used
##  %%  in the literature.
##  As it can contain letters, the type is returned as a string.
##
##  If <G> is not a permutation group or does not act primitively on the
##  points moved by it, the result is undefined.
##
DeclareAttribute( "ONanScottType", IsPermGroup );

#############################################################################
##
#A  SocleTypePrimitiveGroup( <G> )
##
##  returns the socle type of a primitive permutation group. The socle of a
##  primitive group is the direct product of isomorphic simple groups,
##  therefore the type is indicated by a record with components `series',
##  `parameter' (both as described under
##  `IsomorphismTypeInfoFiniteSimpleGroup',
##  see~"IsomorphismTypeInfoFiniteSimpleGroup") and `width' for the number of
##  direct factors.
##
##  If <G> does not have a faithful primitive action, the result is undefined.
##
DeclareAttribute( "SocleTypePrimitiveGroup", IsPermGroup );

#############################################################################
##
#F  DiagonalSocleAction( <grp>,<n> )
##
##  returns the direct product of <n> copied of <grp> in diagonal action.
##
DeclareGlobalFunction( "DiagonalSocleAction" );


#############################################################################
##
#E

