/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.buildutil;

import com.amazon.aes.webservices.client.cmd.ActivateLicense;
import com.amazon.aes.webservices.client.cmd.AddGroup;
import com.amazon.aes.webservices.client.cmd.AllocateAddress;
import com.amazon.aes.webservices.client.cmd.AssociateAddress;
import com.amazon.aes.webservices.client.cmd.AssociateDhcpOptions;
import com.amazon.aes.webservices.client.cmd.AttachVolume;
import com.amazon.aes.webservices.client.cmd.AttachVpnGateway;
import com.amazon.aes.webservices.client.cmd.AuthorizeGroup;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.BundleInstance;
import com.amazon.aes.webservices.client.cmd.CancelBundleTask;
import com.amazon.aes.webservices.client.cmd.CancelConversionTask;
import com.amazon.aes.webservices.client.cmd.CancelSpotInstanceRequests;
import com.amazon.aes.webservices.client.cmd.ConfirmProductInstance;
import com.amazon.aes.webservices.client.cmd.CreateCustomerGateway;
import com.amazon.aes.webservices.client.cmd.CreateDhcpOptions;
import com.amazon.aes.webservices.client.cmd.CreateImage;
import com.amazon.aes.webservices.client.cmd.CreateKeyPair;
import com.amazon.aes.webservices.client.cmd.CreatePlacementGroup;
import com.amazon.aes.webservices.client.cmd.CreateSnapshot;
import com.amazon.aes.webservices.client.cmd.CreateSpotDatafeedSubscription;
import com.amazon.aes.webservices.client.cmd.CreateSubnet;
import com.amazon.aes.webservices.client.cmd.CreateTags;
import com.amazon.aes.webservices.client.cmd.CreateVolume;
import com.amazon.aes.webservices.client.cmd.CreateVpc;
import com.amazon.aes.webservices.client.cmd.CreateVpnConnection;
import com.amazon.aes.webservices.client.cmd.CreateVpnGateway;
import com.amazon.aes.webservices.client.cmd.DeactivateLicense;
import com.amazon.aes.webservices.client.cmd.DeleteCustomerGateway;
import com.amazon.aes.webservices.client.cmd.DeleteDhcpOptions;
import com.amazon.aes.webservices.client.cmd.DeleteDiskImage;
import com.amazon.aes.webservices.client.cmd.DeleteGroup;
import com.amazon.aes.webservices.client.cmd.DeleteKeyPair;
import com.amazon.aes.webservices.client.cmd.DeletePlacementGroup;
import com.amazon.aes.webservices.client.cmd.DeleteSnapshot;
import com.amazon.aes.webservices.client.cmd.DeleteSpotDatafeedSubscription;
import com.amazon.aes.webservices.client.cmd.DeleteSubnet;
import com.amazon.aes.webservices.client.cmd.DeleteTags;
import com.amazon.aes.webservices.client.cmd.DeleteVolume;
import com.amazon.aes.webservices.client.cmd.DeleteVpc;
import com.amazon.aes.webservices.client.cmd.DeleteVpnConnection;
import com.amazon.aes.webservices.client.cmd.DeleteVpnGateway;
import com.amazon.aes.webservices.client.cmd.DeregisterImage;
import com.amazon.aes.webservices.client.cmd.DescribeAddresses;
import com.amazon.aes.webservices.client.cmd.DescribeAvailabilityZones;
import com.amazon.aes.webservices.client.cmd.DescribeBundleTasks;
import com.amazon.aes.webservices.client.cmd.DescribeConversionTasks;
import com.amazon.aes.webservices.client.cmd.DescribeCustomerGateways;
import com.amazon.aes.webservices.client.cmd.DescribeDhcpOptions;
import com.amazon.aes.webservices.client.cmd.DescribeGroups;
import com.amazon.aes.webservices.client.cmd.DescribeImageAttribute;
import com.amazon.aes.webservices.client.cmd.DescribeImages;
import com.amazon.aes.webservices.client.cmd.DescribeInstanceAttribute;
import com.amazon.aes.webservices.client.cmd.DescribeInstances;
import com.amazon.aes.webservices.client.cmd.DescribeKeyPairs;
import com.amazon.aes.webservices.client.cmd.DescribeLicenses;
import com.amazon.aes.webservices.client.cmd.DescribePlacementGroups;
import com.amazon.aes.webservices.client.cmd.DescribeRegions;
import com.amazon.aes.webservices.client.cmd.DescribeReservedInstances;
import com.amazon.aes.webservices.client.cmd.DescribeReservedInstancesOfferings;
import com.amazon.aes.webservices.client.cmd.DescribeSnapshotAttribute;
import com.amazon.aes.webservices.client.cmd.DescribeSnapshots;
import com.amazon.aes.webservices.client.cmd.DescribeSpotDatafeedSubscription;
import com.amazon.aes.webservices.client.cmd.DescribeSpotInstanceRequests;
import com.amazon.aes.webservices.client.cmd.DescribeSpotPriceHistory;
import com.amazon.aes.webservices.client.cmd.DescribeSubnets;
import com.amazon.aes.webservices.client.cmd.DescribeTags;
import com.amazon.aes.webservices.client.cmd.DescribeVolumes;
import com.amazon.aes.webservices.client.cmd.DescribeVpcs;
import com.amazon.aes.webservices.client.cmd.DescribeVpnConnections;
import com.amazon.aes.webservices.client.cmd.DescribeVpnGateways;
import com.amazon.aes.webservices.client.cmd.DetachVolume;
import com.amazon.aes.webservices.client.cmd.DetachVpnGateway;
import com.amazon.aes.webservices.client.cmd.DisassociateAddress;
import com.amazon.aes.webservices.client.cmd.FingerprintKey;
import com.amazon.aes.webservices.client.cmd.GetConsoleOutput;
import com.amazon.aes.webservices.client.cmd.GetPassword;
import com.amazon.aes.webservices.client.cmd.ImportInstance;
import com.amazon.aes.webservices.client.cmd.ImportKeyPair;
import com.amazon.aes.webservices.client.cmd.ImportVolume;
import com.amazon.aes.webservices.client.cmd.MigrateBundle;
import com.amazon.aes.webservices.client.cmd.ModifyImageAttribute;
import com.amazon.aes.webservices.client.cmd.ModifyInstanceAttribute;
import com.amazon.aes.webservices.client.cmd.ModifySnapshotAttribute;
import com.amazon.aes.webservices.client.cmd.MonitorInstances;
import com.amazon.aes.webservices.client.cmd.PurchaseReservedInstancesOffering;
import com.amazon.aes.webservices.client.cmd.RebootInstances;
import com.amazon.aes.webservices.client.cmd.RegisterImage;
import com.amazon.aes.webservices.client.cmd.ReleaseAddress;
import com.amazon.aes.webservices.client.cmd.RequestSpotInstances;
import com.amazon.aes.webservices.client.cmd.ResetImageAttribute;
import com.amazon.aes.webservices.client.cmd.ResetInstanceAttribute;
import com.amazon.aes.webservices.client.cmd.ResetSnapshotAttribute;
import com.amazon.aes.webservices.client.cmd.RevokeGroup;
import com.amazon.aes.webservices.client.cmd.RunInstances;
import com.amazon.aes.webservices.client.cmd.ShowVersion;
import com.amazon.aes.webservices.client.cmd.StartInstances;
import com.amazon.aes.webservices.client.cmd.StopInstances;
import com.amazon.aes.webservices.client.cmd.TerminateInstances;
import com.amazon.aes.webservices.client.cmd.UnmonitorInstances;
import com.amazon.aes.webservices.client.cmd.UploadDiskImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class GenerateCommandLineTool {
    private static final List<Class<? extends BaseCmd>> COMMANDS = new ListCreator<Class<ActivateLicense>>().a(ActivateLicense.class).a(AddGroup.class).a(AllocateAddress.class).a(AssociateAddress.class).a(AssociateDhcpOptions.class).a(AttachVolume.class).a(AttachVpnGateway.class).a(AuthorizeGroup.class).a(BundleInstance.class).a(CancelBundleTask.class).a(CancelSpotInstanceRequests.class).a(ConfirmProductInstance.class).a(CreateCustomerGateway.class).a(CreateDhcpOptions.class).a(CreateImage.class).a(CreateKeyPair.class).a(CreateSpotDatafeedSubscription.class).a(CreateSnapshot.class).a(CreateSubnet.class).a(CreateVolume.class).a(CreateVpc.class).a(CreateVpnConnection.class).a(CreateVpnGateway.class).a(DeactivateLicense.class).a(DeleteCustomerGateway.class).a(DeleteDhcpOptions.class).a(DeleteGroup.class).a(DeleteKeyPair.class).a(DeleteSnapshot.class).a(DeleteSpotDatafeedSubscription.class).a(DeleteSubnet.class).a(DeleteVolume.class).a(DeleteVpc.class).a(DeleteVpnConnection.class).a(DeleteVpnGateway.class).a(DeregisterImage.class).a(DescribeAddresses.class).a(DescribeAvailabilityZones.class).a(DescribeBundleTasks.class).a(DescribeConversionTasks.class).a(DescribeCustomerGateways.class).a(DescribeDhcpOptions.class).a(DescribeGroups.class).a(DescribeInstanceAttribute.class).a(DescribeImageAttribute.class).a(DescribeImages.class).a(DescribeInstances.class).a(DescribeKeyPairs.class).a(DescribeLicenses.class).a(DescribeRegions.class).a(DescribeReservedInstances.class).a(DescribeReservedInstancesOfferings.class).a(DescribeSnapshotAttribute.class).a(DescribeSnapshots.class).a(DescribeSpotDatafeedSubscription.class).a(DescribeSpotInstanceRequests.class).a(DescribeSpotPriceHistory.class).a(DescribeSubnets.class).a(DescribeVolumes.class).a(DescribeVpcs.class).a(DescribeVpnConnections.class).a(DescribeVpnGateways.class).a(DetachVolume.class).a(DetachVpnGateway.class).a(DisassociateAddress.class).a(FingerprintKey.class).a(GetConsoleOutput.class).a(GetPassword.class).a(ImportVolume.class).a(ImportInstance.class).a(MigrateBundle.class).a(ModifyImageAttribute.class).a(ModifyInstanceAttribute.class).a(ModifySnapshotAttribute.class).a(MonitorInstances.class).a(PurchaseReservedInstancesOffering.class).a(RebootInstances.class).a(RegisterImage.class).a(ReleaseAddress.class).a(RequestSpotInstances.class).a(ResetInstanceAttribute.class).a(ResetImageAttribute.class).a(ResetSnapshotAttribute.class).a(RevokeGroup.class).a(RunInstances.class).a(ShowVersion.class).a(StartInstances.class).a(StopInstances.class).a(TerminateInstances.class).a(UnmonitorInstances.class).a(CreatePlacementGroup.class).a(DescribePlacementGroups.class).a(DeletePlacementGroup.class).a(CreateTags.class).a(DescribeTags.class).a(DeleteTags.class).a(ImportKeyPair.class).a(UploadDiskImage.class).a(DeleteDiskImage.class).a(CancelConversionTask.class).toList();
    private static final String[] windowsLines = new String[]{"@echo off", "", "setlocal", "", "REM Copyright 2006-2010 Amazon.com, Inc. or its affiliates.  All Rights Reserved.  Licensed under the", "REM Amazon Software License (the \"License\").  You may not use this file except in compliance with the License. A copy of the", "REM License is located at http://aws.amazon.com/asl or in the \"license\" file accompanying this file.  This file is distributed on an \"AS", "REM IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific", "REM language governing permissions and limitations under the License.", "", "REM Set intermediate env vars because the %VAR:x=y% notation below", "REM (which replaces the string x with the string y in VAR)", "REM doesn''t handle undefined environment variables. This way", "REM we''re always dealing with defined variables in those tests.", "set CHK_HOME=_%{1}%", "", "if \"%CHK_HOME:\"=%\" == \"_\" goto HOME_MISSING", "", "\"%{1}:\"=%\\bin\\ec2-cmd\" {0} %*", "goto DONE", ":HOME_MISSING", "echo {1} is not set", "exit /b 1", "", ":DONE"};
    private static final String[] bashLines = new String[]{"#!/usr/bin/env bash", "", "# Copyright 2006-2010 Amazon.com, Inc. or its affiliates.  All Rights Reserved.  Licensed under the", "# Amazon Software License (the \"License\").  You may not use this file except in compliance with the License. A copy of the", "# License is located at http://aws.amazon.com/asl or in the \"license\" file accompanying this file.  This file is distributed on an \"AS", "# IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific", "# language governing permissions and limitations under the License.", "", "__ZIP_PREFIX__{1}=$'{'{1}:?{1} is not set'}'", "__RPM_PREFIX__{1}=/usr/local/aes/cmdline", "${1}/bin/ec2-cmd {0} \"$@\""};
    private static final CmdHelper BASH_CMD_HELPER = new CmdHelper(){

        public String[] getLines() {
            return bashLines;
        }

        public String getNewline() {
            return "\n";
        }

        public String getFileName(File dir, String command) {
            return dir.getAbsolutePath() + "/" + command;
        }

        public void cmdPostProcess(File cmd) {
            try {
                Runtime.getRuntime().exec(new String[]{"/bin/chmod", "775", cmd.getAbsolutePath()});
            }
            catch (IOException e) {
                System.err.println("Error applying chmod to " + cmd.getAbsolutePath() + ": " + e.getMessage());
            }
        }
    };
    private static final CmdHelper WINDOWS_CMD_HELPER = new CmdHelper(){

        public String[] getLines() {
            return windowsLines;
        }

        public String getNewline() {
            return "\r\n";
        }

        public String getFileName(File dir, String command) {
            return dir.getAbsolutePath() + "/" + command + ".cmd";
        }

        public void cmdPostProcess(File cmd) {
        }
    };

    public static void gencmd(File dir, File linkDir, String linkTarget, String classname, String cmdname, CmdHelper cmdHelper) {
        File file;
        StringBuilder stringBuilder = new StringBuilder();
        String newline = cmdHelper.getNewline();
        for (String line : cmdHelper.getLines()) {
            stringBuilder.append(line).append(newline);
        }
        String output = MessageFormat.format(stringBuilder.toString(), classname, "EC2_HOME");
        Writer writer = null;
        try {
            file = new File(cmdHelper.getFileName(dir, cmdname));
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            writer.write(output);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating command", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
        cmdHelper.cmdPostProcess(file);
        if (linkDir != null) {
            try {
                Runtime.getRuntime().exec(new String[]{"/bin/ln", "-s", linkTarget + cmdname, new File(linkDir, cmdname).getAbsolutePath()});
            }
            catch (IOException e) {
                System.err.println("Error creating symlink for " + file.getAbsolutePath() + ": " + e.getMessage());
            }
        }
    }

    public static void gencmd(String path, String linkPath, String linkTarget, String platforn) throws Exception {
        CmdHelper cmdHelper;
        if ("windows".equalsIgnoreCase(platforn)) {
            cmdHelper = WINDOWS_CMD_HELPER;
        } else if ("unix".equalsIgnoreCase(platforn) || "bash".equalsIgnoreCase(platforn)) {
            cmdHelper = BASH_CMD_HELPER;
        } else {
            throw new RuntimeException("PLATFORM must be windows, bash, or unix (deprecated alias for bash), but was " + platforn);
        }
        File dir = GenerateCommandLineTool.ensureDirectory(path);
        File linkDir = "NONE".equalsIgnoreCase(linkPath) ? null : GenerateCommandLineTool.ensureDirectory(linkPath);
        for (Class<? extends BaseCmd> cmdClass : COMMANDS) {
            BaseCmd cmd = cmdClass.getConstructor(Class.forName("[Ljava.lang.String;")).newInstance(new Object[]{new String[0]});
            String name = cmdClass.getName();
            int i = name.lastIndexOf(46);
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            for (String cmdName : cmd.getNames()) {
                GenerateCommandLineTool.gencmd(dir, linkDir, linkTarget, name, cmdName, cmdHelper);
            }
        }
    }

    private static File ensureDirectory(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException(path + "' is not a directory.");
        }
        return dir;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4 || args.length % 4 != 0) {
            throw new RuntimeException("Usage: GenerateCommandLineTool OUT_PATH LINK_PATH LINK_TARGET PLATFORM [...]");
        }
        for (int i = 0; i < args.length; i += 4) {
            GenerateCommandLineTool.gencmd(args[i], args[i + 1], args[i + 2], args[i + 3]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListCreator<T> {
        private final List<T> list = new ArrayList<T>();

        public ListCreator<T> a(T value) {
            this.list.add(value);
            return this;
        }

        public List<T> toList() {
            return this.list;
        }
    }

    private static interface CmdHelper {
        public String getNewline();

        public String[] getLines();

        public String getFileName(File var1, String var2);

        public void cmdPostProcess(File var1);
    }
}

