
(define-library (srfi 160 mini-test)
  (import (scheme base)
          (srfi 160 base) (srfi 160 f8) (srfi 160 f16)
          (chibi test))
  (export run-tests)
  (begin
    (define (run-tests)
      (test-begin "srfi-160: half and quarter precision")

      (test-group "f8"
        (define f8v '#f8(0 1 2 3 4 5 6 7 8))
        (test '#f8(0 1 2 3 4) (f8vector 0 1 2 3 4))
        (test '#f8(0 1 2 3 4 5 6 7 8 9)
          (f8vector-unfold (lambda (i x) (values x (+ x 1))) 10 0.0))
        (test '#f8(0 1 2 3 4 5 6)
          (f8vector-unfold (lambda (i x) (values (inexact i) (+ x 1))) 7 0.0))
        (test f8v (f8vector-copy f8v))
        (test-assert (not (eqv? f8v (f8vector-copy f8v))))
        (test '#f8(6 7 8) (f8vector-copy f8v 6))
        (test '#f8(3 4 5) (f8vector-copy f8v 3 6))
        (test '#f8(4 3 1) (f8vector-reverse-copy (f8vector 1 3 4)))
        (test '#f8(1 2 3 4) (f8vector-reverse-copy '#f8(5 4 3 2 1 0) 1 5))
        (test '(#f8(#x01 #x02) #f8(#x03 #x04))
            (f8vector-segment #f8(1 2 3 4) 2))
        (test '#f8(0 1) (f8vector-append '#f8(0) '#f8(1)))
        (test '#f8(0 1 2 3) (f8vector-append '#f8(0) '#f8(1 2 3)))
        (test '#f8(0 1 2 3) (f8vector-concatenate '(#f8(0 1) #f8(2 3))))
        (test '#f8(0 1 6 7)
          (f8vector-append-subvectors '#f8(0 1 2 3 4) 0 2 '#f8(4 5 6 7 8) 2 4))
        (test '#f8(1 2)
          (vector->f8vector '#(0 1 2 3) 1 3))
        (test '#(1.0 2.0)
            (f8vector->vector '#f8(0 1 2 3) 1 3))
        ;; round trip accuracy
        (let ((v (make-f8vector 1)))
          (f8vector-set! v 0 +nan.0)
          (test "+nan.0" (number->string (f8vector-ref v 0)))
          (for-each
           (lambda (x)
             (f8vector-set! v 0 (car x))
             (test (cadr x) (f8vector-ref v 0))
             (f8vector-set! v 0 (- (car x)))
             (test (- (cadr x)) (f8vector-ref v 0))
             )
           '((0. 0.)
             (0.0001 0.0001068115234375)
             (#i1/3 0.3125)
             (0.5 0.5)
             (1. 1.)
             (7. 7.)
             (8. 8.)
             (9. 8.)
             (10. 10.)
             (45. 48.)
             (45000. 40960.)
             (999999.0 57344.0)
             (+inf.0 +inf.0)
             )))
        )

      (test-group "f16"
        (define f16v '#f16(0 1 2 3 4 5 6 7 8))
        (test '#f16(0 1 2 3 4) (f16vector 0 1 2 3 4))
        (test '#f16(0 1 2 3 4 5 6 7 8 9)
          (f16vector-unfold (lambda (i x) (values x (+ x 1))) 10 0.0))
        (test '#f16(0 1 2 3 4 5 6)
          (f16vector-unfold (lambda (i x) (values (inexact i) (+ x 1))) 7 0.0))
        (test f16v (f16vector-copy f16v))
        (test-assert (not (eqv? f16v (f16vector-copy f16v))))
        (test '#f16(6 7 8) (f16vector-copy f16v 6))
        (test '#f16(3 4 5) (f16vector-copy f16v 3 6))
        (test '#f16(4 3 1) (f16vector-reverse-copy (f16vector 1 3 4)))
        (test '#f16(1 2 3 4) (f16vector-reverse-copy '#f16(5 4 3 2 1 0) 1 5))
        (test '(#f16(#x01 #x02) #f16(#x03 #x04))
            (f16vector-segment #f16(1 2 3 4) 2))
        (test '#f16(0 1) (f16vector-append '#f16(0) '#f16(1)))
        (test '#f16(0 1 2 3) (f16vector-append '#f16(0) '#f16(1 2 3)))
        (test '#f16(0 1 2 3) (f16vector-concatenate '(#f16(0 1) #f16(2 3))))
        (test '#f16(0 1 6 7)
          (f16vector-append-subvectors '#f16(0 1 2 3 4) 0 2 '#f16(4 5 6 7 8) 2 4))
        (test '#f16(1 2)
          (vector->f16vector '#(0 1 2 3) 1 3))
        (test '#(1.0 2.0)
          (f16vector->vector '#f16(0 1 2 3) 1 3))
        )

      (test-end))))
