/*
 * Decompiled with CFR 0.152.
 */
package org.josql.contrib;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.general.PieDataset;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.QueryResults;
import org.josql.expressions.SelectItemExpression;
import org.josql.internal.Utilities;

public class JoSQLFreeChartPieDataset
extends Query
implements PieDataset {
    private Map values = new LinkedHashMap();
    private int key = 0;
    private int value = 0;
    private List listeners = new ArrayList();
    private DatasetGroup group = null;

    public void addChangeListener(DatasetChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(DatasetChangeListener l) {
        this.listeners.remove(l);
    }

    public DatasetGroup getGroup() {
        return this.group;
    }

    public void setGroup(DatasetGroup g) {
        this.group = g;
    }

    public void setKeyValue(int keyCol, int valueCol) throws IllegalArgumentException, IllegalStateException, QueryParseException {
        if (!this.parsed()) {
            throw new IllegalStateException("Cannot specify the key and value columns until a query has been specified and parsed.");
        }
        if (keyCol < 1) {
            throw new IllegalArgumentException("Key column index must be a minimum of 1.");
        }
        if (valueCol < 1) {
            throw new IllegalArgumentException("Value column index must be a minimum of 1.");
        }
        List cols = this.getColumns();
        if (keyCol > cols.size()) {
            throw new IllegalArgumentException("Key column index must be a minimum of " + cols.size() + ".");
        }
        if (valueCol > cols.size()) {
            throw new IllegalArgumentException("Value column index must be a minimum of " + cols.size() + ".");
        }
        SelectItemExpression vexp = (SelectItemExpression)cols.get(valueCol - 1);
        Class vc = vexp.getExpectedReturnType(this);
        if (!Utilities.isNumber(vc)) {
            throw new IllegalArgumentException("Value column: " + valueCol + " will evaluate to an instance of type: " + vc.getName() + ", but only columns that return numbers are allowed.");
        }
        this.key = keyCol;
        this.value = valueCol;
    }

    public QueryResults executeQuery(List l) throws QueryExecutionException {
        if (this.isWantObjects()) {
            throw new QueryExecutionException("Only SQL statements that return columns (not the objects passed in) can be used.");
        }
        if (this.key == 0 || this.value == 0) {
            throw new IllegalStateException("Key and/or value columns not specified.");
        }
        QueryResults qr = super.execute(l);
        List res = qr.getResults();
        LinkedHashMap nValues = new LinkedHashMap();
        for (int i = 0; i < res.size(); ++i) {
            List resR = (List)res.get(i);
            Object k = resR.get(this.key - 1);
            Object v = resR.get(this.value - 1);
            String kv = null + "";
            if (k == null) {
                nValues.put(kv, v);
            }
            if (k instanceof Comparable) {
                nValues.put((String)k, v);
                continue;
            }
            kv = k.toString();
            nValues.put(kv, v);
        }
        this.values = nValues;
        DatasetChangeEvent dce = new DatasetChangeEvent((Object)this, (Dataset)this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            DatasetChangeListener d = (DatasetChangeListener)this.listeners.get(i);
            d.datasetChanged(dce);
        }
        return qr;
    }

    public int getItemCount() {
        return this.values.size();
    }

    public Number getValue(int index) {
        int c = 0;
        Iterator iter = this.values.keySet().iterator();
        while (iter.hasNext()) {
            Object k = iter.next();
            if (index == c) {
                return (Number)this.values.get(k);
            }
            ++c;
        }
        return new Double(-1.0);
    }

    public int getIndex(Comparable k) {
        int c = 0;
        Iterator iter = this.values.keySet().iterator();
        while (iter.hasNext()) {
            Comparable ko = (Comparable)iter.next();
            if (ko.compareTo(k) == 0) {
                return c;
            }
            ++c;
        }
        return -1;
    }

    public Comparable getKey(int index) {
        int c = 0;
        Iterator iter = this.values.keySet().iterator();
        while (iter.hasNext()) {
            Object k = iter.next();
            if (index == c) {
                return (Comparable)k;
            }
            ++c;
        }
        return null;
    }

    public Number getValue(Comparable key) {
        return (Number)this.values.get(key);
    }

    public List getKeys() {
        return new ArrayList(this.values.keySet());
    }
}

