/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.net.Socket;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.ajp.AjpProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpProtocol
extends AbstractAjpProtocol<Socket> {
    private static final Log log = LogFactory.getLog(AjpProtocol.class);
    private AjpConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public AjpProtocol() {
        this.endpoint = new JIoEndpoint();
        this.endpoint.setAddress(JreCompat.getInstance().getLoopbackAddress());
        this.cHandler = new AjpConnectionHandler(this);
        ((JIoEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
    }

    @Override
    protected String getNamePrefix() {
        return "ajp-bio";
    }

    protected static class AjpConnectionHandler
    extends AbstractAjpProtocol.AbstractAjpConnectionHandler<Socket, AjpProcessor>
    implements JIoEndpoint.Handler {
        protected AjpProtocol proto;

        public AjpConnectionHandler(AjpProtocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol<Socket> getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return null;
        }

        @Override
        public void release(SocketWrapper<Socket> socket, Processor<Socket> processor, boolean isSocketClosing, boolean addToPoller) {
            processor.recycle(isSocketClosing);
            this.recycledProcessors.offer(processor);
        }

        @Override
        protected AjpProcessor createProcessor() {
            AjpProcessor processor = new AjpProcessor(this.proto.packetSize, (JIoEndpoint)this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setAjpFlush(this.proto.getAjpFlush());
            processor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            processor.setTomcatAuthorization(this.proto.getTomcatAuthorization());
            processor.setSecret(this.proto.getSecret());
            processor.setKeepAliveTimeout(this.proto.getKeepAliveTimeout());
            processor.setClientCertProvider(this.proto.getClientCertProvider());
            processor.setMaxCookieCount(this.proto.getMaxCookieCount());
            processor.setAllowedRequestAttributesPatternPattern(this.proto.getAllowedRequestAttributesPatternPattern());
            this.register(processor);
            return processor;
        }
    }
}

