/*
 * Decompiled with CFR 0.152.
 */
package free.jin.freechess;

import free.chess.Chess;
import free.chess.ChessMove;
import free.chess.ChessPiece;
import free.chess.ChesslikeGenericVariant;
import free.chess.Move;
import free.chess.Piece;
import free.chess.Player;
import free.chess.Position;
import free.chess.Square;
import free.chess.WildVariant;
import free.chess.variants.BothSidesCastlingVariant;
import free.chess.variants.NoCastlingVariant;
import free.chess.variants.atomic.Atomic;
import free.chess.variants.fischerrandom.FischerRandom;
import free.chess.variants.suicide.Suicide;
import free.freechess.DeltaBoardStruct;
import free.freechess.FreechessConnection;
import free.freechess.GameInfoStruct;
import free.freechess.Ivar;
import free.freechess.SeekInfoStruct;
import free.freechess.Style12Struct;
import free.jin.Connection;
import free.jin.Game;
import free.jin.I18n;
import free.jin.Jin;
import free.jin.PGNConnection;
import free.jin.Seek;
import free.jin.SeekConnection;
import free.jin.UserSeek;
import free.jin.event.BoardFlipEvent;
import free.jin.event.ChatEvent;
import free.jin.event.ClockAdjustmentEvent;
import free.jin.event.GameEndEvent;
import free.jin.event.GameEvent;
import free.jin.event.GameStartEvent;
import free.jin.event.IllegalMoveEvent;
import free.jin.event.ListenerManager;
import free.jin.event.MoveMadeEvent;
import free.jin.event.OfferEvent;
import free.jin.event.PlainTextEvent;
import free.jin.event.PositionChangedEvent;
import free.jin.event.SeekEvent;
import free.jin.event.SeekListener;
import free.jin.event.SeekListenerManager;
import free.jin.event.TakebackEvent;
import free.jin.freechess.FreechessListenerManager;
import free.jin.freechess.NoSuchGameException;
import free.jin.freechess.event.IvarStateChangeEvent;
import free.util.Pair;
import free.util.TextUtilities;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class JinFreechessConnection
extends FreechessConnection
implements Connection,
SeekConnection,
PGNConnection {
    private final FreechessListenerManager listenerManager = new FreechessListenerManager(this);
    private static final Pattern TOURNEY_TELL_REGEX = Pattern.compile("^([A-z]{3,17})(\\([A-Z\\*\\(\\)]*\\))?\\(T(\\d+)\\): (.*)");
    private static WildVariant[] wildVariants;
    private final Hashtable unstartedGamesData = new Hashtable(1);
    private final Hashtable ongoingGamesData = new Hashtable(5);
    private final Hashtable unechoedMoves = new Hashtable(1);
    private final Vector unsupportedGames = new Vector();
    private int primaryPlayedGame = -1;
    private int primaryObservedGame = -1;
    private final Hashtable seeks = new Hashtable();
    private final Hashtable offerIndicesToGameData = new Hashtable();

    public JinFreechessConnection(String string, String string2) {
        super(string, string2, System.out);
        this.setInterface(Jin.getInstance().getAppName() + " " + Jin.getInstance().getAppVersion() + " (" + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + ", " + System.getProperty("os.name") + " " + JinFreechessConnection.getSafeOSVersion() + ")");
        this.setStyle(12);
        this.setIvarState(Ivar.GAMEINFO, true);
        this.setIvarState(Ivar.SHOWOWNSEEK, true);
        this.setIvarState(Ivar.PENDINFO, true);
        this.setIvarState(Ivar.MOVECASE, true);
        this.setIvarState(Ivar.LOCK, true);
    }

    private static String getSafeOSVersion() {
        String string = System.getProperty("os.version");
        int n = string.indexOf(".", string.indexOf(".") + 1);
        if (n != -1) {
            string = string.substring(0, n) + ".x";
        }
        return string;
    }

    public static Player playerForString(String string) {
        if (string.equals("B")) {
            return Player.BLACK_PLAYER;
        }
        if (string.equals("W")) {
            return Player.WHITE_PLAYER;
        }
        throw new IllegalArgumentException("Bad player string: " + string);
    }

    public ListenerManager getListenerManager() {
        return this.getFreechessListenerManager();
    }

    public FreechessListenerManager getFreechessListenerManager() {
        return this.listenerManager;
    }

    public void initiateConnectAndLogin(String string, int n) {
        this.listenerManager.fireConnectionAttempted(this, string, n);
        this.initiateConnect(string, n);
    }

    protected void handleConnected() {
        this.listenerManager.fireConnectionEstablished(this);
        super.handleConnected();
    }

    protected void handleConnectingFailed(IOException iOException) {
        this.listenerManager.fireConnectingFailed(this, iOException.getMessage());
        super.handleConnectingFailed(iOException);
    }

    protected void handleLoginSucceeded() {
        super.handleLoginSucceeded();
        this.sendCommand("$set bell 0");
        this.filterLine("Bell off.");
        this.listenerManager.fireLoginSucceeded(this);
    }

    protected void handleLoginFailed(String string) {
        this.listenerManager.fireLoginFailed(this, string);
        super.handleLoginFailed(string);
    }

    protected void handleDisconnection(IOException iOException) {
        this.listenerManager.fireConnectionLost(this);
        super.handleDisconnection(iOException);
    }

    protected Socket connectImpl(String string, int n) throws IOException {
        Socket socket = null;
        try {
            Class<?> clazz = Class.forName("free.freechess.timeseal.TimesealingSocket");
            Constructor<?> constructor = clazz.getConstructor(String.class, Integer.TYPE);
            socket = (Socket)constructor.newInstance(string, new Integer(n));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            invocationTargetException.printStackTrace();
        }
        if (socket == null) {
            socket = new Socket(string, n);
        }
        return socket;
    }

    protected void processLine(String string) {
        this.listenerManager.firePlainTextEvent(new PlainTextEvent((Connection)this, string));
    }

    protected boolean processIvarStateChanged(Ivar ivar, boolean bl) {
        IvarStateChangeEvent ivarStateChangeEvent = new IvarStateChangeEvent(this, ivar, bl);
        this.listenerManager.fireIvarStateChangeEvent(ivarStateChangeEvent);
        return false;
    }

    protected boolean processPersonalTell(String string, String string2, String string3) {
        this.listenerManager.fireChatEvent(new ChatEvent((Connection)this, "tell", 0, string, string2 == null ? "" : string2, -1, string3, null));
        return true;
    }

    protected boolean processSayTell(String string, String string2, int n, String string3) {
        this.listenerManager.fireChatEvent(new ChatEvent((Connection)this, "say", 0, string, string2 == null ? "" : string2, -1, string3, (Object)new Integer(n)));
        return true;
    }

    protected boolean processPTell(String string, String string2, String string3) {
        this.listenerManager.fireChatEvent(new ChatEvent((Connection)this, "ptell", 0, string, string2 == null ? "" : string2, -1, string3, null));
        return true;
    }

    protected boolean processChannelTell(String string, String string2, int n, String string3) {
        this.listenerManager.fireChatEvent(new ChatEvent((Connection)this, "channel-tell", 3, string, string2 == null ? "" : string2, -1, string3, (Object)new Integer(n)));
        return true;
    }

    protected boolean processKibitz(String string, String string2, int n, int n2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        this.listenerManager.fireChatEvent(new ChatEvent((Connection)this, "kibitz", 1, string, string2, n, string3, (Object)new Integer(n2)));
        return true;
    }

    protected boolean processWhisper(String string, String string2, int n, int n2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        this.listenerManager.fireChatEvent(new ChatEvent((Connection)this, "whisper", 1, string, string2, n, string3, (Object)new Integer(n2)));
        return true;
    }

    protected boolean processQTell(String string) {
        ChatEvent chatEvent;
        Matcher matcher = TOURNEY_TELL_REGEX.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            if (string3 == null) {
                string3 = "";
            }
            Integer n = new Integer(matcher.group(3));
            string = matcher.group(4);
            chatEvent = new ChatEvent((Connection)this, "qtell.tourney", 4, string2, string3, -1, string, (Object)n);
        } else {
            chatEvent = new ChatEvent((Connection)this, "qtell", 0, null, null, -1, string, null);
        }
        this.listenerManager.fireChatEvent(chatEvent);
        return true;
    }

    protected boolean processShout(String string, String string2, String string3) {
        this.listenerManager.fireChatEvent(new ChatEvent((Connection)this, "shout", 3, string, string2 == null ? "" : string2, -1, string3, null));
        return true;
    }

    protected boolean processIShout(String string, String string2, String string3) {
        this.listenerManager.fireChatEvent(new ChatEvent((Connection)this, "ishout", 3, string, string2 == null ? "" : string2, -1, string3, null));
        return true;
    }

    protected boolean processTShout(String string, String string2, String string3) {
        this.listenerManager.fireChatEvent(new ChatEvent((Connection)this, "tshout", 4, string, string2 == null ? "" : string2, -1, string3, null));
        return true;
    }

    protected boolean processCShout(String string, String string2, String string3) {
        this.listenerManager.fireChatEvent(new ChatEvent((Connection)this, "cshout", 3, string, string2 == null ? "" : string2, -1, string3, null));
        return true;
    }

    protected boolean processAnnouncement(String string, String string2) {
        this.listenerManager.fireChatEvent(new ChatEvent((Connection)this, "announcement", 2, string, "", -1, string2, null));
        return true;
    }

    private static WildVariant getVariant(String string) {
        if (string.equalsIgnoreCase("lightning") || string.equalsIgnoreCase("blitz") || string.equalsIgnoreCase("standard") || string.equalsIgnoreCase("untimed")) {
            return Chess.getInstance();
        }
        if (string.startsWith("wild/")) {
            String string2 = string.substring("wild/".length());
            if (string2.equals("0") || string2.equals("1")) {
                return new BothSidesCastlingVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", string);
            }
            if (string2.equals("2") || string2.equals("3")) {
                return new NoCastlingVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", string);
            }
            if (string2.equals("5") || string2.equals("8") || string2.equals("8a")) {
                return new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", string);
            }
            if (string2.equals("fr")) {
                return FischerRandom.getInstance();
            }
        } else {
            if (string.equals("suicide")) {
                return Suicide.getInstance();
            }
            if (string.equals("losers")) {
                return new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", string);
            }
            if (string.equals("atomic")) {
                return Atomic.getInstance();
            }
            if (string.equals("Unknown variant")) {
                return Chess.getInstance();
            }
        }
        return null;
    }

    private String getWildName(WildVariant wildVariant) {
        if (wildVariant == null) {
            throw new IllegalArgumentException("Null variant");
        }
        String string = wildVariant.getName();
        if (string.startsWith("wild/")) {
            return "w" + string.substring("wild/".length());
        }
        if (wildVariant.equals(Chess.getInstance())) {
            return "";
        }
        if (wildVariant.equals(FischerRandom.getInstance())) {
            return "fr";
        }
        if (wildVariant.equals(Suicide.getInstance())) {
            return "suicide";
        }
        if (wildVariant.equals(Atomic.getInstance())) {
            return "atomic";
        }
        if ("losers".equals(string)) {
            return "losers";
        }
        return null;
    }

    public WildVariant[] getSupportedVariants() {
        if (wildVariants == null) {
            wildVariants = new WildVariant[]{Chess.getInstance(), FischerRandom.getInstance(), Suicide.getInstance(), Atomic.getInstance(), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "losers"), new BothSidesCastlingVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "wild/0"), new BothSidesCastlingVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "wild/1"), new NoCastlingVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "wild/2"), new NoCastlingVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "wild/3"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "wild/5"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "wild/8"), new ChesslikeGenericVariant("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "wild/8a")};
        }
        return (WildVariant[])wildVariants.clone();
    }

    public Game getGame(int n) throws NoSuchGameException {
        return this.getGameData((int)n).game;
    }

    private InternalGameData getGameData(int n) throws NoSuchGameException {
        InternalGameData internalGameData = (InternalGameData)this.ongoingGamesData.get(new Integer(n));
        if (internalGameData == null) {
            throw new NoSuchGameException();
        }
        return internalGameData;
    }

    private InternalGameData findMyGame() throws NoSuchGameException {
        if (this.primaryPlayedGame != -1) {
            return this.getGameData(this.primaryPlayedGame);
        }
        Enumeration enumeration = this.ongoingGamesData.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            InternalGameData internalGameData = (InternalGameData)this.ongoingGamesData.get(n);
            Game game = internalGameData.game;
            if (game.getGameType() != 1) continue;
            return internalGameData;
        }
        throw new NoSuchGameException();
    }

    private InternalGameData findMyGameAgainst(String string) throws NoSuchGameException {
        Enumeration enumeration = this.ongoingGamesData.keys();
        while (enumeration.hasMoreElements()) {
            Player player;
            Integer n = (Integer)enumeration.nextElement();
            InternalGameData internalGameData = (InternalGameData)this.ongoingGamesData.get(n);
            Game game = internalGameData.game;
            Player player2 = game.getUserPlayer();
            if (player2 == null || (!(player = player2.getOpponent()).isWhite() || !game.getWhiteName().equals(string)) && (!player.isBlack() || !game.getBlackName().equals(string))) continue;
            return internalGameData;
        }
        throw new NoSuchGameException();
    }

    protected boolean processGameInfo(GameInfoStruct gameInfoStruct) {
        this.unstartedGamesData.put(new Integer(gameInfoStruct.getGameNumber()), gameInfoStruct);
        return true;
    }

    protected boolean processStyle12(Style12Struct style12Struct) {
        Integer n = new Integer(style12Struct.getGameNumber());
        InternalGameData internalGameData = (InternalGameData)this.ongoingGamesData.get(n);
        GameInfoStruct gameInfoStruct = (GameInfoStruct)((Object)this.unstartedGamesData.remove(n));
        if (gameInfoStruct != null) {
            internalGameData = this.startGame(gameInfoStruct, style12Struct);
        } else if (internalGameData != null) {
            Style12Struct style12Struct2 = internalGameData.boardData;
            int n2 = style12Struct.getPlayedPlyCount() - style12Struct2.getPlayedPlyCount();
            if (n2 < 0) {
                this.tryIssueTakeback(internalGameData, style12Struct);
            } else if (n2 == 0) {
                if (!style12Struct2.getBoardFEN().equals(style12Struct.getBoardFEN())) {
                    this.changePosition(internalGameData, style12Struct);
                }
            } else if (n2 == 1) {
                if (style12Struct.getMoveVerbose() != null) {
                    this.makeMove(internalGameData, style12Struct);
                } else {
                    this.changePosition(internalGameData, style12Struct);
                }
            } else if (n2 > 1) {
                this.changePosition(internalGameData, style12Struct);
            }
        } else if (!this.unsupportedGames.contains(n)) {
            GameInfoStruct gameInfoStruct2 = new GameInfoStruct(style12Struct.getGameNumber(), false, "Unknown variant", false, false, false, style12Struct.getInitialTime(), style12Struct.getIncrement(), style12Struct.getInitialTime(), style12Struct.getIncrement(), 0, -1, ' ', -1, ' ', false, false);
            internalGameData = this.startGame(gameInfoStruct2, style12Struct);
        }
        if (internalGameData != null) {
            this.updateGame(internalGameData, style12Struct);
        }
        return true;
    }

    protected boolean processDeltaBoard(DeltaBoardStruct deltaBoardStruct) {
        Integer n = new Integer(deltaBoardStruct.getGameNumber());
        InternalGameData internalGameData = (InternalGameData)this.ongoingGamesData.get(n);
        Game game = internalGameData.game;
        if (game.getVariant() != Chess.getInstance()) {
            throw new IllegalStateException("delta-boards should only be sent for regular chess");
        }
        Style12Struct style12Struct = internalGameData.boardData;
        Vector vector = internalGameData.moveList;
        Position position = game.getInitialPosition();
        for (int i = 0; i < vector.size(); ++i) {
            position.makeMove((Move)vector.elementAt(i));
        }
        ChessMove chessMove = (ChessMove)Move.parseWarrenSmith((String)deltaBoardStruct.getMoveSmith(), (Position)position, (String)deltaBoardStruct.getMoveAlgebraic());
        Square square = chessMove.getStartingSquare();
        ChessPiece chessPiece = (ChessPiece)(square == null ? null : position.getPieceAt(square));
        position.makeMove((Move)chessMove);
        String string = position.getLexigraphic();
        String string2 = position.getCurrentPlayer().isWhite() ? "W" : "B";
        int n2 = chessMove.getDoublePawnPushFile();
        boolean bl = chessPiece.isKing();
        boolean bl2 = style12Struct.canWhiteCastleKingside() && !bl && !Square.getInstance((int)7, (int)0).equals(square);
        boolean bl3 = style12Struct.canBlackCastleQueenside() && !bl && !Square.getInstance((int)0, (int)0).equals(square);
        boolean bl4 = style12Struct.canBlackCastleKingside() && !bl && !Square.getInstance((int)7, (int)7).equals(square);
        boolean bl5 = style12Struct.canBlackCastleQueenside() && !bl && !Square.getInstance((int)0, (int)7).equals(square);
        boolean bl6 = chessPiece.isPawn() || chessMove.isCapture() || bl2 != style12Struct.canWhiteCastleKingside() || bl3 != style12Struct.canWhiteCastleQueenside() || bl4 != style12Struct.canBlackCastleKingside() || bl5 != style12Struct.canBlackCastleQueenside();
        int n3 = bl6 ? 0 : style12Struct.getPliesSinceIrreversible() + 1;
        String string3 = style12Struct.getWhiteName();
        String string4 = style12Struct.getBlackName();
        int n4 = style12Struct.getGameType();
        boolean bl7 = style12Struct.isPlayedGame();
        boolean bl8 = position.getCurrentPlayer() == game.getUserPlayer();
        int n5 = style12Struct.getInitialTime();
        int n6 = style12Struct.getIncrement();
        int n7 = JinFreechessConnection.calcStrength(position, Player.WHITE_PLAYER);
        int n8 = JinFreechessConnection.calcStrength(position, Player.BLACK_PLAYER);
        int n9 = position.getCurrentPlayer().isBlack() ? deltaBoardStruct.getRemainingTime() : style12Struct.getWhiteTime();
        int n10 = position.getCurrentPlayer().isWhite() ? deltaBoardStruct.getRemainingTime() : style12Struct.getBlackTime();
        int n11 = style12Struct.getNextMoveNumber() + (position.getCurrentPlayer().isWhite() ? 1 : 0);
        String string5 = JinFreechessConnection.createVerboseMove(position, chessMove);
        String string6 = deltaBoardStruct.getMoveAlgebraic();
        int n12 = deltaBoardStruct.getTakenTime();
        boolean bl9 = style12Struct.isBoardFlipped();
        boolean bl10 = true;
        int n13 = 0;
        Style12Struct style12Struct2 = new Style12Struct(string, string2, n2, bl2, bl3, bl4, bl5, n3, n, string3, string4, n4, bl7, bl8, n5, n6, n7, n8, n9, n10, n11, string5, string6, n12, bl9, bl10, n13);
        this.processStyle12(style12Struct2);
        return true;
    }

    private static int calcStrength(Position position, Player player) {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                ChessPiece chessPiece = (ChessPiece)position.getPieceAt(i, j);
                if (chessPiece == null || chessPiece.getPlayer() != player) continue;
                if (chessPiece.isPawn()) {
                    ++n;
                    continue;
                }
                if (chessPiece.isBishop()) {
                    n += 3;
                    continue;
                }
                if (chessPiece.isKnight()) {
                    n += 3;
                    continue;
                }
                if (chessPiece.isRook()) {
                    n += 5;
                    continue;
                }
                if (chessPiece.isQueen()) {
                    n += 9;
                    continue;
                }
                if (!chessPiece.isKing()) continue;
                n += 0;
            }
        }
        return n;
    }

    private static String createVerboseMove(Position position, ChessMove chessMove) {
        if (chessMove.isShortCastling()) {
            return "o-o";
        }
        if (chessMove.isLongCastling()) {
            return "o-o-o";
        }
        ChessPiece chessPiece = (ChessPiece)position.getPieceAt(chessMove.getEndingSquare());
        String string = chessPiece.toShortString() + "/" + chessMove.getStartingSquare() + "-" + chessMove.getEndingSquare();
        if (chessMove.isPromotion()) {
            return string + "=" + chessMove.getPromotionTarget().toShortString();
        }
        return string;
    }

    protected boolean processBSetupMode(boolean bl) {
        try {
            this.findMyGame().isBSetup = bl;
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
        return super.processBSetupMode(bl);
    }

    protected boolean processSimulCurrentBoardChanged(int n, String string) {
        this.primaryPlayedGame = n;
        return true;
    }

    protected boolean processPrimaryGameChanged(int n) {
        this.primaryObservedGame = n;
        return true;
    }

    protected boolean processGameEnd(int n, String string, String string2, String string3, String string4) {
        int n2 = "1-0".equals(string4) ? 1 : ("0-1".equals(string4) ? 2 : ("1/2-1/2".equals(string4) ? 3 : 4));
        this.closeGame(n, n2);
        return false;
    }

    protected boolean processStoppedObserving(int n) {
        this.closeGame(n, 4);
        return false;
    }

    protected boolean processStoppedExamining(int n) {
        this.closeGame(n, 4);
        return false;
    }

    protected boolean processIllegalMove(String string, String string2) {
        this.illegalMoveAttempted(string);
        return false;
    }

    protected void warnVariantUnsupported(String string) {
        Object[] objectArray = new Object[]{string};
        String string2 = I18n.get((Class)JinFreechessConnection.class).getFormattedString("unsupportedVariantMessage", objectArray);
        String[] stringArray = string2.split("\n");
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= n) continue;
            n = stringArray[i].length();
        }
        String string3 = TextUtilities.padStart((String)"", (char)'*', (int)(n + 4));
        this.processLine(string3);
        for (int i = 0; i < stringArray.length; ++i) {
            this.processLine("* " + TextUtilities.padEnd((String)stringArray[i], (char)' ', (int)n) + " *");
        }
        this.processLine(string3);
    }

    private InternalGameData startGame(GameInfoStruct gameInfoStruct, Style12Struct style12Struct) {
        int n;
        String string = gameInfoStruct.getGameCategory();
        WildVariant wildVariant = JinFreechessConnection.getVariant(string);
        if (wildVariant == null) {
            this.warnVariantUnsupported(string);
            this.unsupportedGames.addElement(new Integer(gameInfoStruct.getGameNumber()));
            return null;
        }
        switch (style12Struct.getGameType()) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad game type value: " + style12Struct.getGameType());
            }
        }
        Position position = new Position(wildVariant);
        position.setFEN(style12Struct.getBoardFEN());
        String string2 = style12Struct.getWhiteName();
        String string3 = style12Struct.getBlackName();
        int n2 = 1000 * gameInfoStruct.getWhiteTime();
        int n3 = 1000 * gameInfoStruct.getBlackTime();
        int n4 = 1000 * gameInfoStruct.getWhiteInc();
        int n5 = 1000 * gameInfoStruct.getBlackInc();
        int n6 = gameInfoStruct.isWhiteRegistered() ? -1 : gameInfoStruct.getWhiteRating();
        int n7 = gameInfoStruct.isBlackRegistered() ? -1 : gameInfoStruct.getBlackRating();
        String string4 = String.valueOf(gameInfoStruct.getGameNumber());
        boolean bl = gameInfoStruct.isGameRated();
        boolean bl2 = style12Struct.isPlayedGame();
        String string5 = "";
        String string6 = "";
        boolean bl3 = style12Struct.isBoardFlipped();
        Player player = JinFreechessConnection.playerForString(style12Struct.getCurrentPlayer());
        Player player2 = null;
        if (n == 1 && bl2) {
            player2 = style12Struct.isMyTurn() ? player : player.getOpponent();
        }
        Game game = new Game(n, position, style12Struct.getPlayedPlyCount(), string2, string3, n2, n4, n3, n5, n6, n7, (Object)string4, string, bl, bl2, string5, string6, bl3, player2);
        InternalGameData internalGameData = new InternalGameData(game);
        this.ongoingGamesData.put(new Integer(gameInfoStruct.getGameNumber()), internalGameData);
        this.listenerManager.fireGameEvent((GameEvent)new GameStartEvent((Connection)this, game));
        if (n == 1) {
            this.removeAllSeeks();
        }
        return internalGameData;
    }

    private void updateGame(InternalGameData internalGameData, Style12Struct style12Struct) {
        Game game = internalGameData.game;
        Style12Struct style12Struct2 = internalGameData.boardData;
        this.updateClocks(internalGameData, style12Struct);
        if (style12Struct2 != null && style12Struct2.isBoardFlipped() != style12Struct.isBoardFlipped()) {
            this.flipBoard(internalGameData, style12Struct);
        }
        game.setWhiteName(style12Struct.getWhiteName());
        game.setBlackName(style12Struct.getBlackName());
        game.setWhiteTime(1000 * style12Struct.getInitialTime());
        game.setWhiteInc(1000 * style12Struct.getIncrement());
        game.setBlackTime(1000 * style12Struct.getInitialTime());
        game.setBlackInc(1000 * style12Struct.getIncrement());
        internalGameData.boardData = style12Struct;
    }

    private void makeMove(InternalGameData internalGameData, Style12Struct style12Struct) {
        Object object;
        Move move;
        Game game = internalGameData.game;
        Style12Struct style12Struct2 = internalGameData.boardData;
        String string = style12Struct.getMoveVerbose();
        String string2 = style12Struct.getMoveSAN();
        WildVariant wildVariant = game.getVariant();
        Position position = new Position(wildVariant);
        position.setLexigraphic(style12Struct2.getBoardLexigraphic());
        Player player = JinFreechessConnection.playerForString(style12Struct2.getCurrentPlayer());
        position.setCurrentPlayer(player);
        Piece piece = null;
        if (string.equals("o-o")) {
            move = wildVariant.createShortCastling(position);
        } else if (string.equals("o-o-o")) {
            move = wildVariant.createLongCastling(position);
        } else {
            Square square = Square.parseSquare((String)string.substring(2, 4));
            Square square2 = Square.parseSquare((String)string.substring(5, 7));
            int n = string.indexOf("=") + 1;
            if (n != 0) {
                object = string.substring(n, n + 1);
                if (player.isBlack()) {
                    object = ((String)object).toLowerCase();
                }
                piece = wildVariant.parsePiece((String)object);
            }
            move = wildVariant.createMove(position, square, square2, piece, string2);
        }
        this.listenerManager.fireGameEvent((GameEvent)new MoveMadeEvent((Connection)this, game, move, true));
        Vector vector = (Vector)this.unechoedMoves.get(game);
        if (vector != null && vector.size() != 0 && JinFreechessConnection.isSameMove(game, move, (Move)(object = (Move)vector.elementAt(0)))) {
            vector.removeElementAt(0);
        }
        internalGameData.addMove(move);
    }

    private static boolean isSameMove(Game game, Move move, Move move2) {
        try {
            String string = JinFreechessConnection.moveToString(game, move);
            String string2 = JinFreechessConnection.moveToString(game, move2);
            return string.equals(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private void updateClocks(InternalGameData internalGameData, Style12Struct style12Struct) {
        Game game = internalGameData.game;
        int n = style12Struct.getWhiteTime();
        int n2 = style12Struct.getBlackTime();
        Player player = JinFreechessConnection.playerForString(style12Struct.getCurrentPlayer());
        boolean bl = game.getGameType() == 3;
        boolean bl2 = !bl && style12Struct.isClockRunning() && player.isWhite();
        boolean bl3 = !bl && style12Struct.isClockRunning() && player.isBlack();
        this.listenerManager.fireGameEvent((GameEvent)new ClockAdjustmentEvent((Connection)this, game, Player.WHITE_PLAYER, n, bl2));
        this.listenerManager.fireGameEvent((GameEvent)new ClockAdjustmentEvent((Connection)this, game, Player.BLACK_PLAYER, n2, bl3));
    }

    private void closeGame(int n, int n2) {
        Integer n3 = new Integer(n);
        if (n3 == this.primaryPlayedGame) {
            this.primaryPlayedGame = -1;
        } else if (n3 == this.primaryObservedGame) {
            this.primaryObservedGame = -1;
        }
        InternalGameData internalGameData = (InternalGameData)this.ongoingGamesData.remove(n3);
        if (internalGameData != null) {
            Game game = internalGameData.game;
            game.setResult(n2);
            this.listenerManager.fireGameEvent((GameEvent)new GameEndEvent((Connection)this, game, n2));
            if (game.getGameType() == 1 && this.getIvarState(Ivar.SEEKINFO)) {
                this.setIvarState(Ivar.SEEKINFO, true);
            }
        } else {
            this.unsupportedGames.removeElement(n3);
        }
    }

    private void flipBoard(InternalGameData internalGameData, Style12Struct style12Struct) {
        this.listenerManager.fireGameEvent((GameEvent)new BoardFlipEvent((Connection)this, internalGameData.game, style12Struct.isBoardFlipped()));
    }

    private void illegalMoveAttempted(String string) {
        try {
            InternalGameData internalGameData = this.findMyGame();
            Game game = internalGameData.game;
            Vector vector = (Vector)this.unechoedMoves.get(game);
            if (vector == null || vector.size() == 0) {
                return;
            }
            Move move = (Move)vector.elementAt(0);
            if (string == null || JinFreechessConnection.moveToString(game, move).equals(string)) {
                vector.removeAllElements();
                this.listenerManager.fireGameEvent((GameEvent)new IllegalMoveEvent((Connection)this, game, move));
            }
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    private void tryIssueTakeback(InternalGameData internalGameData, Style12Struct style12Struct) {
        Style12Struct style12Struct2 = internalGameData.boardData;
        int n = style12Struct2.getPlayedPlyCount() - style12Struct.getPlayedPlyCount();
        if (internalGameData.getMoveCount() < n) {
            this.changePosition(internalGameData, style12Struct);
        } else if (internalGameData.isBSetup) {
            this.changePosition(internalGameData, style12Struct);
        } else {
            Game game = internalGameData.game;
            Vector vector = internalGameData.moveList;
            Position position = game.getInitialPosition();
            for (int i = 0; i < vector.size() - n; ++i) {
                Move move = (Move)vector.elementAt(i);
                position.makeMove(move);
            }
            Position position2 = game.getInitialPosition();
            position2.setFEN(style12Struct.getBoardFEN());
            if (position2.equals(position)) {
                this.issueTakeback(internalGameData, style12Struct);
            } else {
                this.changePosition(internalGameData, style12Struct);
            }
        }
    }

    private void issueTakeback(InternalGameData internalGameData, Style12Struct style12Struct) {
        Style12Struct style12Struct2 = internalGameData.boardData;
        int n = style12Struct2.getPlayedPlyCount() - style12Struct.getPlayedPlyCount();
        this.listenerManager.fireGameEvent((GameEvent)new TakebackEvent((Connection)this, internalGameData.game, n));
        internalGameData.removeLastMoves(n);
    }

    private void changePosition(InternalGameData internalGameData, Style12Struct style12Struct) {
        Vector vector;
        Game game = internalGameData.game;
        Position position = game.getInitialPosition();
        position.setFEN(style12Struct.getBoardFEN());
        game.setInitialPosition(position);
        game.setPliesSinceStart(style12Struct.getPlayedPlyCount());
        this.listenerManager.fireGameEvent((GameEvent)new PositionChangedEvent((Connection)this, game, position));
        internalGameData.clearMoves();
        if (internalGameData.isBSetup && (vector = (Vector)this.unechoedMoves.get(game)) != null && vector.size() != 0) {
            vector.removeElementAt(0);
        }
    }

    public SeekListenerManager getSeekListenerManager() {
        return this.getFreechessListenerManager();
    }

    protected boolean processSeekAdded(SeekInfoStruct seekInfoStruct) {
        WildVariant wildVariant;
        if (this.getRequestedIvarState(Ivar.SEEKINFO) && (wildVariant = JinFreechessConnection.getVariant(seekInfoStruct.getMatchType())) != null) {
            Player player;
            String string = String.valueOf(seekInfoStruct.getSeekIndex());
            StringBuffer stringBuffer = new StringBuffer();
            int n = seekInfoStruct.getSeekerTitles();
            if ((n & 2) != 0) {
                stringBuffer.append("(C)");
            }
            if ((n & 4) != 0) {
                stringBuffer.append("(GM)");
            }
            if ((n & 8) != 0) {
                stringBuffer.append("(IM)");
            }
            if ((n & 0x10) != 0) {
                stringBuffer.append("(FM)");
            }
            if ((n & 0x20) != 0) {
                stringBuffer.append("(WGM)");
            }
            if ((n & 0x40) != 0) {
                stringBuffer.append("(WIM)");
            }
            if ((n & 0x80) != 0) {
                stringBuffer.append("(WFM)");
            }
            boolean bl = seekInfoStruct.getSeekerProvShow() == 'P';
            boolean bl2 = seekInfoStruct.getSeekerRating() != 0;
            boolean bl3 = (seekInfoStruct.getSeekerTitles() & 1) == 0;
            boolean bl4 = (seekInfoStruct.getSeekerTitles() & 2) != 0;
            switch (seekInfoStruct.getSeekerColor()) {
                case 'W': {
                    player = Player.WHITE_PLAYER;
                    break;
                }
                case 'B': {
                    player = Player.BLACK_PLAYER;
                    break;
                }
                case '?': {
                    player = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("Bad desired color char: " + seekInfoStruct.getSeekerColor());
                }
            }
            boolean bl5 = seekInfoStruct.getOpponentMinRating() > 0 || seekInfoStruct.getOpponentMaxRating() < 9999;
            Seek seek = new Seek(string, seekInfoStruct.getSeekerHandle(), stringBuffer.toString(), seekInfoStruct.getSeekerRating(), bl, bl3, bl2, bl4, wildVariant, seekInfoStruct.getMatchType(), seekInfoStruct.getMatchTime() * 60 * 1000, seekInfoStruct.getMatchIncrement() * 1000, seekInfoStruct.isMatchRated(), player, bl5, seekInfoStruct.getOpponentMinRating(), seekInfoStruct.getOpponentMaxRating(), !seekInfoStruct.isAutomaticAccept(), seekInfoStruct.isFormulaUsed());
            Integer n2 = new Integer(seekInfoStruct.getSeekIndex());
            Seek seek2 = (Seek)this.seeks.get(n2);
            if (seek2 != null) {
                this.listenerManager.fireSeekEvent(new SeekEvent((SeekConnection)this, 2, seek2));
            }
            this.seeks.put(n2, seek);
            this.listenerManager.fireSeekEvent(new SeekEvent((SeekConnection)this, 1, seek));
        }
        return true;
    }

    protected boolean processSeeksRemoved(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            Integer n = new Integer(nArray[i]);
            Seek seek = (Seek)this.seeks.get(n);
            if (seek == null) continue;
            this.listenerManager.fireSeekEvent(new SeekEvent((SeekConnection)this, 2, seek));
            this.seeks.remove(n);
        }
        return true;
    }

    protected boolean processSeeksCleared() {
        this.removeAllSeeks();
        return true;
    }

    private void removeAllSeeks() {
        int n = this.seeks.size();
        if (n != 0) {
            int n2;
            Object[] objectArray = new Object[n];
            Enumeration enumeration = this.seeks.keys();
            for (n2 = 0; n2 < n; ++n2) {
                objectArray[n2] = enumeration.nextElement();
            }
            for (n2 = 0; n2 < n; ++n2) {
                Object object = objectArray[n2];
                Seek seek = (Seek)this.seeks.get(object);
                this.listenerManager.fireSeekEvent(new SeekEvent((SeekConnection)this, 2, seek));
                this.seeks.remove(object);
            }
        }
    }

    void notFirstListenerAdded(SeekListener seekListener) {
        Enumeration enumeration = this.seeks.elements();
        while (enumeration.hasMoreElements()) {
            Seek seek = (Seek)enumeration.nextElement();
            SeekEvent seekEvent = new SeekEvent((SeekConnection)this, 1, seek);
            seekListener.seekAdded(seekEvent);
        }
    }

    void lastSeekListenerRemoved() {
        this.seeks.clear();
    }

    protected boolean processOffer(boolean bl, String string, int n, String string2, String string3) {
        super.processOffer(bl, string, n, string2, string3);
        return true;
    }

    protected boolean processMatchOffered(boolean bl, int n, String string, String string2) {
        super.processMatchOffered(bl, n, string, string2);
        return true;
    }

    protected boolean processTakebackOffered(boolean bl, int n, String string, int n2) {
        super.processTakebackOffered(bl, n, string, n2);
        try {
            InternalGameData internalGameData = this.findMyGameAgainst(string);
            Player player = internalGameData.game.getUserPlayer();
            Player player2 = bl ? player.getOpponent() : player;
            this.offerIndicesToGameData.put(new Integer(n), internalGameData);
            internalGameData.indicesToTakebackOffers.put(new Integer(n), new Pair((Object)player2, (Object)new Integer(n2)));
            this.updateTakebackOffer(internalGameData, player2, n2);
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
        return true;
    }

    protected boolean processDrawOffered(boolean bl, int n, String string) {
        super.processDrawOffered(bl, n, string);
        this.processOffered(bl, n, string, 1);
        return true;
    }

    protected boolean processAbortOffered(boolean bl, int n, String string) {
        super.processAbortOffered(bl, n, string);
        this.processOffered(bl, n, string, 3);
        return true;
    }

    protected boolean processAdjournOffered(boolean bl, int n, String string) {
        super.processAdjournOffered(bl, n, string);
        this.processOffered(bl, n, string, 2);
        return true;
    }

    private void processOffered(boolean bl, int n, String string, int n2) {
        try {
            InternalGameData internalGameData = this.findMyGameAgainst(string);
            Player player = internalGameData.game.getUserPlayer();
            Player player2 = bl ? player.getOpponent() : player;
            this.offerIndicesToGameData.put(new Integer(n), internalGameData);
            internalGameData.indicesToOffers.put(new Integer(n), new Pair((Object)player2, (Object)new Integer(n2)));
            this.updateOffers(internalGameData, n2, player2, true);
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
    }

    protected boolean processOfferRemoved(int n) {
        super.processOfferRemoved(n);
        InternalGameData internalGameData = (InternalGameData)this.offerIndicesToGameData.remove(new Integer(n));
        if (internalGameData != null) {
            Pair pair = (Pair)internalGameData.indicesToOffers.remove(new Integer(n));
            if (pair != null) {
                Player player = (Player)pair.getFirst();
                int n2 = (Integer)pair.getSecond();
                this.updateOffers(internalGameData, n2, player, false);
            } else {
                pair = (Pair)internalGameData.indicesToTakebackOffers.remove(new Integer(n));
                if (pair != null) {
                    Player player = (Player)pair.getFirst();
                    this.updateTakebackOffer(internalGameData, player, 0);
                }
            }
        }
        return true;
    }

    protected boolean processPlayerCounteredTakebackOffer(int n, String string, int n2) {
        super.processPlayerCounteredTakebackOffer(n, string, n2);
        try {
            InternalGameData internalGameData = this.getGameData(n);
            Player player = internalGameData.game.getPlayerNamed(string);
            this.updateTakebackOffer(internalGameData, player.getOpponent(), 0);
            this.updateTakebackOffer(internalGameData, player, n2);
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
        return false;
    }

    protected boolean processPlayerOffered(int n, String string, String string2) {
        super.processPlayerOffered(n, string, string2);
        try {
            InternalGameData internalGameData = this.getGameData(n);
            Player player = internalGameData.game.getPlayerNamed(string);
            try {
                int n2 = JinFreechessConnection.offerIdForOfferName(string2);
                this.updateOffers(internalGameData, n2, player, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
        return false;
    }

    protected boolean processPlayerDeclined(int n, String string, String string2) {
        super.processPlayerDeclined(n, string, string2);
        try {
            InternalGameData internalGameData = this.getGameData(n);
            Player player = internalGameData.game.getPlayerNamed(string);
            try {
                int n2 = JinFreechessConnection.offerIdForOfferName(string2);
                this.updateOffers(internalGameData, n2, player.getOpponent(), false);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
        return false;
    }

    protected boolean processPlayerWithdrew(int n, String string, String string2) {
        super.processPlayerWithdrew(n, string, string2);
        try {
            InternalGameData internalGameData = this.getGameData(n);
            Player player = internalGameData.game.getPlayerNamed(string);
            try {
                int n2 = JinFreechessConnection.offerIdForOfferName(string2);
                this.updateOffers(internalGameData, n2, player, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
        return false;
    }

    protected boolean processPlayerOfferedTakeback(int n, String string, int n2) {
        super.processPlayerOfferedTakeback(n, string, n2);
        try {
            InternalGameData internalGameData = this.getGameData(n);
            Player player = internalGameData.game.getPlayerNamed(string);
            this.updateTakebackOffer(internalGameData, player, n2);
        }
        catch (NoSuchGameException noSuchGameException) {
            // empty catch block
        }
        return false;
    }

    private static int offerIdForOfferName(String string) throws IllegalArgumentException {
        if ("draw".equals(string)) {
            return 1;
        }
        if ("abort".equals(string)) {
            return 3;
        }
        if ("adjourn".equals(string)) {
            return 2;
        }
        if ("takeback".equals(string)) {
            return 4;
        }
        throw new IllegalArgumentException("Unknown offer name: " + string);
    }

    private void updateOffers(InternalGameData internalGameData, int n, Player player, boolean bl) {
        Game game = internalGameData.game;
        if (n == 4) {
            if (!bl && internalGameData.getTakebackOffer(player) == 0) {
                internalGameData.setTakebackOffer(player, 1);
            }
            this.updateTakebackOffer(internalGameData, player.getOpponent(), 0);
            this.updateTakebackOffer(internalGameData, player, bl ? 1 : 0);
        } else {
            internalGameData.setOffer(n, player, bl);
            this.listenerManager.fireGameEvent((GameEvent)new OfferEvent((Connection)this, game, n, bl, player));
        }
    }

    private void updateTakebackOffer(InternalGameData internalGameData, Player player, int n) {
        Game game = internalGameData.game;
        int n2 = internalGameData.getTakebackOffer(player);
        if (n2 != 0) {
            this.listenerManager.fireGameEvent((GameEvent)new OfferEvent((Connection)this, game, false, player, n2));
        }
        internalGameData.setTakebackOffer(player, n);
        if (n != 0) {
            this.listenerManager.fireGameEvent((GameEvent)new OfferEvent((Connection)this, game, true, player, n));
        }
    }

    public void acceptSeek(Seek seek) {
        if (!this.seeks.contains(seek)) {
            throw new IllegalArgumentException("The specified seek is not on the seek list");
        }
        this.sendCommand("$play " + seek.getID());
    }

    public void issueSeek(UserSeek userSeek) {
        WildVariant wildVariant = userSeek.getVariant();
        String string = this.getWildName(wildVariant);
        if (string == null) {
            throw new IllegalArgumentException("Unsupported variant: " + wildVariant);
        }
        Player player = userSeek.getColor();
        String string2 = "$seek " + userSeek.getTime() + " " + userSeek.getInc() + " " + (userSeek.isRated() ? "rated" : "unrated") + " " + (player == null ? "" : (player.isWhite() ? "white " : "black ")) + string + " " + (userSeek.isManualAccept() ? "manual " : "") + (userSeek.isFormula() ? "formula " : "") + (userSeek.getMinRating() == Integer.MIN_VALUE ? "0" : String.valueOf(userSeek.getMinRating())) + "-" + (userSeek.getMaxRating() == Integer.MAX_VALUE ? "9999" : String.valueOf(userSeek.getMaxRating())) + " ";
        this.sendCommand(string2);
    }

    public void exit() {
        this.sendCommand("$quit");
    }

    public void quitGame(Game game) {
        Object object = game.getID();
        switch (game.getGameType()) {
            case 1: {
                if (game.isPlayed()) {
                    this.sendCommand("$resign");
                    break;
                }
                this.sendCommand("$unexamine");
                break;
            }
            case 2: {
                this.sendCommand("$unobserve " + object);
                break;
            }
        }
    }

    public void makeMove(Game game, Move move) {
        Vector<Move> vector;
        Enumeration enumeration = this.ongoingGamesData.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            vector = (InternalGameData)enumeration.nextElement();
            if (((InternalGameData)((Object)vector)).game != game) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException("The specified Game object was not created by this JinConnection or the game has ended.");
        }
        this.sendCommand(JinFreechessConnection.moveToString(game, move));
        vector = (Vector)this.unechoedMoves.get(game);
        if (vector == null) {
            vector = new Vector<Move>(2);
            this.unechoedMoves.put(game, vector);
        }
        vector.addElement(move);
    }

    private static String moveToString(Game game, Move move) throws IllegalArgumentException {
        WildVariant wildVariant = game.getVariant();
        if (move instanceof ChessMove) {
            ChessMove chessMove = (ChessMove)move;
            if (chessMove.isShortCastling()) {
                return "O-O";
            }
            if (chessMove.isLongCastling()) {
                return "O-O-O";
            }
            String string = chessMove.getStartingSquare().toString() + chessMove.getEndingSquare().toString();
            if (chessMove.isPromotion()) {
                return string + "=" + wildVariant.pieceToString((Piece)chessMove.getPromotionTarget());
            }
            return string;
        }
        throw new IllegalArgumentException("Unsupported Move type: " + move.getClass());
    }

    public void resign(Game game) {
        this.checkGameMineAndPlayed(game);
        this.sendCommand("$resign");
    }

    public void requestDraw(Game game) {
        this.checkGameMineAndPlayed(game);
        this.sendCommand("$draw");
    }

    public boolean isAbortSupported() {
        return true;
    }

    public void requestAbort(Game game) {
        this.checkGameMineAndPlayed(game);
        this.sendCommand("$abort");
    }

    public boolean isAdjournSupported() {
        return true;
    }

    public void requestAdjourn(Game game) {
        this.checkGameMineAndPlayed(game);
        this.sendCommand("$adjourn");
    }

    public boolean isTakebackSupported() {
        return true;
    }

    public void requestTakeback(Game game) {
        this.checkGameMineAndPlayed(game);
        this.sendCommand("$takeback 1");
    }

    public boolean isMultipleTakebackSupported() {
        return true;
    }

    public void requestTakeback(Game game, int n) {
        this.checkGameMineAndPlayed(game);
        if (n < 1) {
            throw new IllegalArgumentException("Illegal ply count: " + n);
        }
        this.sendCommand("$takeback " + n);
    }

    public void goBackward(Game game, int n) {
        this.checkGameMineAndExamined(game);
        if (n < 1) {
            throw new IllegalArgumentException("Illegal ply count: " + n);
        }
        this.sendCommand("$backward " + n);
    }

    public void goForward(Game game, int n) {
        this.checkGameMineAndExamined(game);
        if (n < 1) {
            throw new IllegalArgumentException("Illegal ply count: " + n);
        }
        this.sendCommand("$forward " + n);
    }

    public void goToBeginning(Game game) {
        this.checkGameMineAndExamined(game);
        this.sendCommand("$backward 999");
    }

    public void goToEnd(Game game) {
        this.checkGameMineAndExamined(game);
        this.sendCommand("$forward 999");
    }

    private void checkGameMineAndPlayed(Game game) {
        if (game.getGameType() != 1 || !game.isPlayed()) {
            throw new IllegalArgumentException("The given game must be of type Game.MY_GAME and a played one");
        }
    }

    private void checkGameMineAndExamined(Game game) {
        if (game.getGameType() != 1 || game.isPlayed()) {
            throw new IllegalArgumentException("The given game must be of type Game.MY_GAME and an examined one");
        }
    }

    public void showServerHelp() {
        this.sendCommand("$help");
    }

    public void sendHelpQuestion(String string) {
        this.sendCommand("$tell 1 [" + Jin.getInstance().getAppName() + " " + Jin.getInstance().getAppVersion() + "] " + string);
    }

    public void execRunnable(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    private static class InternalGameData {
        public final Game game;
        public Vector moveList = new Vector();
        public Style12Struct boardData = null;
        public boolean isBSetup = false;
        public final Hashtable indicesToOffers = new Hashtable();
        public final Hashtable indicesToTakebackOffers = new Hashtable();
        private final Hashtable offers = new Hashtable();
        private int whiteTakeback;
        private int blackTakeback;

        public InternalGameData(Game game) {
            this.game = game;
        }

        public int getMoveCount() {
            return this.moveList.size();
        }

        public void addMove(Move move) {
            this.moveList.addElement(move);
        }

        public void removeLastMoves(int n) {
            if (n > this.moveList.size()) {
                throw new IllegalArgumentException("Can't remove more elements than there are elements");
            }
            int n2 = this.moveList.size() - 1;
            int n3 = this.moveList.size() - n;
            for (int i = n2; i >= n3; --i) {
                this.moveList.removeElementAt(i);
            }
        }

        public void clearMoves() {
            this.moveList.removeAllElements();
        }

        public boolean isOffered(int n, Player player) {
            return this.offers.containsKey(new Pair((Object)player, (Object)new Integer(n)));
        }

        public void setOffer(int n, Player player, boolean bl) {
            Pair pair = new Pair((Object)player, (Object)new Integer(n));
            if (bl) {
                this.offers.put(pair, pair);
            } else {
                this.offers.remove(pair);
            }
        }

        public void setTakebackOffer(Player player, int n) {
            if (player.isWhite()) {
                this.whiteTakeback = n;
            } else {
                this.blackTakeback = n;
            }
        }

        public int getTakebackOffer(Player player) {
            if (player.isWhite()) {
                return this.whiteTakeback;
            }
            return this.blackTakeback;
        }
    }
}

