/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.PutFilterAction;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class UpdateFilterAction
extends Action<Request, PutFilterAction.Response, RequestBuilder> {
    public static final UpdateFilterAction INSTANCE = new UpdateFilterAction();
    public static final String NAME = "cluster:admin/xpack/ml/filters/update";

    private UpdateFilterAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client);
    }

    public PutFilterAction.Response newResponse() {
        return new PutFilterAction.Response();
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, PutFilterAction.Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final ParseField ADD_ITEMS = new ParseField("add_items", new String[0]);
        public static final ParseField REMOVE_ITEMS = new ParseField("remove_items", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/filters/update", Request::new);
        private String filterId;
        @Nullable
        private String description;
        private SortedSet<String> addItems = Collections.emptySortedSet();
        private SortedSet<String> removeItems = Collections.emptySortedSet();

        public static Request parseRequest(String filterId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (request.filterId == null) {
                request.filterId = filterId;
            } else if (!Strings.isNullOrEmpty((String)filterId) && !filterId.equals(request.filterId)) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", MlFilter.ID.getPreferredName(), request.filterId, filterId));
            }
            return request;
        }

        public Request() {
        }

        public Request(String filterId) {
            this.filterId = ExceptionsHelper.requireNonNull(filterId, MlFilter.ID.getPreferredName());
        }

        public String getFilterId() {
            return this.filterId;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public SortedSet<String> getAddItems() {
            return this.addItems;
        }

        public void setAddItems(Collection<String> addItems) {
            this.addItems = new TreeSet<String>(ExceptionsHelper.requireNonNull(addItems, ADD_ITEMS.getPreferredName()));
        }

        public SortedSet<String> getRemoveItems() {
            return this.removeItems;
        }

        public void setRemoveItems(Collection<String> removeItems) {
            this.removeItems = new TreeSet<String>(ExceptionsHelper.requireNonNull(removeItems, REMOVE_ITEMS.getPreferredName()));
        }

        public boolean isNoop() {
            return this.description == null && this.addItems.isEmpty() && this.removeItems.isEmpty();
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.filterId = in.readString();
            this.description = in.readOptionalString();
            this.addItems = new TreeSet<String>(Arrays.asList(in.readStringArray()));
            this.removeItems = new TreeSet<String>(Arrays.asList(in.readStringArray()));
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.filterId);
            out.writeOptionalString(this.description);
            out.writeStringArray(this.addItems.toArray(new String[this.addItems.size()]));
            out.writeStringArray(this.removeItems.toArray(new String[this.removeItems.size()]));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MlFilter.ID.getPreferredName(), this.filterId);
            if (this.description != null) {
                builder.field(MlFilter.DESCRIPTION.getPreferredName(), this.description);
            }
            if (!this.addItems.isEmpty()) {
                builder.field(ADD_ITEMS.getPreferredName(), this.addItems);
            }
            if (!this.removeItems.isEmpty()) {
                builder.field(REMOVE_ITEMS.getPreferredName(), this.removeItems);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.filterId, this.description, this.addItems, this.removeItems);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.filterId, other.filterId) && Objects.equals(this.description, other.description) && Objects.equals(this.addItems, other.addItems) && Objects.equals(this.removeItems, other.removeItems);
        }

        static {
            PARSER.declareString((request, filterId) -> {
                request.filterId = filterId;
            }, MlFilter.ID);
            PARSER.declareStringOrNull(Request::setDescription, MlFilter.DESCRIPTION);
            PARSER.declareStringArray(Request::setAddItems, ADD_ITEMS);
            PARSER.declareStringArray(Request::setRemoveItems, REMOVE_ITEMS);
        }
    }
}

