/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.util.Random;
import org.xiph.speex.Bits;
import org.xiph.speex.Decoder;
import org.xiph.speex.Filters;
import org.xiph.speex.Inband;
import org.xiph.speex.Lsp;
import org.xiph.speex.NbCodec;
import org.xiph.speex.SbCodec;
import org.xiph.speex.Stereo;

public class NbDecoder
extends NbCodec
implements Decoder {
    private float[] innov2;
    private int count_lost;
    private int last_pitch;
    private float last_pitch_gain;
    private float[] pitch_gain_buf;
    private int pitch_gain_buf_idx;
    private float last_ol_gain;
    protected Random random = new Random();
    protected Stereo stereo = new Stereo();
    protected Inband inband = new Inband(this.stereo);
    protected boolean enhanced = true;

    public void init(int n, int n2, int n3, int n4) {
        super.init(n, n2, n3, n4);
        this.filters.init();
        this.innov2 = new float[40];
        this.count_lost = 0;
        this.last_pitch = 40;
        this.last_pitch_gain = 0.0f;
        this.pitch_gain_buf = new float[3];
        this.pitch_gain_buf_idx = 0;
        this.last_ol_gain = 0.0f;
    }

    public int decode(Bits bits, float[] fArray) {
        int n;
        int n2 = 0;
        float[] fArray2 = new float[3];
        float f = 0.0f;
        float f2 = 0.0f;
        int n3 = 40;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (bits == null && this.dtx_enabled != 0) {
            this.submodeID = 0;
        } else {
            int n4;
            if (bits == null) {
                this.decodeLost(fArray);
                return 0;
            }
            do {
                int n5;
                if (bits.unpack(1) != 0) {
                    n4 = bits.unpack(3);
                    n5 = SbCodec.SB_FRAME_SIZE[n4];
                    if (n5 < 0) {
                        return -2;
                    }
                    bits.advance(n5 -= 4);
                    if (bits.unpack(1) != 0) {
                        n4 = bits.unpack(3);
                        n5 = SbCodec.SB_FRAME_SIZE[n4];
                        if (n5 < 0) {
                            return -2;
                        }
                        bits.advance(n5 -= 4);
                        if (bits.unpack(1) != 0) {
                            return -2;
                        }
                    }
                }
                if ((n4 = bits.unpack(4)) == 15) {
                    return 1;
                }
                if (n4 == 14) {
                    n5 = this.inband.speexInbandRequest(bits);
                    if (n5 == 0) continue;
                    return n5;
                }
                if (n4 == 13) {
                    n5 = this.inband.userInbandRequest(bits);
                    if (n5 == 0) continue;
                    return n5;
                }
                if (n4 <= 8) continue;
                System.err.println("Invalid mode encountered: corrupted stream?");
                return 2;
            } while (n4 > 8);
            this.submodeID = n4;
        }
        System.arraycopy(this.frmBuf, this.frameSize, this.frmBuf, 0, this.bufSize - this.frameSize);
        System.arraycopy(this.excBuf, this.frameSize, this.excBuf, 0, this.bufSize - this.frameSize);
        if (this.submodes[this.submodeID] == null) {
            int n6;
            Filters.bw_lpc(0.93f, this.interp_qlpc, this.lpc, 10);
            float f5 = 0.0f;
            for (n6 = 0; n6 < this.frameSize; ++n6) {
                f5 += this.innov[n6] * this.innov[n6];
            }
            f5 = (float)Math.sqrt(f5 / (float)this.frameSize);
            for (n6 = this.excIdx; n6 < this.excIdx + this.frameSize; ++n6) {
                this.excBuf[n6] = 3.0f * f5 * (this.random.nextFloat() - 0.5f);
            }
            this.first = 1;
            Filters.iir_mem2(this.excBuf, this.excIdx, this.lpc, this.frmBuf, this.frmIdx, this.frameSize, this.lpcSize, this.mem_sp);
            fArray[0] = this.frmBuf[this.frmIdx] + this.preemph * this.pre_mem;
            for (n6 = 1; n6 < this.frameSize; ++n6) {
                fArray[n6] = this.frmBuf[this.frmIdx + n6] + this.preemph * fArray[n6 - 1];
            }
            this.pre_mem = fArray[this.frameSize - 1];
            this.count_lost = 0;
            return 0;
        }
        this.submodes[this.submodeID].lsqQuant.unquant(this.qlsp, this.lpcSize, bits);
        if (this.count_lost != 0) {
            float f6 = 0.0f;
            for (n = 0; n < this.lpcSize; ++n) {
                f6 += Math.abs(this.old_qlsp[n] - this.qlsp[n]);
            }
            float f7 = (float)(0.6 * Math.exp(-0.2 * (double)f6));
            n = 0;
            while (n < 2 * this.lpcSize) {
                int n7 = n++;
                this.mem_sp[n7] = this.mem_sp[n7] * f7;
            }
        }
        if (this.first != 0 || this.count_lost != 0) {
            for (n = 0; n < this.lpcSize; ++n) {
                this.old_qlsp[n] = this.qlsp[n];
            }
        }
        if (this.submodes[this.submodeID].lbr_pitch != -1) {
            n2 = this.min_pitch + bits.unpack(7);
        }
        if (this.submodes[this.submodeID].forced_pitch_gain != 0) {
            int n8 = bits.unpack(4);
            f2 = 0.066667f * (float)n8;
        }
        int n9 = bits.unpack(5);
        f = (float)Math.exp((double)n9 / 3.5);
        if (this.submodeID == 1) {
            int n10 = bits.unpack(4);
            this.dtx_enabled = n10 == 15 ? 1 : 0;
        }
        if (this.submodeID > 1) {
            this.dtx_enabled = 0;
        }
        for (int i = 0; i < this.nbSubframes; ++i) {
            float f8;
            int n11;
            int n12;
            int n13;
            int n14 = this.subframeSize * i;
            int n15 = this.frmIdx + n14;
            int n16 = this.excIdx + n14;
            float f9 = (1.0f + (float)i) / (float)this.nbSubframes;
            for (n = 0; n < this.lpcSize; ++n) {
                this.interp_qlsp[n] = (1.0f - f9) * this.old_qlsp[n] + f9 * this.qlsp[n];
            }
            Lsp.enforce_margin(this.interp_qlsp, this.lpcSize, 0.002f);
            for (n = 0; n < this.lpcSize; ++n) {
                this.interp_qlsp[n] = (float)Math.cos(this.interp_qlsp[n]);
            }
            this.m_lsp.lsp2lpc(this.interp_qlsp, this.interp_qlpc, this.lpcSize);
            if (this.enhanced) {
                float f10 = 0.9f;
                float f11 = this.submodes[this.submodeID].lpc_enh_k1;
                float f12 = this.submodes[this.submodeID].lpc_enh_k2;
                float f13 = (1.0f - (1.0f - f10 * f11) / (1.0f - f10 * f12)) / f10;
                Filters.bw_lpc(f11, this.interp_qlpc, this.awk1, this.lpcSize);
                Filters.bw_lpc(f12, this.interp_qlpc, this.awk2, this.lpcSize);
                Filters.bw_lpc(f13, this.interp_qlpc, this.awk3, this.lpcSize);
            }
            f9 = 1.0f;
            this.pi_gain[i] = 0.0f;
            for (n = 0; n <= this.lpcSize; ++n) {
                int n17 = i;
                this.pi_gain[n17] = this.pi_gain[n17] + f9 * this.interp_qlpc[n];
                f9 = -f9;
            }
            for (n = 0; n < this.subframeSize; ++n) {
                this.excBuf[n16 + n] = 0.0f;
            }
            if (this.submodes[this.submodeID].lbr_pitch != -1) {
                int n18 = this.submodes[this.submodeID].lbr_pitch;
                if (n18 != 0) {
                    n13 = n2 - n18 + 1;
                    if (n13 < this.min_pitch) {
                        n13 = this.min_pitch;
                    }
                    if ((n12 = n2 + n18) > this.max_pitch) {
                        n12 = this.max_pitch;
                    }
                } else {
                    n13 = n12 = n2;
                }
            } else {
                n13 = this.min_pitch;
                n12 = this.max_pitch;
            }
            int n19 = this.submodes[this.submodeID].ltp.unquant(this.excBuf, n16, n13, f2, this.subframeSize, fArray2, bits, this.count_lost, n14, this.last_pitch_gain);
            if (this.count_lost != 0 && f < this.last_ol_gain) {
                float f14 = f / (this.last_ol_gain + 1.0f);
                for (n = 0; n < this.subframeSize; ++n) {
                    int n20 = this.excIdx + n;
                    this.excBuf[n20] = this.excBuf[n20] * f14;
                }
            }
            f9 = Math.abs(fArray2[0] + fArray2[1] + fArray2[2]);
            f9 = Math.abs(fArray2[1]);
            f9 = fArray2[0] > 0.0f ? (f9 += fArray2[0]) : (float)((double)f9 - 0.5 * (double)fArray2[0]);
            f9 = fArray2[2] > 0.0f ? (f9 += fArray2[2]) : (float)((double)f9 - 0.5 * (double)fArray2[0]);
            f4 += f9;
            if (f9 > f3) {
                n3 = n19;
                f3 = f9;
            }
            for (n = n11 = i * this.subframeSize; n < n11 + this.subframeSize; ++n) {
                this.innov[n] = 0.0f;
            }
            if (this.submodes[this.submodeID].have_subframe_gain == 3) {
                int n21 = bits.unpack(3);
                f8 = (float)((double)f * Math.exp(exc_gain_quant_scal3[n21]));
            } else if (this.submodes[this.submodeID].have_subframe_gain == 1) {
                int n22 = bits.unpack(1);
                f8 = (float)((double)f * Math.exp(exc_gain_quant_scal1[n22]));
            } else {
                f8 = f;
            }
            if (this.submodes[this.submodeID].innovation != null) {
                this.submodes[this.submodeID].innovation.unquant(this.innov, n11, this.subframeSize, bits);
            }
            n = n11;
            while (n < n11 + this.subframeSize) {
                int n23 = n++;
                this.innov[n23] = this.innov[n23] * f8;
            }
            if (this.submodeID == 1) {
                float f15 = f2;
                for (n = 0; n < this.subframeSize; ++n) {
                    this.excBuf[n16 + n] = 0.0f;
                }
                while (this.voc_offset < this.subframeSize) {
                    if (this.voc_offset >= 0) {
                        this.excBuf[n16 + this.voc_offset] = (float)Math.sqrt(1.0f * (float)n2);
                    }
                    this.voc_offset += n2;
                }
                this.voc_offset -= this.subframeSize;
                if ((f15 = 0.5f + 2.0f * (f15 - 0.6f)) < 0.0f) {
                    f15 = 0.0f;
                }
                if (f15 > 1.0f) {
                    f15 = 1.0f;
                }
                for (n = 0; n < this.subframeSize; ++n) {
                    float f16 = this.excBuf[n16 + n];
                    this.excBuf[n16 + n] = 0.8f * f15 * this.excBuf[n16 + n] * f + 0.6f * f15 * this.voc_m1 * f + 0.5f * f15 * this.innov[n11 + n] - 0.5f * f15 * this.voc_m2 + (1.0f - f15) * this.innov[n11 + n];
                    this.voc_m1 = f16;
                    this.voc_m2 = this.innov[n11 + n];
                    this.voc_mean = 0.95f * this.voc_mean + 0.05f * this.excBuf[n16 + n];
                    int n24 = n16 + n;
                    this.excBuf[n24] = this.excBuf[n24] - this.voc_mean;
                }
            } else {
                for (n = 0; n < this.subframeSize; ++n) {
                    int n25 = n16 + n;
                    this.excBuf[n25] = this.excBuf[n25] + this.innov[n11 + n];
                }
            }
            if (this.submodes[this.submodeID].double_codebook != 0) {
                for (n = 0; n < this.subframeSize; ++n) {
                    this.innov2[n] = 0.0f;
                }
                this.submodes[this.submodeID].innovation.unquant(this.innov2, 0, this.subframeSize, bits);
                n = 0;
                while (n < this.subframeSize) {
                    int n26 = n++;
                    this.innov2[n26] = (float)((double)this.innov2[n26] * ((double)f8 * 0.45454545454545453));
                }
                for (n = 0; n < this.subframeSize; ++n) {
                    int n27 = n16 + n;
                    this.excBuf[n27] = this.excBuf[n27] + this.innov2[n];
                }
            }
            for (n = 0; n < this.subframeSize; ++n) {
                this.frmBuf[n15 + n] = this.excBuf[n16 + n];
            }
            if (this.enhanced && this.submodes[this.submodeID].comb_gain > 0.0f) {
                this.filters.comb_filter(this.excBuf, n16, this.frmBuf, n15, this.subframeSize, n19, fArray2, this.submodes[this.submodeID].comb_gain);
            }
            if (this.enhanced) {
                Filters.filter_mem2(this.frmBuf, n15, this.awk2, this.awk1, this.subframeSize, this.lpcSize, this.mem_sp, this.lpcSize);
                Filters.filter_mem2(this.frmBuf, n15, this.awk3, this.interp_qlpc, this.subframeSize, this.lpcSize, this.mem_sp, 0);
                continue;
            }
            for (n = 0; n < this.lpcSize; ++n) {
                this.mem_sp[this.lpcSize + n] = 0.0f;
            }
            Filters.iir_mem2(this.frmBuf, n15, this.interp_qlpc, this.frmBuf, n15, this.subframeSize, this.lpcSize, this.mem_sp);
        }
        fArray[0] = this.frmBuf[this.frmIdx] + this.preemph * this.pre_mem;
        for (n = 1; n < this.frameSize; ++n) {
            fArray[n] = this.frmBuf[this.frmIdx + n] + this.preemph * fArray[n - 1];
        }
        this.pre_mem = fArray[this.frameSize - 1];
        for (n = 0; n < this.lpcSize; ++n) {
            this.old_qlsp[n] = this.qlsp[n];
        }
        this.first = 0;
        this.count_lost = 0;
        this.last_pitch = n3;
        this.last_pitch_gain = 0.25f * f4;
        this.pitch_gain_buf[this.pitch_gain_buf_idx++] = this.last_pitch_gain;
        if (this.pitch_gain_buf_idx > 2) {
            this.pitch_gain_buf_idx = 0;
        }
        this.last_ol_gain = f;
        return 0;
    }

    public int decodeLost(float[] fArray) {
        int n;
        float f;
        float f2;
        float f3 = (float)Math.exp(-0.04 * (double)this.count_lost * (double)this.count_lost);
        float f4 = this.pitch_gain_buf[0] < this.pitch_gain_buf[1] ? (this.pitch_gain_buf[1] < this.pitch_gain_buf[2] ? this.pitch_gain_buf[1] : (this.pitch_gain_buf[0] < this.pitch_gain_buf[2] ? this.pitch_gain_buf[2] : this.pitch_gain_buf[0])) : (this.pitch_gain_buf[2] < this.pitch_gain_buf[1] ? this.pitch_gain_buf[1] : (f2 = this.pitch_gain_buf[2] < this.pitch_gain_buf[0] ? this.pitch_gain_buf[2] : this.pitch_gain_buf[0]));
        if (f2 < this.last_pitch_gain) {
            this.last_pitch_gain = f2;
        }
        if ((f = this.last_pitch_gain) > 0.95f) {
            f = 0.95f;
        }
        f *= f3;
        System.arraycopy(this.frmBuf, this.frameSize, this.frmBuf, 0, this.bufSize - this.frameSize);
        System.arraycopy(this.excBuf, this.frameSize, this.excBuf, 0, this.bufSize - this.frameSize);
        for (int i = 0; i < this.nbSubframes; ++i) {
            float f5;
            int n2 = this.subframeSize * i;
            int n3 = this.frmIdx + n2;
            int n4 = this.excIdx + n2;
            if (this.enhanced) {
                float f6;
                float f7;
                f5 = 0.9f;
                if (this.submodes[this.submodeID] != null) {
                    f7 = this.submodes[this.submodeID].lpc_enh_k1;
                    f6 = this.submodes[this.submodeID].lpc_enh_k2;
                } else {
                    f6 = 0.7f;
                    f7 = 0.7f;
                }
                float f8 = (1.0f - (1.0f - f5 * f7) / (1.0f - f5 * f6)) / f5;
                Filters.bw_lpc(f7, this.interp_qlpc, this.awk1, this.lpcSize);
                Filters.bw_lpc(f6, this.interp_qlpc, this.awk2, this.lpcSize);
                Filters.bw_lpc(f8, this.interp_qlpc, this.awk3, this.lpcSize);
            }
            f5 = 0.0f;
            for (n = 0; n < this.frameSize; ++n) {
                f5 += this.innov[n] * this.innov[n];
            }
            f5 = (float)Math.sqrt(f5 / (float)this.frameSize);
            for (n = 0; n < this.subframeSize; ++n) {
                this.excBuf[n4 + n] = f * this.excBuf[n4 + n - this.last_pitch] + f3 * (float)Math.sqrt(1.0f - f) * 3.0f * f5 * (this.random.nextFloat() - 0.5f);
            }
            for (n = 0; n < this.subframeSize; ++n) {
                this.frmBuf[n3 + n] = this.excBuf[n4 + n];
            }
            if (this.enhanced) {
                Filters.filter_mem2(this.frmBuf, n3, this.awk2, this.awk1, this.subframeSize, this.lpcSize, this.mem_sp, this.lpcSize);
                Filters.filter_mem2(this.frmBuf, n3, this.awk3, this.interp_qlpc, this.subframeSize, this.lpcSize, this.mem_sp, 0);
                continue;
            }
            for (n = 0; n < this.lpcSize; ++n) {
                this.mem_sp[this.lpcSize + n] = 0.0f;
            }
            Filters.iir_mem2(this.frmBuf, n3, this.interp_qlpc, this.frmBuf, n3, this.subframeSize, this.lpcSize, this.mem_sp);
        }
        fArray[0] = this.frmBuf[0] + this.preemph * this.pre_mem;
        for (n = 1; n < this.frameSize; ++n) {
            fArray[n] = this.frmBuf[n] + this.preemph * fArray[n - 1];
        }
        this.pre_mem = fArray[this.frameSize - 1];
        this.first = 0;
        ++this.count_lost;
        this.pitch_gain_buf[this.pitch_gain_buf_idx++] = f;
        if (this.pitch_gain_buf_idx > 2) {
            this.pitch_gain_buf_idx = 0;
        }
        return 0;
    }

    public void decodeStereo(float[] fArray, int n) {
        this.stereo.decode(fArray, n);
    }

    public void setPerceptualEnhancement(boolean bl) {
        this.enhanced = bl;
    }

    public boolean getPerceptualEnhancement() {
        return this.enhanced;
    }
}

