/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.Multicaster;

public class APopupMenu
extends JPopupMenu {
    public static final int SHOWN_EVENT = 0;
    private EventListener listener;
    private Object target = null;
    private Object ignoreNextPress;

    public APopupMenu() {
    }

    public APopupMenu(String name) {
        super(name);
    }

    public void addListener(EventListener newListener) {
        this.listener = Multicaster.add(this.listener, newListener);
    }

    public void addTriggerComponent(Component comp) {
        comp.addMouseListener(new EventHelper());
    }

    public void show(Component comp) {
        if (this.isVisible() || this.ignoreNextPress == comp) {
            this.ignoreNextPress = null;
            return;
        }
        if (!comp.isShowing()) {
            return;
        }
        this.ignoreNextPress = null;
        this.target = comp;
        this.setInvoker(comp);
        Dimension screenSize = comp.getToolkit().getScreenSize();
        Dimension compSize = comp.getSize();
        Dimension pmSize = this.getPreferredSize();
        Point position = comp.getLocationOnScreen();
        int x = 0;
        int y = compSize.height;
        if (pmSize.width > compSize.width && position.x + pmSize.width > screenSize.width && position.x + compSize.width - pmSize.width >= 0) {
            x = compSize.width - pmSize.width;
        }
        if (position.y + y + pmSize.height > screenSize.height && position.y - pmSize.height >= 0) {
            y = -pmSize.height;
        }
        super.show(comp, x, y);
    }

    @Override
    public void show(Component comp, int x, int y) {
        this.show(comp, x, y, comp);
    }

    public void show(Component comp, int x, int y, Object newTarget) {
        if (this.isVisible() || this.ignoreNextPress == comp || !comp.isShowing()) {
            this.ignoreNextPress = null;
            return;
        }
        this.ignoreNextPress = null;
        this.target = newTarget;
        this.setInvoker(comp);
        Dimension screenSize = comp.getToolkit().getScreenSize();
        Dimension pmSize = this.getPreferredSize();
        Point position = comp.getLocationOnScreen();
        if (position.x + x + pmSize.width > screenSize.width) {
            x -= pmSize.width;
        }
        if (position.y + y + pmSize.height > screenSize.height) {
            y -= pmSize.height;
        }
        if (this.listener != null) {
            this.listener.handleEvent(new Event(this, 0, newTarget));
        }
        super.show(comp, x, y);
    }

    public Object getTarget() {
        return this.target;
    }

    private class EventHelper
    extends MouseAdapter {
        private EventHelper() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            Object src;
            if (APopupMenu.this.isVisible() && (src = event.getSource()) == APopupMenu.this.getInvoker()) {
                APopupMenu.this.ignoreNextPress = src;
                return;
            }
            APopupMenu.this.ignoreNextPress = null;
        }
    }
}

