/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.speex;

import java.io.IOException;
import java.io.OutputStream;
import org.igoweb.util.speex.BitIoError;
import org.xiph.speex.Bits;

class BitOutputStream
extends Bits {
    private OutputStream out;
    private byte[] buffer = new byte[2048];
    private int numBytes;
    private byte curByte;
    private int numBitsFilled;

    public BitOutputStream(OutputStream out) {
        this.out = out;
        this.numBytes = 0;
    }

    @Override
    public void advance(int n) {
        throw new UnsupportedOperationException();
    }

    public void flushAndSync() {
        try {
            if (this.numBitsFilled > 0) {
                this.fillBuf();
            }
            this.out.write(this.buffer, 0, this.numBytes);
            this.out.flush();
            this.numBytes = 0;
        }
        catch (IOException excep) {
            throw new BitIoError(excep.toString());
        }
    }

    @Override
    public void pack(int data, int numBits) {
        while (numBits > 0) {
            this.curByte = (byte)(this.curByte | (data >> --numBits & 1) << 7 - this.numBitsFilled);
            if (++this.numBitsFilled != 8) continue;
            this.fillBuf();
        }
    }

    private void fillBuf() {
        try {
            this.buffer[this.numBytes++] = this.curByte;
            this.curByte = 0;
            this.numBitsFilled = 0;
        }
        catch (ArrayIndexOutOfBoundsException excep) {
            throw new BitIoError("Overlarge audio packet");
        }
    }
}

