/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JMenuItem;
import org.igoweb.igoweb.client.CArchive;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.shared.GameSummary;
import org.igoweb.igoweb.shared.Role;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.FlatSet;
import org.igoweb.util.swing.APopupMenu;

public abstract class ResumeMenu
extends APopupMenu {
    private final Client client;
    private final TreeMap<Long, GameSummary<?>> games = new TreeMap();
    private final FlatSet<Component> buttons = new FlatSet();

    public ResumeMenu(Client client) {
        this.client = client;
        client.requestArchive(client.getMe().name, new EventListener(){

            @Override
            public void handleEvent(Event event) {
                ResumeMenu.this.handleArchiveEvent(event);
            }
        });
    }

    public void addButton(Component comp) {
        if (this.buttons.add(comp)) {
            comp.setEnabled(!this.games.isEmpty());
        }
    }

    public void removeButton(Component comp) {
        this.buttons.remove(comp);
    }

    private void handleArchiveEvent(Event event) {
        boolean wasEmpty = this.games.isEmpty();
        switch (event.type) {
            case 35: {
                Iterator<GameSummary<?>> newGames = ((CArchive)event.source).getGames().iterator();
                while (newGames.hasNext()) {
                    this.addGame(newGames.next());
                }
                break;
            }
            case 36: {
                this.addGame((GameSummary)event.arg);
                break;
            }
            case 37: {
                this.games.remove(new Long(((GameSummary)event.arg).id));
                break;
            }
            default: {
                return;
            }
        }
        boolean isEmpty = this.games.isEmpty();
        if (isEmpty != wasEmpty) {
            Iterator<Component> iter = this.buttons.iterator();
            while (iter.hasNext()) {
                iter.next().setEnabled(!isEmpty);
            }
        }
    }

    private void addGame(GameSummary<?> game) {
        if (game.isFinished()) {
            this.games.remove(new Long(game.id));
        } else {
            this.games.put(new Long(game.id), game);
        }
    }

    public void show(Component comp, final CRoom room) {
        this.removeAll();
        for (final GameSummary<?> result : this.games.values()) {
            JMenuItem jm = new JMenuItem(this.getResumeMenuText(result));
            jm.setEnabled(result.isInPlay() || !result.getGameType().isRanked() || !room.isPrivate());
            if (result.isInPlay()) {
                jm.setFont(jm.getFont().deriveFont(1));
            } else if (this.allPlayersPresent(result)) {
                jm.setFont(jm.getFont().deriveFont(2));
            }
            this.add(jm);
            jm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (result.isInPlay()) {
                        ResumeMenu.this.client.sendJoinRequest(result.id);
                    } else {
                        room.requestLoadGame(result.id, result.isPrivate());
                    }
                }
            });
        }
        super.show(comp);
    }

    protected abstract String getResumeMenuText(GameSummary<?> var1);

    private boolean allPlayersPresent(GameSummary<?> gsum) {
        for (int i = 0; i < Role.count(); ++i) {
            Role role = Role.get(i);
            if (!gsum.getGameType().isMainRole(role) || ((User)gsum.getPlayer(role)).isConnected()) continue;
            return false;
        }
        return true;
    }
}

