/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.sketch.FrequencyCounts;
import edu.umd.marbl.mhap.sketch.HashUtils;
import edu.umd.marbl.mhap.sketch.Sketch;
import edu.umd.marbl.mhap.sketch.SketchRuntimeException;
import edu.umd.marbl.mhap.sketch.ZeroNGramsFoundException;
import edu.umd.marbl.mhap.utils.HitCounter;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;

public final class MinHashSketch
implements Sketch<MinHashSketch> {
    private final int[] minHashes;
    private static final long serialVersionUID = 8846482698636860862L;

    private static final int[] computeNgramMinHashesWeighted(String seq, int nGramSize, int numHashes, FrequencyCounts kmerFilter, boolean doReverseCompliment, double repeatWeight) throws ZeroNGramsFoundException {
        int numberNGrams = seq.length() - nGramSize + 1;
        if (numberNGrams < 1) {
            throw new ZeroNGramsFoundException("N-gram size bigger than string length.", seq);
        }
        long[] kmerHashes = HashUtils.computeSequenceHashesLong(seq, nGramSize, 0, doReverseCompliment);
        Long2ObjectLinkedOpenHashMap<HitCounter> hitMap = new Long2ObjectLinkedOpenHashMap<HitCounter>(kmerHashes.length);
        for (long kmer : kmerHashes) {
            if (kmerFilter != null && !kmerFilter.keepKmer(kmer)) continue;
            HitCounter counter = (HitCounter)hitMap.get(kmer);
            if (counter == null) {
                counter = new HitCounter(1);
                hitMap.put(kmer, counter);
                continue;
            }
            counter.addHit();
        }
        if (hitMap.isEmpty()) {
            throw new ZeroNGramsFoundException("Found zero unfiltered n-grams in the string.", seq);
        }
        int[] hashes = new int[Math.max(1, numHashes)];
        long[] best = new long[numHashes];
        Arrays.fill(best, Long.MAX_VALUE);
        int numberValid = 0;
        for (Map.Entry kmer : hitMap.entrySet()) {
            double idf;
            double tf;
            long key = (Long)kmer.getKey();
            int weight = ((HitCounter)kmer.getValue()).count;
            if (repeatWeight < 0.0) {
                weight = 1;
                if (kmerFilter != null && kmerFilter.isPopular(key)) {
                    weight = 0;
                }
            } else if (kmerFilter != null && repeatWeight >= 0.0 && repeatWeight < 1.0 && (weight = (int)Math.round((tf = kmerFilter.tfWeight(weight)) * (idf = kmerFilter.scaledIdf(key)))) < 1) {
                weight = 1;
            }
            if (weight <= 0) continue;
            ++numberValid;
            long x = key;
            for (int word = 0; word < numHashes; ++word) {
                for (int count = 0; count < weight; ++count) {
                    x ^= x << 21;
                    x ^= x >>> 35;
                    if ((x ^= x << 4) >= best[word]) continue;
                    best[word] = x;
                    hashes[word] = word % 2 == 0 ? (int)key : (int)(key >>> 32);
                }
            }
        }
        if (numberValid <= 0) {
            throw new ZeroNGramsFoundException("Found zero unfiltered n-grams in the string.", seq);
        }
        return hashes;
    }

    public static MinHashSketch fromByteStream(DataInputStream input) throws IOException {
        try {
            int hashNum = input.readInt();
            int[] minHashes = new int[hashNum];
            for (int hash = 0; hash < hashNum; ++hash) {
                minHashes[hash] = input.readInt();
            }
            return new MinHashSketch(minHashes);
        }
        catch (EOFException e) {
            return null;
        }
    }

    private MinHashSketch(int[] minHashes) {
        this.minHashes = minHashes;
    }

    public MinHashSketch(String str, int nGramSize, int numHashes, boolean doReverseCompliment) throws ZeroNGramsFoundException {
        this.minHashes = MinHashSketch.computeNgramMinHashesWeighted(str, nGramSize, numHashes, null, doReverseCompliment, -1.0);
    }

    public MinHashSketch(String seq, int nGramSize, int numHashes, FrequencyCounts freqFilter, boolean doReverseCompliment, double repeatWeight) throws ZeroNGramsFoundException {
        this.minHashes = MinHashSketch.computeNgramMinHashesWeighted(seq, nGramSize, numHashes, freqFilter, doReverseCompliment, repeatWeight);
    }

    public byte[] getAsByteArray() {
        ByteBuffer bb = ByteBuffer.allocate(4 * (1 + this.minHashes.length));
        bb.putInt(this.minHashes.length);
        for (int hash = 0; hash < this.minHashes.length; ++hash) {
            bb.putInt(this.minHashes[hash]);
        }
        return bb.array();
    }

    public final int[] getMinHashArray() {
        return this.minHashes;
    }

    public final double jaccard(MinHashSketch h) {
        int count = 0;
        int size = this.minHashes.length;
        if (h.minHashes.length != size) {
            throw new SketchRuntimeException("MinHashes must be of same length in order to be compared.");
        }
        for (int iter = 0; iter < size; ++iter) {
            if (this.minHashes[iter] != h.minHashes[iter]) continue;
            ++count;
        }
        return (double)count / (double)size;
    }

    public final int numHashes() {
        return this.minHashes.length;
    }

    @Override
    public double similarity(MinHashSketch sh) {
        return this.jaccard(sh);
    }

    public String toString() {
        return "MinHash " + Arrays.toString(this.minHashes) + "";
    }
}

