/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.math3.util.MathArrays;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class FindDelayEvaluator
extends RecursiveNumericEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public FindDelayEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (null == first) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (null == second) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
        }
        if (!(first instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        if (!(second instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        double[] firstArray = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
        double[] secondArray = StreamSupport.stream(Spliterators.spliteratorUnknownSize(((List)second).stream().collect(Collectors.toCollection(LinkedList::new)).descendingIterator(), 16), false).mapToDouble(value -> ((Number)value).doubleValue()).toArray();
        double[] convolution = MathArrays.convolve((double[])firstArray, (double[])secondArray);
        double maxValue = -1.7976931348623157E308;
        double indexOfMaxValue = -1.0;
        for (int idx = 0; idx < convolution.length; ++idx) {
            double abs = Math.abs(convolution[idx]);
            if (!(abs > maxValue)) continue;
            maxValue = abs;
            indexOfMaxValue = idx;
        }
        return indexOfMaxValue + 1.0 - (double)secondArray.length;
    }
}

