/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;

final class VMProcess
extends Process {
    private static final int INITIAL = 0;
    private static final int RUNNING = 1;
    private static final int TERMINATED = 2;
    static Thread processThread;
    static final LinkedList workList;
    static long reapedPid;
    static int reapedExitValue;
    int state;
    final String[] cmd;
    final String[] env;
    final File dir;
    Throwable exception;
    long pid;
    OutputStream stdin;
    InputStream stdout;
    InputStream stderr;
    int exitValue;

    private final void setProcessInfo(OutputStream stdin, InputStream stdout, InputStream stderr, long pid) {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.pid = pid;
    }

    static final Process exec(String[] cmd, String[] env, File dir) throws IOException {
        return new VMProcess(cmd, env, dir);
    }

    public final OutputStream getOutputStream() {
        return this.stdin;
    }

    public final InputStream getInputStream() {
        return this.stdout;
    }

    public final InputStream getErrorStream() {
        return this.stderr;
    }

    public final synchronized int waitFor() throws InterruptedException {
        while (this.state != 2) {
            this.wait();
        }
        return this.exitValue;
    }

    public final synchronized int exitValue() {
        if (this.state != 2) {
            throw new IllegalThreadStateException();
        }
        return this.exitValue;
    }

    public final synchronized void destroy() {
        if (this.state == 2) {
            return;
        }
        VMProcess.nativeKill(this.pid);
        while (this.state != 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    final native void nativeSpawn(String[] var1, String[] var2, File var3) throws IOException;

    static final native boolean nativeReap();

    private static final native void nativeKill(long var0);

    static final /* synthetic */ int access$0() {
        return 2;
    }

    static final /* synthetic */ int access$1() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VMProcess(String[] cmd, String[] env, File dir) throws IOException {
        block14: {
            super();
            this.state = 0;
            this.cmd = cmd;
            this.env = env;
            this.dir = dir;
            var4_4 = VMProcess.workList;
            synchronized (var4_4) {
                block13: {
                    VMProcess.workList.add(this);
                    if (VMProcess.processThread != null) break block13;
                    VMProcess.processThread = new ProcessThread();
                    VMProcess.processThread.setDaemon(true);
                    VMProcess.processThread.start();
                    break block14;
                }
                VMProcess.workList.notify();
            }
        }
        var4_4 = this;
        synchronized (var4_4) {
            if (true) ** GOTO lbl33
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
lbl33:
                // 3 sources

            } while (this.state == 0);
            ** if (this.exception == null) goto lbl44
        }
lbl-1000:
        // 1 sources

        {
            this.exception.fillInStackTrace();
            if (this.exception instanceof IOException) {
                throw (IOException)this.exception;
            }
            if (this.exception instanceof Error) {
                throw (Error)this.exception;
            }
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            throw new RuntimeException(this.exception);
        }
lbl44:
        // 1 sources

    }

    static {
        workList = new LinkedList();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class ProcessThread
    extends Thread {
        private static final int MAX_REAP_DELAY = 1000;
        private final HashMap activeMap;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            workList = VMProcess.workList;
            while (true) {
                process = null;
                var3_3 = workList;
                synchronized (var3_3) {
                    if (!workList.isEmpty()) {
                        process = (VMProcess)workList.removeFirst();
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 11] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (process == null) ** GOTO lbl30
                    this.spawn(process);
                    if (true) ** GOTO lbl30
                }
                do {
                    pid = VMProcess.reapedPid;
                    exitValue = VMProcess.reapedExitValue;
                    process = (VMProcess)this.activeMap.remove(new Long(pid));
                    if (process != null) {
                        var8_7 = process;
                        synchronized (var8_7) {
                            process.exitValue = exitValue;
                            process.state = 2;
                            process.notify();
                        }
                    } else {
                        System.err.println("VMProcess WARNING reaped unknown process: " + pid);
                    }
lbl30:
                    // 4 sources

                } while (!this.activeMap.isEmpty() && VMProcess.nativeReap());
                var3_3 = workList;
                synchronized (var3_3) {
                    if (!workList.isEmpty()) {
                        continue;
                    }
                    if (this.activeMap.isEmpty()) {
                        VMProcess.processThread = null;
                        return;
                    }
                    try {
                        workList.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void spawn(VMProcess process) {
            VMProcess vMProcess = process;
            synchronized (vMProcess) {
                try {
                    process.nativeSpawn(process.cmd, process.env, process.dir);
                    process.state = 1;
                    this.activeMap.put(new Long(process.pid), process);
                }
                catch (ThreadDeath death) {
                    throw death;
                }
                catch (Throwable t) {
                    process.state = 2;
                    process.exception = t;
                }
                process.notify();
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.activeMap = new HashMap();
        }

        ProcessThread() {
            this.this();
        }
    }
}

