/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorsUtil {
    private EditorColorsUtil() {
    }

    @NotNull
    public static EditorColorsScheme getGlobalOrDefaultColorScheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getColorSchemeForBackground(null);
        if (editorColorsScheme == null) {
            EditorColorsUtil.$$$reportNull$$$0(0);
        }
        return editorColorsScheme;
    }

    @Nullable
    public static Color getGlobalOrDefaultColor(@NotNull ColorKey colorKey) {
        Color color;
        if (colorKey == null) {
            EditorColorsUtil.$$$reportNull$$$0(1);
        }
        return (color = EditorColorsUtil.getColorSchemeForBackground(null).getColor(colorKey)) != null ? color : colorKey.getDefaultColor();
    }

    @NotNull
    public static EditorColorsScheme getColorSchemeForComponent(@Nullable JComponent component) {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getColorSchemeForBackground(component != null ? component.getBackground() : null);
        if (editorColorsScheme == null) {
            EditorColorsUtil.$$$reportNull$$$0(2);
        }
        return editorColorsScheme;
    }

    public static EditorColorsScheme getColorSchemeForBackground(@Nullable Color background) {
        EditorColorsScheme scheme;
        EditorColorsScheme globalScheme;
        boolean dark2;
        boolean dark1 = background == null ? UIUtil.isUnderDarcula() : ColorUtil.isDark((Color)background);
        if (dark1 != (dark2 = ColorUtil.isDark((Color)(globalScheme = EditorColorsManager.getInstance().getGlobalScheme()).getDefaultBackground())) && (scheme = EditorColorsManager.getInstance().getScheme("Default")) != null) {
            return scheme;
        }
        return globalScheme;
    }

    @NotNull
    public static EditorColorsScheme getColorSchemeForPrinting() {
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme editorColorsScheme = colorsManager.isDarkEditor() ? colorsManager.getScheme("Default") : colorsManager.getGlobalScheme();
        if (editorColorsScheme == null) {
            EditorColorsUtil.$$$reportNull$$$0(3);
        }
        return editorColorsScheme;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/EditorColorsUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalOrDefaultColorScheme";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/EditorColorsUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorSchemeForComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorSchemeForPrinting";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalOrDefaultColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

