/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.LambdaInLineVisitor;
import com.intellij.javascript.debugger.breakpoints.JavaScriptLineBreakpointProperties;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.SourceInfo;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"getFirstBreakableElement", "Lcom/intellij/psi/PsiElement;", "function", "Lcom/intellij/lang/javascript/psi/JSFunction;", "getPositionsInLine", "", "Lorg/jetbrains/debugger/SourceInfo;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.debugger"})
public final class PsiVisitorKt {
    private static final PsiElement getFirstBreakableElement(JSFunction function) {
        for (PsiElement psiChild = function.getFirstChild(); psiChild != null; psiChild = psiChild.getNextSibling()) {
            if (!(psiChild instanceof JSExpression)) continue;
            return psiChild;
        }
        return null;
    }

    @NotNull
    public static final List<SourceInfo> getPositionsInLine(@NotNull XLineBreakpoint<?> breakpoint, @NotNull Project project) {
        Integer myOrdinal;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        if (xSourcePosition == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)xSourcePosition, (String)"breakpoint.sourcePosition ?: return emptyList()");
        XSourcePosition position = xSourcePosition;
        List result2 = new ArrayList();
        XBreakpointProperties xBreakpointProperties = breakpoint.getProperties();
        if (!(xBreakpointProperties instanceof JavaScriptLineBreakpointProperties)) {
            xBreakpointProperties = null;
        }
        JavaScriptLineBreakpointProperties javaScriptLineBreakpointProperties = (JavaScriptLineBreakpointProperties)xBreakpointProperties;
        Integer n = myOrdinal = javaScriptLineBreakpointProperties != null ? javaScriptLineBreakpointProperties.lambdaOrdinal : null;
        if (myOrdinal == null || myOrdinal == -1) {
            VirtualFile virtualFile = position.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"position.file");
            result2.add(new SourceInfo(virtualFile, position.getLine(), 0, 0, null, null, 60, null));
        }
        if (myOrdinal == null || myOrdinal >= 0) {
            PsiVisitors.visit((XSourcePosition)position, (Project)project, (PsiVisitors.Visitor)new LambdaInLineVisitor(myOrdinal, result2){
                final /* synthetic */ Integer $myOrdinal;
                final /* synthetic */ List $result;

                protected void process(@NotNull JSFunction element, @NotNull PsiElement firstBreakable) {
                    int n;
                    block5: {
                        block4: {
                            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                            Intrinsics.checkParameterIsNotNull((Object)firstBreakable, (String)"firstBreakable");
                            if (this.$myOrdinal == null) break block4;
                            Integer n2 = this.$myOrdinal;
                            n = this.lambdaOrdinal;
                            if (n2 == null || n2 != n) break block5;
                        }
                        SourceInfo lambdaPosition = this.createSourcePosition(firstBreakable);
                        Integer n3 = this.$myOrdinal;
                        int n4 = this.lambdaOrdinal;
                        if (n3 != null && n3 == n4) {
                            this.isStopped = true;
                        }
                        this.$result.add(lambdaPosition);
                    }
                    n = this.lambdaOrdinal;
                    this.lambdaOrdinal = n + 1;
                }
                {
                    this.$myOrdinal = $captured_local_variable$0;
                    this.$result = $captured_local_variable$1;
                }
            });
        }
        return result2;
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$getFirstBreakableElement(@NotNull JSFunction function) {
        return PsiVisitorKt.getFirstBreakableElement(function);
    }
}

