/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import b.h.la;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.RubyEntity;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public final class RubyDebugTarget
extends RubyEntity {
    private static final Logger d;
    private final Process g;
    private final String f;
    private final int e;
    private final String h;
    private final File i;
    private final boolean b;
    private RubyThread[] c;
    private static final long j;

    public RubyDebugTarget(RubyDebuggerProxy proxy, String host, int port) {
        this(proxy, host, port, null, null, null, true);
    }

    public RubyDebugTarget(RubyDebuggerProxy proxy, String host, int port, Process process, String debuggee, File baseDir) {
        this(proxy, host, port, process, debuggee, baseDir, false);
    }

    private RubyDebugTarget(RubyDebuggerProxy proxy, String host, int port, Process process, String debugeee, File baseDir, boolean remote) {
        super(proxy);
        this.g = process;
        this.f = host;
        this.e = port;
        this.h = debugeee;
        this.i = baseDir;
        this.c = new RubyThread[0];
        this.b = remote;
    }

    public Process getProcess() {
        return this.g;
    }

    public String getHost() {
        return this.f;
    }

    public int getPort() {
        return this.e;
    }

    public String getDebuggedFile() {
        return this.h;
    }

    public File getBaseDir() {
        return this.i;
    }

    public void updateThreads() throws RubyDebuggerException {
        this.updateThreads(this.getProxy().readThreadInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThreads(RubyThreadInfo[] threadInfos) throws RubyDebuggerException {
        long l2 = j ^ 0x519E2B6287EAL;
        d.debug("updating threads");
        RubyThread[] rubyThreadArray = new RubyThread[threadInfos.length];
        int n2 = 0;
        RubyDebugTarget rubyDebugTarget = this;
        synchronized (rubyDebugTarget) {
            for (int i10 = 0; i10 < threadInfos.length; ++i10) {
                while (n2 < this.c.length && threadInfos[i10].getId() != this.c[n2].getId()) {
                    ++n2;
                }
                rubyThreadArray[i10] = n2 == this.c.length ? new RubyThread(this, threadInfos[i10].getId(), threadInfos[i10].getPid()) : this.c[n2];
            }
            this.c = rubyThreadArray;
        }
    }

    public void suspensionOccurred(SuspensionPoint suspensionPoint) {
        long l2 = j ^ 0x6EFD4D91DCFDL;
        try {
            this.updateThreads();
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            if (!this.getProxy().isReady()) {
                throw new RuntimeException("Cannot update threads. Proxy is not ready.", rubyDebuggerException);
            }
            d.debug("Session has finished. Ignoring unsuccessful thread update.");
            return;
        }
        RubyThread rubyThread = this.getThreadById(suspensionPoint.getThreadId());
        if (rubyThread == null) {
            d.warn("Thread with id " + suspensionPoint.getThreadId() + " was not found");
            return;
        }
        rubyThread.suspend(suspensionPoint);
    }

    public synchronized RubyThread getThreadById(int id2) {
        for (RubyThread rubyThread : this.c) {
            if (rubyThread.getId() != id2) continue;
            return rubyThread;
        }
        return null;
    }

    public synchronized RubyThread[] getThreads() {
        RubyThread[] rubyThreadArray = new RubyThread[this.c.length];
        System.arraycopy(this.c, 0, rubyThreadArray, 0, this.c.length);
        return rubyThreadArray;
    }

    public boolean isAvailable() {
        return this.isRemote() || this.isRunning();
    }

    public boolean isRemote() {
        return this.b;
    }

    public boolean isRunning() {
        long l2 = j ^ 0x57676F7CEC5CL;
        assert (!this.isRemote()) : "cannot ask remote process whether it is running";
        return Util.isRunning(this.g);
    }

    public String toString() {
        long l2 = j ^ 0x6613DD24B56CL;
        return "RubyDebugTarget@" + System.identityHashCode(this) + '[' + "baseDir: " + this.getBaseDir() + ", debuggedFile: " + this.getDebuggedFile() + ", port: " + this.getPort() + ']';
    }

    static {
        j = la.a(1153702621123415794L, -2584760443281811979L, MethodHandles.lookup().lookupClass()).a(137851115009194L);
        d = Logger.getInstance(RubyDebugTarget.class);
    }
}

