/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import b.h.la;
import com.intellij.psi.PsiElement;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.motion.RubyMotionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.a;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public class RubyLocalVariableNamingConventionInspection
extends ConventionInspection {
    private static final int c = 1;
    private static final int d = 30;
    private static final long e = la.a(7749171240556550345L, -8731657252962197455L, MethodHandles.lookup().lookupClass()).a(152405403057928L);

    @Override
    protected String getDefaultRegex() {
        return TextUtil.IDENTIFIER_LOWERCASE_PATTERN.pattern();
    }

    @Override
    protected String getMotionDefaultRegex() {
        return RubyMotionUtil.getInstance().getRubyMotionIdentifierRegex();
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 30;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = e ^ 0x31F9017D76B0L;
        if ("Local variable naming convention" == null) {
            RubyLocalVariableNamingConventionInspection.d(0);
        }
        return "Local variable naming convention";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        long l2 = e ^ 0x35F9CA0EAFC7L;
        String string = (String)args[0];
        if (string.length() < this.getMinLength()) {
            if ("Local variable name '#ref' is too short" == null) {
                RubyLocalVariableNamingConventionInspection.d(1);
            }
            return "Local variable name '#ref' is too short";
        }
        if (string.length() > this.getMaxLength()) {
            if ("Local variable name '#ref' is too long" == null) {
                RubyLocalVariableNamingConventionInspection.d(2);
            }
            return "Local variable name '#ref' is too long";
        }
        String string2 = "Local variable name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string2 == null) {
            RubyLocalVariableNamingConventionInspection.d(3);
        }
        return string2;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor(null);
    }

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        long l2 = e ^ 0x46ECC1B7CEBEL;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyLocalVariableNamingConventionInspection";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitRIdentifier(RIdentifier identifier) {
            if (!identifier.isLocalVariable() || !UsageAnalyzer.isFirstDeclaration((RPsiElement)identifier)) {
                return;
            }
            String string = identifier.getName();
            if (RubyLocalVariableNamingConventionInspection.this.isValid(string, (PsiElement)identifier)) {
                return;
            }
            this.registerVariableError(identifier, string);
        }

        /* synthetic */ NamingConventionsVisitor(a x1) {
            this();
        }
    }
}

