/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import b.h.la;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemModificationUtil;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsConfigurableBase;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsetsSettings;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class RubyModuleSdkGemsConfigurable
extends RubySdkGemsConfigurableBase {
    @NotNull
    protected Module myModule;
    @NotNull
    protected final Consumer<? super Sdk> mySetSdkConsumer;
    @NotNull
    protected final Computable<? extends ModifiableRootModel> myModelComputable;
    private static final long D = la.a(-8093746672742344635L, -8860876089161402159L, MethodHandles.lookup().lookupClass()).a(214975556735219L);

    public RubyModuleSdkGemsConfigurable(@NotNull Module module) {
        if (module == null) {
            RubyModuleSdkGemsConfigurable.c(0);
        }
        this(module, (Computable<? extends ModifiableRootModel>)((Computable)() -> {
            if (module == null) {
                RubyModuleSdkGemsConfigurable.c(8);
            }
            return GemModificationUtil.getModuleModifiableModel(module);
        }), (Consumer<? super Sdk>)((Consumer)sdk -> {
            if (module == null) {
                RubyModuleSdkGemsConfigurable.c(7);
            }
            RModuleUtil.getInstance().changeModuleSdk((Sdk)sdk, module);
        }));
    }

    public RubyModuleSdkGemsConfigurable(@NotNull Module module, @NotNull Computable<? extends ModifiableRootModel> modelComputable, @NotNull Consumer<? super Sdk> setSdkConsumer) {
        if (module == null) {
            RubyModuleSdkGemsConfigurable.c(1);
        }
        if (modelComputable == null) {
            RubyModuleSdkGemsConfigurable.c(2);
        }
        if (setSdkConsumer == null) {
            RubyModuleSdkGemsConfigurable.c(3);
        }
        this.mySetSdkConsumer = setSdkConsumer;
        this.myModule = module;
        this.myModelComputable = modelComputable;
        this.init();
    }

    @Override
    @NotNull
    protected Project getProject() {
        Project project = this.myModule.getProject();
        if (project == null) {
            RubyModuleSdkGemsConfigurable.c(4);
        }
        return project;
    }

    @Override
    protected MultiMap<String, String> getSettingsMap() {
        return RubySdkGemsetsSettings.getInstance().getOrCreateModuleSdkGemsetsMap(this.myModule).copy();
    }

    @Override
    void saveSettingsMap(@NotNull MultiMap<String, String> map) {
        if (map == null) {
            RubyModuleSdkGemsConfigurable.c(5);
        }
        RubySdkGemsetsSettings.getInstance().putModuleSdkGemsetsMap(this.myModule, map);
    }

    @Override
    @Nullable
    protected Sdk getSdk() {
        return ModuleRootManager.getInstance((Module)this.myModule).getSdk();
    }

    @Override
    @NotNull
    protected String getErrorMessage() {
        long l2 = D ^ 0x606AC679737BL;
        String string = RBundle.message((String)"ruby.ide.sdk.configurable.no.module.sdk.marked", (Object[])new Object[]{this.myModule.getName()});
        if (string == null) {
            RubyModuleSdkGemsConfigurable.c(6);
        }
        return string;
    }

    @Override
    public boolean isModified() {
        return super.isModified() || !RubySdkGemsetsSettings.getInstance().getOrCreateModuleSdkGemsetsMap(this.myModule).equals((Object)this.mySdkGemsetsMap);
    }

    @Override
    protected void doApply() throws ConfigurationException {
        long l2 = D ^ 0x788650F9DA7CL;
        super.doApply();
        Sdk sdk = this.getCheckedSdk();
        if (sdk == null) {
            return;
        }
        if (this.myIsDisposed) {
            ModuleRootModificationUtil.updateModel((Module)this.myModule, modifiableRootModel -> modifiableRootModel.setSdk(sdk));
        } else {
            this.mySetSdkConsumer.consume((Object)sdk);
        }
        RubySdkGemsetsSettings.getInstance().putModuleSdkGemsetsMap(this.myModule, (MultiMap<String, String>)this.mySdkGemsetsMap.copy());
        Collection collection = this.mySdkGemsetsMap.get((Object)sdk.getHomePath());
        if (RbenvGemsetManager.isRbenvSdk(sdk)) {
            RbenvGemsetManager.applyRbenvGemsetsToConfig(this.myModule, collection);
        }
        Application application = ApplicationManager.getApplication();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GemManager.getInstance().refresh(sdk), RBundle.message((String)"module.settings.refreshing.sdk"), true, this.getProject());
        application.runWriteAction(() -> {
            ModifiableRootModel modifiableRootModel = (ModifiableRootModel)this.myModelComputable.compute();
            if (GemManager.updateGemset(modifiableRootModel, sdk)) {
                GemModificationUtil.commitModuleModifiableModel(modifiableRootModel);
            } else {
                GemModificationUtil.disposeModuleModifiableModel(modifiableRootModel);
            }
            GemManager.getInstance().flushLibrariesIfNeeded(this.getProject());
        });
    }

    @Override
    @Nullable
    protected Sdk getPreferableRVMSdk(@Nullable Sdk selectedSdk) {
        if (RVMSupportUtil.isLocalRootRVMSdk(selectedSdk)) {
            return selectedSdk;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(this.myModule);
        if (RVMSupportUtil.isLocalRootRVMSdk(sdk)) {
            return sdk;
        }
        return super.getPreferableRVMSdk(selectedSdk);
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = D ^ 0x70246688A33FL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelComputable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setSdkConsumer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubyModuleSdkGemsConfigurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubyModuleSdkGemsConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveSettingsMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

