/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import b.h.la;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.reference.SoftReference;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageSuitesBundle {
    private final CoverageSuite[] e;
    private final CoverageEngine b;
    private Set<Module> a;
    private CachedValue<GlobalSearchScope> c;
    private SoftReference<ProjectData> d = new SoftReference(null);
    private static final Logger f;
    private static final long g;

    public CoverageSuitesBundle(CoverageSuite suite) {
        this(new CoverageSuite[]{suite});
    }

    public CoverageSuitesBundle(CoverageSuite[] suites) {
        this.e = suites;
        f.assertTrue(this.e.length > 0);
        this.b = this.e[0].getCoverageEngine();
        for (CoverageSuite coverageSuite : suites) {
            CoverageEngine coverageEngine = coverageSuite.getCoverageEngine();
            f.assertTrue(Comparing.equal((Object)coverageEngine, (Object)this.b));
        }
    }

    public boolean isValid() {
        for (CoverageSuite coverageSuite : this.e) {
            if (coverageSuite.isValid()) continue;
            return false;
        }
        return true;
    }

    public Project getProject() {
        return this.e[0].getProject();
    }

    public long getLastCoverageTimeStamp() {
        long l2 = 0L;
        for (CoverageSuite coverageSuite : this.e) {
            l2 = Math.max(l2, coverageSuite.getLastCoverageTimeStamp());
        }
        return l2;
    }

    public boolean isCoverageByTestApplicable() {
        for (CoverageSuite coverageSuite : this.e) {
            if (!coverageSuite.isCoverageByTestApplicable()) continue;
            return true;
        }
        return false;
    }

    public boolean isCoverageByTestEnabled() {
        for (CoverageSuite coverageSuite : this.e) {
            if (!coverageSuite.isCoverageByTestEnabled()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ProjectData getCoverageData() {
        ProjectData projectData = (ProjectData)this.d.get();
        if (projectData != null) {
            return projectData;
        }
        ProjectData projectData2 = new ProjectData();
        for (CoverageSuite coverageSuite : this.e) {
            ProjectData projectData3 = coverageSuite.getCoverageData(null);
            if (projectData3 == null) continue;
            projectData2.merge((CoverageData)projectData3);
        }
        this.d = new SoftReference((Object)projectData2);
        return projectData2;
    }

    public boolean isTrackTestFolders() {
        for (CoverageSuite coverageSuite : this.e) {
            if (!coverageSuite.isTrackTestFolders()) continue;
            return true;
        }
        return false;
    }

    public boolean isTracingEnabled() {
        for (CoverageSuite coverageSuite : this.e) {
            if (!coverageSuite.isTracingEnabled()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public CoverageEngine getCoverageEngine() {
        CoverageEngine coverageEngine = this.b;
        if (coverageEngine == null) {
            CoverageSuitesBundle.c(0);
        }
        return coverageEngine;
    }

    public LineMarkerRendererWithErrorStripe getLineMarkerRenderer(int lineNumber, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<Integer, Integer> newToOldConverter, Function<Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        if (coverageSuite == null) {
            CoverageSuitesBundle.c(1);
        }
        return this.b.getLineMarkerRenderer(lineNumber, className, lines, coverageByTestApplicable, coverageSuite, newToOldConverter, oldToNewConverter, subCoverageActive);
    }

    public CoverageAnnotator getAnnotator(Project project) {
        return this.b.getCoverageAnnotator(project);
    }

    @NotNull
    public CoverageSuite[] getSuites() {
        if (this.e == null) {
            CoverageSuitesBundle.c(2);
        }
        return this.e;
    }

    public boolean contains(CoverageSuite suite) {
        return ArrayUtilRt.find((Object[])this.e, (Object)suite) > -1;
    }

    public void setCoverageData(ProjectData projectData) {
        this.d = new SoftReference((Object)projectData);
    }

    public void restoreCoverageData() {
        this.d = new SoftReference(null);
        for (CoverageSuite coverageSuite : this.e) {
            coverageSuite.restoreCoverageData();
        }
    }

    public String getPresentableName() {
        long l2 = g ^ 0x3B5F8DD324A7L;
        return StringUtil.join((Object[])this.e, coverageSuite -> coverageSuite.getPresentableName(), (String)", ");
    }

    public boolean isModuleChecked(Module module) {
        return this.a != null && this.a.contains(module);
    }

    public void checkModule(Module module) {
        if (this.a == null) {
            this.a = new HashSet<Module>();
        }
        this.a.add(module);
    }

    @Nullable
    public RunConfigurationBase getRunConfiguration() {
        for (CoverageSuite coverageSuite : this.e) {
            RunConfigurationBase runConfigurationBase;
            if (!(coverageSuite instanceof BaseCoverageSuite) || (runConfigurationBase = ((BaseCoverageSuite)coverageSuite).getConfiguration()) == null) continue;
            return runConfigurationBase;
        }
        return null;
    }

    public GlobalSearchScope getSearchScope(Project project) {
        if (this.c == null) {
            this.c = CachedValuesManager.getManager((Project)project).createCachedValue(() -> new CachedValueProvider.Result((Object)this.b(project), new Object[]{ProjectRootModificationTracker.getInstance((Project)project)}), false);
        }
        return (GlobalSearchScope)this.c.getValue();
    }

    private GlobalSearchScope b(Project project) {
        Object[] objectArray = (Module[])Arrays.stream(this.e).filter(coverageSuite -> coverageSuite instanceof BaseCoverageSuite).map(coverageSuite -> ((BaseCoverageSuite)coverageSuite).getConfiguration()).filter(runConfigurationBase -> runConfigurationBase instanceof ModuleBasedConfiguration).map(runConfigurationBase -> ((ModuleBasedConfiguration)runConfigurationBase).getConfigurationModule().getModule()).toArray(Module[]::new);
        if (objectArray.length == 0 || ArrayUtil.find((Object[])objectArray, null) > -1) {
            return this.isTrackTestFolders() ? GlobalSearchScope.projectScope((Project)project) : GlobalSearchScopesCore.projectProductionScope((Project)project);
        }
        return GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])Arrays.stream(objectArray).map(module -> GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)this.isTrackTestFolders())).toArray(GlobalSearchScope[]::new)));
    }

    static {
        g = la.a(-9012921398127852629L, 7482722002537637212L, MethodHandles.lookup().lookupClass()).a(175153882525483L);
        f = Logger.getInstance(CoverageSuitesBundle.class);
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x4CFA009D90BL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageSuitesBundle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageEngine";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageSuitesBundle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

