/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.editor.JSEditorOptions;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text) {
        if (!JSEditorOptions.getInstance().ESCAPE_PASTED_TEXT) {
            return null;
        }
        if (!file2.isPhysical() || startOffsets.length > 1 || endOffsets.length > 1) {
            return null;
        }
        int selectionStart = startOffsets[0];
        int selectionEnd = endOffsets[0];
        JSLiteralExpression literalExpression = JSStringLiteralCopyPasteProcessor.getSingleElementFromSelectionOrNull(file2, selectionStart, selectionEnd);
        if (literalExpression == null) {
            return null;
        }
        return JSStringUtil.unescapeSimpleStringChars(text);
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file2, Editor editor, String text, RawText rawText) {
        int selectionEnd;
        if (!JSEditorOptions.getInstance().ESCAPE_PASTED_TEXT) {
            String string = text;
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (!file2.isPhysical()) {
            String string = text;
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        JSLiteralExpression literalExpression = JSStringLiteralCopyPasteProcessor.getSingleElementFromSelectionOrNull(file2, selectionStart, selectionEnd = selectionModel.getSelectionEnd());
        if (literalExpression == null) {
            String string = text;
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        boolean escapeWhitespace = !(literalExpression instanceof JSStringTemplateExpression) && !JSStringLiteralCopyPasteProcessor.isCoffeeScript(literalExpression);
        boolean splitAtNewLine = (rawText == null || rawText.rawText == null) && !(literalExpression instanceof JSStringTemplateExpression) && !JSStringLiteralCopyPasteProcessor.isCoffeeScript(literalExpression);
        String string = JSStringLiteralCopyPasteProcessor.getPastedText(text, literalExpression, splitAtNewLine, escapeWhitespace);
        if (string == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String getPastedText(String text, JSLiteralExpression literalExpression, boolean splitAtNewLine, boolean escapeWhitespace) {
        char quote = literalExpression.getText().charAt(0);
        if (!splitAtNewLine) {
            StringBuilder buffer = new StringBuilder();
            JSStringUtil.escapeSimpleStringChars(text, quote, escapeWhitespace, escapeWhitespace, false, buffer);
            String string = buffer.toString();
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder buffer = new StringBuilder(text.length());
        String lineTail = JSStringLiteralCopyPasteProcessor.getTail(quote, (PsiElement)literalExpression);
        String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            JSStringUtil.escapeSimpleStringChars(line, quote, escapeWhitespace, escapeWhitespace, false, buffer);
            if (i == lines.length - 1) continue;
            buffer.append(lineTail);
        }
        if (text.endsWith("\n")) {
            buffer.append("\\n");
        }
        String string = buffer.toString();
        if (string == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private static JSLiteralExpression getSingleElementFromSelectionOrNull(@NotNull PsiFile file2, int start, int end) {
        PsiElement element;
        JSLiteralExpression literalExpression;
        if (file2 == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(6);
        }
        if ((literalExpression = (JSLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)(element = file2.findElementAt(start)), JSLiteralExpression.class)) == null || !literalExpression.isQuotedLiteral() || start <= literalExpression.getTextRange().getStartOffset() || end >= literalExpression.getTextRange().getEndOffset()) {
            return null;
        }
        if (literalExpression instanceof JSStringTemplateExpression) {
            JSStringTemplateExpression templateExpression = (JSStringTemplateExpression)literalExpression;
            TextRange[] ranges = templateExpression.getStringRanges();
            boolean containedInSingleRange = ranges.length == 0 || Arrays.stream(ranges).map(range -> range.shiftRight(templateExpression.getTextRange().getStartOffset())).anyMatch(range -> range.containsRange(start, end));
            return containedInSingleRange ? literalExpression : null;
        }
        return literalExpression;
    }

    @NotNull
    private static String getTail(char quote, @NotNull PsiElement context) {
        if (context == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(7);
        }
        CommonCodeStyleSettings commonSettings = CodeStyle.getLanguageSettings((PsiFile)context.getContainingFile(), (Language)context.getLanguage());
        String string = "\\n" + quote + (commonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? "\n+" : "+\n") + quote;
        if (string == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static boolean isCoffeeScript(JSLiteralExpression literalExpression) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)literalExpression);
        return holder != null && holder.isCoffeeScript;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPastedText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTail";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSingleElementFromSelectionOrNull";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTail";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

