/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.typescript.completion.ItemWithAction;
import com.intellij.lang.typescript.completion.TypeScriptSmartCompletionContributor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MemberAccessCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        JSClass containingClass;
        PsiElement parent;
        if (parameters == null) {
            ES6MemberAccessCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            ES6MemberAccessCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!((parent = parameters.getPosition().getParent()) instanceof JSReferenceExpression) || ((JSReferenceExpression)parent).getQualifier() != null || JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)parent)) {
            return;
        }
        JSFunction parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas(parent);
        String ownerPropertyName = null;
        if (parentFunction == null) {
            JSField field = (JSField)PsiTreeUtil.getParentOfType((PsiElement)parent, JSField.class);
            parentFunction = field;
            if (parentFunction == null) {
                return;
            }
            ownerPropertyName = field.getName();
        }
        if ((containingClass = JSUtils.getMemberContainingClass((PsiElement)parentFunction)) == null || DialectDetector.isActionScript((PsiElement)containingClass)) {
            return;
        }
        PsiElement context = parent.getParent();
        if (context instanceof ES6Property && ((ES6Property)context).isShorthanded()) {
            return;
        }
        JSContext jsContext = parentFunction.getJSContext();
        HashMap forCompletion = ContainerUtil.newHashMap();
        HashMap specialForCompletion = ContainerUtil.newHashMap();
        HashMap typeSubstitutors = ContainerUtil.newHashMap();
        if (!JSResolveUtil.ownerHasExplicitThisParameter((JSExpression)parent)) {
            ES6MemberAccessCompletionContributor.addMembersFromHierarchy(containingClass, context, jsContext, forCompletion, specialForCompletion, typeSubstitutors);
        } else {
            JSType type;
            JSFunction thisScope = JSPsiImplUtils.getParentFunctionThroughLambdas(parent);
            if (thisScope != null && (type = TypeScriptPsiUtil.getThisParameterType(thisScope)) != null) {
                JSRecordType recordType = type.asRecordType();
                for (JSRecordType.PropertySignature member : recordType.getProperties()) {
                    PsiElement singleElement = member.getMemberSource().getSingleElement();
                    if (!(singleElement instanceof JSPsiElementBase)) continue;
                    forCompletion.put(member.getMemberName(), (JSPsiElementBase)singleElement);
                }
            }
        }
        String finalOwnerPropertyName = ownerPropertyName;
        forCompletion.values().forEach(el -> {
            LookupElement element;
            if (result2 == null) {
                ES6MemberAccessCompletionContributor.$$$reportNull$$$0(6);
            }
            if ((element = ES6MemberAccessCompletionContributor.createLookupElement(containingClass, el, jsContext, finalOwnerPropertyName, JSUtils.isPrivateSharpItem((PsiElement)el), false, null, null)) != null) {
                result2.consume(element);
            }
        });
        specialForCompletion.forEach((key, value) -> {
            LookupElement element;
            if (result2 == null) {
                ES6MemberAccessCompletionContributor.$$$reportNull$$$0(5);
            }
            if ((element = ES6MemberAccessCompletionContributor.createLookupElement(containingClass, (JSPsiElementBase)value.first, jsContext, finalOwnerPropertyName, JSUtils.isPrivateSharpItem((PsiElement)value.first), true, key, (Runnable)value.second)) != null) {
                result2.consume(element);
            }
        });
    }

    private static void addMembersFromHierarchy(final JSClass<?> containingClass, final PsiElement context, final JSContext jsContext, final HashMap<String, JSPsiElementBase> forCompletion, final HashMap<String, Pair<JSPsiElementBase, Runnable>> specialForCompletion, final Map<JSClass, JSTypeSubstitutor> typeSubstitutors) {
        final GlobalSearchScope resolveScope = JSResolveUtil.getResolveScope(context);
        TypeScriptUtil.JSClassHierarchyProcessor processor = new TypeScriptUtil.JSClassHierarchyProcessor(){

            @Override
            public boolean process(@NotNull JSClass<?> aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                String qualifiedName;
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (typeSubstitutor == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (JSElement element : aClass.getMembers()) {
                    ItemWithAction specialNameForCompletion;
                    JSAttributeList.AccessType type;
                    if (!(element instanceof JSPsiElementBase) || (type = ((JSPsiElementBase)element).getAccessType()) == JSAttributeList.AccessType.PRIVATE && !aClass.isEquivalentTo((PsiElement)containingClass) || jsContext == JSContext.STATIC && (((JSPsiElementBase)element).getJSContext() == JSContext.INSTANCE || element instanceof JSParameter)) continue;
                    String name = element.getName();
                    if (!StringUtil.isEmpty((String)name)) {
                        if (forCompletion.containsKey(name)) continue;
                        forCompletion.put(name, (JSPsiElementBase)element);
                        continue;
                    }
                    if (!(element instanceof JSComputedPropertyNameOwner) || (specialNameForCompletion = TypeScriptSmartCompletionContributor.getSpecialItemForCompletion((JSComputedPropertyNameOwner)element, context)) == null || specialForCompletion.containsKey(specialNameForCompletion.item)) continue;
                    specialForCompletion.put(specialNameForCompletion.item, Pair.create((Object)((JSPsiElementBase)element), (Object)specialNameForCompletion.importAction));
                }
                if (jsContext == JSContext.STATIC && !aClass.isInterface() && !forCompletion.containsKey("prototype")) {
                    forCompletion.put("prototype", JSClassUtils.getImplicitPrototypeProperty(aClass));
                }
                if (jsContext == JSContext.INSTANCE && DialectDetector.isJavaScript(aClass) && (qualifiedName = aClass.getQualifiedName()) != null) {
                    Collection<JSPsiElementBase> members = JSClassResolver.getInstance().findNamespaceMembers(qualifiedName, resolveScope);
                    for (JSPsiElementBase member : members) {
                        String memberName = member.getName();
                        if ("constructor".equals(memberName) || "prototype".equals(memberName)) continue;
                        forCompletion.putIfAbsent(memberName, member);
                    }
                }
                typeSubstitutors.put(aClass, typeSubstitutor);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "aClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeSubstitutor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSClassUtils.processClassesInHierarchy(containingClass, true, processor);
    }

    @Nullable
    private static LookupElement createLookupElement(@NotNull JSClass<?> containingClass, @NotNull JSPsiElementBase el, JSContext ownContext, String ownerPropertyName, boolean isSharpAccessItem, boolean noEscaping, @Nullable String altName, @Nullable Runnable postProcess) {
        boolean needClosingBracket;
        String qualifier;
        String name;
        if (containingClass == null) {
            ES6MemberAccessCompletionContributor.$$$reportNull$$$0(2);
        }
        if (el == null) {
            ES6MemberAccessCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((name = el.getName()) == null) {
            name = altName;
        }
        assert (name != null);
        if (ownerPropertyName != null && ownerPropertyName.equals(name)) {
            return null;
        }
        boolean needThis = true;
        boolean hasExoticName = false;
        boolean hasBrackets = false;
        if (!JSNamesValidation.isUnqualifiedType(name)) {
            if (!noEscaping) {
                name = JSSymbolUtil.handleSpecialPropertyNames(name, JSCodeStyleSettings.getQuoteChar(containingClass));
            }
            hasExoticName = true;
            if (name.length() > 0 && name.charAt(0) == '[') {
                hasBrackets = true;
            }
        }
        if (el.getJSContext() == JSContext.STATIC && (ownContext != JSContext.STATIC || ownerPropertyName != null)) {
            String className = containingClass.getName();
            if (className == null) {
                return null;
            }
            qualifier = className;
        } else {
            qualifier = "this";
            boolean bl = needThis = !name.equals("constructor");
        }
        if (!hasBrackets) {
            qualifier = qualifier + (isSharpAccessItem ? ".#" : (hasExoticName ? "[" : "."));
        }
        boolean bl = needClosingBracket = hasExoticName && !hasBrackets;
        if (!needThis) {
            return null;
        }
        LookupElementBuilder baseElementWithThis = JSLookupUtilImpl.createLookupElement((PsiElement)el, qualifier + name + (needClosingBracket ? "]" : ""));
        return PrioritizedLookupElement.withPriority((LookupElement)baseElementWithThis.withInsertHandler((handleInsert, item) -> {
            if (el == null) {
                ES6MemberAccessCompletionContributor.$$$reportNull$$$0(4);
            }
            JSInsertHandler.insertBracesIfNeed(handleInsert, (PsiElement)el, null);
            if (postProcess != null) {
                postProcess.run();
            }
        }).withLookupString(name), (double)JSLookupPriority.RELEVANT_SMARTNESS_PRIORITY.getPriorityValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createLookupElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createLookupElement$2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$fillCompletionVariants$1";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$fillCompletionVariants$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

