/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import org.jetbrains.annotations.NotNull;

public class BackspaceHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public BackspaceHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
        LookupImpl lookup;
        if (editor == null) {
            BackspaceHandler.$$$reportNull$$$0(0);
        }
        if ((lookup = (LookupImpl)LookupManager.getActiveLookup(editor)) == null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        int hideOffset = lookup.getLookupStart();
        int originalStart = lookup.getLookupOriginalStart();
        if (originalStart >= 0 && originalStart <= hideOffset) {
            hideOffset = originalStart - 1;
        }
        BackspaceHandler.truncatePrefix(dataContext, lookup, this.myOriginalHandler, hideOffset, caret);
    }

    static void truncatePrefix(DataContext dataContext, LookupImpl lookup, EditorActionHandler handler2, int hideOffset, Caret caret) {
        Editor editor = lookup.getEditor();
        if (!lookup.performGuardedChange(() -> handler2.execute(editor, caret, dataContext))) {
            return;
        }
        CompletionProgressIndicator process2 = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        if (lookup.truncatePrefix(process2 == null || !process2.isAutopopupCompletion())) {
            return;
        }
        if (process2 != null) {
            if (hideOffset < editor.getCaretModel().getOffset()) {
                process2.scheduleRestart();
                return;
            }
            process2.prefixUpdated();
        }
        lookup.hideLookup(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/lookup/impl/BackspaceHandler", "doExecute"));
    }
}

