/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.google.common.collect.Iterables;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeArgument;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeConstraint;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeRoutine;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.schemaEditor.model.DeTrigger;
import com.intellij.database.schemaEditor.model.DeView;
import com.intellij.database.schemaEditor.model.DeWrapper;
import com.intellij.database.schemaEditor.model.DeWrapperImpl;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DasSchemaExporters {
    public static SchemaExporters createDefaultExporters() {
        SchemaExporters dasSchemaExporter = new SchemaExporters();
        dasSchemaExporter.add(new DeObjectCloner());
        dasSchemaExporter.add(new DeTableExporter());
        dasSchemaExporter.add(new DeColumnExporter());
        dasSchemaExporter.add(new DeIndexExporter());
        dasSchemaExporter.add(new DeForeignKeyExporter());
        dasSchemaExporter.add(new DeTableKeyExporter());
        dasSchemaExporter.add(new DeNamespaceExporter());
        dasSchemaExporter.add(new DeRoutineExporter());
        dasSchemaExporter.add(new DeArgumentExporter());
        dasSchemaExporter.add(new DeViewExporter());
        dasSchemaExporter.add(new DeMatViewExporter());
        dasSchemaExporter.add(new DeObjectTypeExporter());
        dasSchemaExporter.add(new DePackageExporter());
        dasSchemaExporter.add(new DeBodyExporter());
        dasSchemaExporter.add(new DeTriggerExporter());
        dasSchemaExporter.add(new DeSequenceExporter());
        return dasSchemaExporter;
    }

    protected static class DeSequenceExporter
    extends DeGenericExporter {
        public DeSequenceExporter() {
            super(ObjectKind.SEQUENCE);
        }
    }

    protected static class DeMatViewExporter
    extends DeGenericExporter {
        public DeMatViewExporter() {
            super(ObjectKind.MAT_VIEW);
        }
    }

    protected static class DeBodyExporter
    extends DeGenericExporter {
        public DeBodyExporter() {
            super(ObjectKind.BODY);
        }
    }

    protected static class DePackageExporter
    extends DeGenericExporter {
        public DePackageExporter() {
            super(ObjectKind.PACKAGE);
        }
    }

    protected static class DeObjectTypeExporter
    extends DeGenericExporter {
        public DeObjectTypeExporter() {
            super(ObjectKind.OBJECT_TYPE);
        }
    }

    protected static class DeGenericExporter
    extends DeObjectExporter<DeWrapperImpl<BasicElement>, BasicElement, BasicModElement> {
        public DeGenericExporter(@NotNull ObjectKind kindFilter) {
            if (kindFilter == null) {
                DeGenericExporter.$$$reportNull$$$0(0);
            }
            super(DeWrapperImpl.class, BasicElement.class, kindFilter);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeWrapperImpl<BasicElement> to, @NotNull BasicElement from) {
            if (helper == null) {
                DeGenericExporter.$$$reportNull$$$0(1);
            }
            if (to == null) {
                DeGenericExporter.$$$reportNull$$$0(2);
            }
            if (from == null) {
                DeGenericExporter.$$$reportNull$$$0(3);
            }
            super.lightExport(helper, to, from);
            to.parent = helper.export(from.getDasParent(), false);
            if (to.parent == null) {
                to.model.addRoot(to);
            }
        }

        @Override
        @NotNull
        public DeWrapperImpl<BasicElement> create(@NotNull SchemaExportHelper helper, @NotNull BasicElement from) {
            if (helper == null) {
                DeGenericExporter.$$$reportNull$$$0(4);
            }
            if (from == null) {
                DeGenericExporter.$$$reportNull$$$0(5);
            }
            DeWrapperImpl<BasicElement> deWrapperImpl = new DeWrapperImpl<BasicElement>(DeGenericExporter.getName(helper, from), helper.getModel(), null);
            if (deWrapperImpl == null) {
                DeGenericExporter.$$$reportNull$$$0(6);
            }
            return deWrapperImpl;
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull DeWrapperImpl<BasicElement> to, @NotNull BasicElement from) {
            if (helper == null) {
                DeGenericExporter.$$$reportNull$$$0(7);
            }
            if (to == null) {
                DeGenericExporter.$$$reportNull$$$0(8);
            }
            if (from == null) {
                DeGenericExporter.$$$reportNull$$$0(9);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kindFilter";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 3: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "exportChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeNamespaceExporter
    extends DeObjectExporter<DeNamespace, BasicNamespace, BasicModNamespace> {
        public DeNamespaceExporter() {
            super(DeNamespace.class, BasicNamespace.class, null);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeNamespace to, @NotNull BasicNamespace from) {
            if (helper == null) {
                DeNamespaceExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeNamespaceExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeNamespaceExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            BasicNamespace parent2 = (BasicNamespace)ObjectUtils.tryCast((Object)from.getDasParent(), BasicNamespace.class);
            if (parent2 instanceof BasicRoot) {
                parent2 = null;
            }
            to.parent = (DeNamespace)helper.export(parent2, false);
            if (to.parent == null) {
                to.model.addRoot(to);
            }
        }

        @Override
        public boolean canExport(@NotNull BasicNamespace object) {
            if (object == null) {
                DeNamespaceExporter.$$$reportNull$$$0(3);
            }
            return super.canExport(object) && !(object instanceof BasicRoot);
        }

        @Override
        @NotNull
        public DeNamespace create(@NotNull SchemaExportHelper helper, @NotNull BasicNamespace from) {
            if (helper == null) {
                DeNamespaceExporter.$$$reportNull$$$0(4);
            }
            if (from == null) {
                DeNamespaceExporter.$$$reportNull$$$0(5);
            }
            DeNamespace deNamespace = new DeNamespace(DeNamespaceExporter.getName(helper, from), from.getKind(), helper.getModel());
            if (deNamespace == null) {
                DeNamespaceExporter.$$$reportNull$$$0(6);
            }
            return deNamespace;
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull DeNamespace to, @NotNull BasicNamespace from) {
            if (helper == null) {
                DeNamespaceExporter.$$$reportNull$$$0(7);
            }
            if (to == null) {
                DeNamespaceExporter.$$$reportNull$$$0(8);
            }
            if (from == null) {
                DeNamespaceExporter.$$$reportNull$$$0(9);
            }
            for (BasicElement object : from.getDasChildren(null)) {
                if (!helper.canExport(object)) continue;
                to.children.add((DeObject)helper.export(object, true));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canExport";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "exportChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeArgumentExporter
    extends DeObjectExporter<DeArgument, BasicArgument, BasicModArgument> {
        public DeArgumentExporter() {
            super(DeArgument.class, BasicArgument.class, ObjectKind.ARGUMENT);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeArgument to, @NotNull BasicArgument from) {
            if (helper == null) {
                DeArgumentExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeArgumentExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeArgumentExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            to.routine = (DeRoutine)helper.export(from.getDasParent(), false);
        }

        @Override
        @NotNull
        public DeArgument create(@NotNull SchemaExportHelper helper, @NotNull BasicArgument from) {
            if (helper == null) {
                DeArgumentExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeArgumentExporter.$$$reportNull$$$0(4);
            }
            DeArgument deArgument = new DeArgument(DeArgumentExporter.getName(helper, from), helper.getModel(), null);
            if (deArgument == null) {
                DeArgumentExporter.$$$reportNull$$$0(5);
            }
            return deArgument;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeArgumentExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeArgumentExporter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeTriggerExporter
    extends DeDumbExporter<DeTrigger, BasicTrigger, BasicModTrigger> {
        public DeTriggerExporter() {
            super(DeTrigger.class, BasicTrigger.class, ObjectKind.TRIGGER);
        }

        @Override
        @NotNull
        public DeTrigger create(@NotNull SchemaExportHelper helper, @NotNull BasicTrigger from) {
            if (helper == null) {
                DeTriggerExporter.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DeTriggerExporter.$$$reportNull$$$0(1);
            }
            DeTrigger deTrigger = new DeTrigger(DeTriggerExporter.getName(helper, from), helper.getModel(), null);
            if (deTrigger == null) {
                DeTriggerExporter.$$$reportNull$$$0(2);
            }
            return deTrigger;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTriggerExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTriggerExporter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeViewExporter
    extends DeDumbExporter<DeView, BasicView, BasicModView> {
        public DeViewExporter() {
            super(DeView.class, BasicView.class, ObjectKind.VIEW);
        }

        @Override
        @NotNull
        public DeView create(@NotNull SchemaExportHelper helper, @NotNull BasicView from) {
            if (helper == null) {
                DeViewExporter.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DeViewExporter.$$$reportNull$$$0(1);
            }
            DeView deView = new DeView(DeViewExporter.getName(helper, from), helper.getModel(), null);
            if (deView == null) {
                DeViewExporter.$$$reportNull$$$0(2);
            }
            return deView;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeViewExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeViewExporter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeRoutineExporter
    extends DeDumbExporter<DeRoutine, BasicRoutine, BasicModRoutine> {
        public DeRoutineExporter() {
            super(DeRoutine.class, BasicRoutine.class, ObjectKind.ROUTINE);
        }

        @Override
        @NotNull
        public DeRoutine create(@NotNull SchemaExportHelper helper, @NotNull BasicRoutine from) {
            if (helper == null) {
                DeRoutineExporter.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DeRoutineExporter.$$$reportNull$$$0(1);
            }
            DeRoutine deRoutine = new DeRoutine(DeRoutineExporter.getName(helper, from), helper.getModel(), null);
            if (deRoutine == null) {
                DeRoutineExporter.$$$reportNull$$$0(2);
            }
            return deRoutine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeRoutineExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeRoutineExporter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class DeDumbExporter<De extends DeWrapper, Das extends BasicElement, MDas extends BasicModElement>
    extends DeObjectExporter<De, Das, MDas> {
        public DeDumbExporter(@NotNull Class<De> exportedClass, @NotNull Class<Das> exportableClass, @Nullable ObjectKind kindFilter) {
            if (exportedClass == null) {
                DeDumbExporter.$$$reportNull$$$0(0);
            }
            if (exportableClass == null) {
                DeDumbExporter.$$$reportNull$$$0(1);
            }
            super(exportedClass, exportableClass, kindFilter);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeDumbExporter.$$$reportNull$$$0(2);
            }
            if (to == null) {
                DeDumbExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeDumbExporter.$$$reportNull$$$0(4);
            }
            super.lightExport(helper, to, from);
            ((DeWrapper)to).parent = helper.export(from.getDasParent(), false);
            if (((DeWrapper)to).parent == null) {
                ((DeWrapper)to).model.addRoot((DeObject)to);
            }
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeDumbExporter.$$$reportNull$$$0(5);
            }
            if (to == null) {
                DeDumbExporter.$$$reportNull$$$0(6);
            }
            if (from == null) {
                DeDumbExporter.$$$reportNull$$$0(7);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportedClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportableClass";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeDumbExporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lightExport";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exportChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DeTableKeyExporter
    extends DeTableChildExporter<DeTableKey, BasicKey, BasicModKey> {
        public DeTableKeyExporter() {
            super(DeTableKey.class, BasicKey.class, ObjectKind.KEY);
        }

        @Override
        public void applyImpl(SchemaApplyHelper helper, @NotNull DeTableKey from, @NotNull BasicModKey to) {
            if (from == null) {
                DeTableKeyExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeTableKeyExporter.$$$reportNull$$$0(1);
            }
            super.applyImpl(helper, from, to);
            ArrayList cols = ContainerUtil.newArrayList();
            for (DeColumn column2 : from.columns) {
                BasicModElement col = helper.apply(column2);
                cols.add(this.getName(col, column2));
            }
            to.setColNames(cols);
            to.setPrimary(from.isPrimary());
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeTableKey to, @NotNull BasicKey from) {
            if (helper == null) {
                DeTableKeyExporter.$$$reportNull$$$0(2);
            }
            if (to == null) {
                DeTableKeyExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeTableKeyExporter.$$$reportNull$$$0(4);
            }
            super.lightExport(helper, to, from);
            if (from.isPrimary()) {
                DeTable table = to.table;
                if (table.keys.getPrimaryKey() != to) {
                    if (table.keys.getPrimaryKey() != null) {
                        this.myLogger.warn("Already have primary key");
                    }
                    table.keys.setPrimaryKey(to);
                }
            }
            to.columns.addAll(DeTableKeyExporter.getColumnsOrStubs(helper, to.table, from.getColumnsRef()));
        }

        @Override
        @NotNull
        public DeTableKey create(@NotNull SchemaExportHelper helper, @NotNull BasicKey from) {
            if (helper == null) {
                DeTableKeyExporter.$$$reportNull$$$0(5);
            }
            if (from == null) {
                DeTableKeyExporter.$$$reportNull$$$0(6);
            }
            DeTableKey deTableKey = new DeTableKey(DeTableKeyExporter.getName(helper, from), DeTable.STUB, helper.getModel());
            if (deTableKey == null) {
                DeTableKeyExporter.$$$reportNull$$$0(7);
            }
            return deTableKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableKeyExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableKeyExporter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyImpl";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeForeignKeyExporter
    extends DeTableChildExporter<DeForeignKey, BasicForeignKey, BasicModForeignKey> {
        public DeForeignKeyExporter() {
            super(DeForeignKey.class, BasicForeignKey.class, ObjectKind.FOREIGN_KEY);
        }

        @Override
        protected void applyImpl(SchemaApplyHelper helper, DeForeignKey from, BasicModForeignKey to) {
            BasicSchema schema;
            super.applyImpl(helper, from, to);
            BasicModElement target = helper.apply(from.target);
            BasicSchema basicSchema = schema = target == null ? null : target.getSchema();
            to.setRefSchemaName(schema == to.getSchema() ? null : this.getName(schema, from.target == null ? null : from.target.parent));
            to.setRefTableName(this.getName(target, from.target));
            ArrayList cols = ContainerUtil.newArrayList();
            ArrayList targets2 = ContainerUtil.newArrayList();
            for (DeForeignKey.Ref ref : from.refs) {
                BasicModElement col = helper.apply(ref.ref);
                cols.add(this.getName(col, ref.ref));
                BasicModElement tCol = helper.apply(ref.target);
                targets2.add(this.getName(tCol, ref.target));
            }
            to.setColNames(cols);
            to.setRefColNames(targets2);
            DbImplUtil.resolveKey(to, targets2);
            to.setDeferrable(from.deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE);
            to.setInitiallyDeferred(from.deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED);
            to.setOnUpdate(DbImplUtil.asCascadeRule(from.updateRule));
            to.setOnDelete(DbImplUtil.asCascadeRule(from.deleteRule));
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeForeignKey to, @NotNull BasicForeignKey from) {
            if (helper == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            BasicTableOrView refTable = from.getRefTable();
            to.target = refTable == null || refTable.getKind() != ObjectKind.TABLE ? null : DeForeignKeyExporter.getTable(helper, refTable, true);
            to.deferrability = (DasForeignKey.Deferrability)ObjectUtils.chooseNotNull((Object)from.getDeferrability(), (Object)DasForeignKey.Deferrability.NOT_DEFERRABLE);
            to.updateRule = (DasForeignKey.RuleAction)ObjectUtils.chooseNotNull((Object)from.getUpdateRule(), (Object)DasForeignKey.RuleAction.NO_ACTION);
            to.deleteRule = (DasForeignKey.RuleAction)ObjectUtils.chooseNotNull((Object)from.getDeleteRule(), (Object)DasForeignKey.RuleAction.NO_ACTION);
            List<DeColumn> refs = DeForeignKeyExporter.getColumnsOrStubs(helper, to.table, from.getColumnsRef());
            List<DeColumn> targets2 = DeForeignKeyExporter.getColumnsOrStubs(helper, to.table, from.getRefColumns());
            int cnt = Math.max(refs.size(), targets2.size());
            for (int i2 = 0; i2 < cnt; ++i2) {
                DeColumn ref = i2 < refs.size() ? refs.get(i2) : null;
                DeColumn target = i2 < targets2.size() ? targets2.get(i2) : null;
                to.refs.add(new DeForeignKey.Ref(ref, target));
            }
        }

        @Override
        @NotNull
        public DeForeignKey create(@NotNull SchemaExportHelper helper, @NotNull BasicForeignKey from) {
            if (helper == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(4);
            }
            DeForeignKey deForeignKey = new DeForeignKey(DeForeignKeyExporter.getName(helper, from), DeTable.STUB, helper.getModel());
            if (deForeignKey == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(5);
            }
            return deForeignKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeForeignKeyExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeForeignKeyExporter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeIndexExporter
    extends DeTableChildExporter<DeIndex, BasicIndex, BasicModIndex> {
        public DeIndexExporter() {
            super(DeIndex.class, BasicIndex.class, ObjectKind.INDEX);
        }

        @Override
        protected void applyImpl(SchemaApplyHelper helper, DeIndex from, BasicModIndex to) {
            super.applyImpl(helper, from, to);
            ArrayList cols = ContainerUtil.newArrayList();
            LinkedHashSet revCols = ContainerUtil.newLinkedHashSet();
            for (DeIndex.Item item : from.items) {
                BasicModElement col = helper.apply(item.column);
                String name = this.getName(col, item.column);
                cols.add(name);
                if (item.sorting != DasIndex.Sorting.DESCENDING) continue;
                revCols.add(name);
            }
            to.setColNames(cols);
            to.setReverseColNames(revCols);
            to.setUnique(from.unique);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeIndex to, @NotNull BasicIndex from) {
            if (helper == null) {
                DeIndexExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeIndexExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeIndexExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            for (DeColumn column2 : DeIndexExporter.getColumnsOrStubs(helper, to.table, from.getColumnsRef())) {
                DasTypedObject editedColumn = (DasTypedObject)column2.getEditedObject();
                to.items.add(new DeIndex.Item(column2, editedColumn == null ? DasIndex.Sorting.NONE : from.getColumnSorting(editedColumn)));
            }
            to.unique = from.isUnique();
        }

        @Override
        @NotNull
        public DeIndex create(@NotNull SchemaExportHelper helper, @NotNull BasicIndex from) {
            if (helper == null) {
                DeIndexExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeIndexExporter.$$$reportNull$$$0(4);
            }
            DeIndex deIndex = new DeIndex(DeIndexExporter.getName(helper, from), DeTable.STUB, helper.getModel());
            if (deIndex == null) {
                DeIndexExporter.$$$reportNull$$$0(5);
            }
            return deIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeIndexExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeIndexExporter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeColumnExporter
    extends DeTableChildExporter<DeColumn, BasicTableColumn, BasicModTableColumn> {
        public DeColumnExporter() {
            super(DeColumn.class, BasicTableColumn.class, ObjectKind.COLUMN);
        }

        @Override
        protected void applyImpl(SchemaApplyHelper helper, DeColumn from, BasicModTableColumn to) {
            super.applyImpl(helper, from, to);
            to.setDataType(DataTypeFactory.of(from.dataType));
            to.setNotNull(from.isNotNull());
            to.setPosition((short)(from.table.columns.indexOf(from) + 1));
            DbImplUtil.getModelHelper(to).exportApplyColumn(helper, from, to);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeColumn to, @NotNull BasicTableColumn from) {
            if (helper == null) {
                DeColumnExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeColumnExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeColumnExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            to.dataType = from.getDataType().getSpecification();
            to.defaultValue = from.getDefault();
            if (from.isNotNull()) {
                to.flags.add(DeColumn.Flag.NOT_NULL);
            }
            DbImplUtil.getModelHelper(from).exportLightExport(helper, to, from);
        }

        @Override
        @NotNull
        public DeColumn create(@NotNull SchemaExportHelper helper, @NotNull BasicTableColumn from) {
            if (helper == null) {
                DeColumnExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeColumnExporter.$$$reportNull$$$0(4);
            }
            DeColumn deColumn = new DeColumn(DeColumnExporter.getName(helper, from), DeTable.STUB, helper.getModel());
            if (deColumn == null) {
                DeColumnExporter.$$$reportNull$$$0(5);
            }
            return deColumn;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeColumnExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeColumnExporter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class DeTableChildExporter<De extends DeTableChild, Das extends DasTableChild & BasicElement, MDas extends BasicModElement>
    extends DeObjectExporter<De, Das, MDas> {
        public DeTableChildExporter(@NotNull Class<De> exportedClass, @NotNull Class<Das> exportableClass, @Nullable ObjectKind kindFilter) {
            if (exportedClass == null) {
                DeTableChildExporter.$$$reportNull$$$0(0);
            }
            if (exportableClass == null) {
                DeTableChildExporter.$$$reportNull$$$0(1);
            }
            super(exportedClass, exportableClass, kindFilter);
        }

        @NotNull
        public static DeTable getTable(@NotNull SchemaExportHelper helper, @NotNull DasTable table, boolean withChildren) {
            if (helper == null) {
                DeTableChildExporter.$$$reportNull$$$0(2);
            }
            if (table == null) {
                DeTableChildExporter.$$$reportNull$$$0(3);
            }
            DeTable deTable = (DeTable)helper.export((DasObject)table, withChildren);
            if (deTable == null) {
                DeTableChildExporter.$$$reportNull$$$0(4);
            }
            return deTable;
        }

        @NotNull
        public DeTable getTable(@NotNull SchemaExportHelper helper, @NotNull Das object) {
            if (helper == null) {
                DeTableChildExporter.$$$reportNull$$$0(5);
            }
            if (object == null) {
                DeTableChildExporter.$$$reportNull$$$0(6);
            }
            DeTable deTable = DeTableChildExporter.getTable(helper, object.getTable(), true);
            if (deTable == null) {
                DeTableChildExporter.$$$reportNull$$$0(7);
            }
            return deTable;
        }

        @NotNull
        public static List<DeColumn> getColumnsOrStubs(@NotNull SchemaExportHelper helper, @NotNull DeTable table, @NotNull MultiRef<? extends DasTypedObject> ref) {
            if (helper == null) {
                DeTableChildExporter.$$$reportNull$$$0(8);
            }
            if (table == null) {
                DeTableChildExporter.$$$reportNull$$$0(9);
            }
            if (ref == null) {
                DeTableChildExporter.$$$reportNull$$$0(10);
            }
            ArrayList res2 = ContainerUtil.newArrayListWithCapacity((int)ref.size());
            MultiRef.It it = ref.iterate();
            while (it.hasNext()) {
                String name = (String)it.next();
                DeColumn column2 = (DeColumn)helper.export((DasObject)it.resolve(), true);
                res2.add(EditorModelUtil.stubbize(column2, name, table, table.model));
            }
            ArrayList arrayList = res2;
            if (arrayList == null) {
                DeTableChildExporter.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        @Override
        public boolean canExport(@NotNull Das object) {
            if (object == null) {
                DeTableChildExporter.$$$reportNull$$$0(12);
            }
            BasicElement parent2 = ((BasicElement)object).getDasParent();
            return super.canExport(object) && parent2 != null && parent2.getKind() == ObjectKind.TABLE;
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeTableChildExporter.$$$reportNull$$$0(13);
            }
            if (to == null) {
                DeTableChildExporter.$$$reportNull$$$0(14);
            }
            if (from == null) {
                DeTableChildExporter.$$$reportNull$$$0(15);
            }
            super.lightExport(helper, to, (BasicElement)from);
            ((DeTableChild)to).table = this.getTable(helper, from);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportedClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportableClass";
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter";
                    break;
                }
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTable";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnsOrStubs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getTable";
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumnsOrStubs";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "canExport";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeTableExporter
    extends DeObjectExporter<DeTable, BasicTable, BasicModTableOrView> {
        public DeTableExporter() {
            super(DeTable.class, BasicTable.class, ObjectKind.TABLE);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeTable to, @NotNull BasicTable from) {
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeTableExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeTableExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            to.parent = helper.export(from.getDasParent(), false);
            to.temporary = from.isTemporary();
        }

        @Override
        @NotNull
        public DeTable create(@NotNull SchemaExportHelper helper, @NotNull BasicTable from) {
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeTableExporter.$$$reportNull$$$0(4);
            }
            DeTable deTable = new DeTable(DeTableExporter.getName(helper, from), null, helper.getModel());
            if (deTable == null) {
                DeTableExporter.$$$reportNull$$$0(5);
            }
            return deTable;
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull DeTable to, @NotNull BasicTable from) {
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(6);
            }
            if (to == null) {
                DeTableExporter.$$$reportNull$$$0(7);
            }
            if (from == null) {
                DeTableExporter.$$$reportNull$$$0(8);
            }
            for (BasicElement child : from.getDasChildren(null)) {
                this.processTableChild(helper, to, child);
            }
            if (to.keys.getPrimaryKey() == null) {
                this.processTableInlinePk(helper, to, from);
            }
        }

        protected void processTableChild(@NotNull SchemaExportHelper helper, @NotNull DeTable table, @NotNull BasicElement child) {
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(9);
            }
            if (table == null) {
                DeTableExporter.$$$reportNull$$$0(10);
            }
            if (child == null) {
                DeTableExporter.$$$reportNull$$$0(11);
            }
            if (!helper.canExport(child)) {
                return;
            }
            Object exported = helper.export(child, true);
            if (exported instanceof DeColumn) {
                table.columns.add((DeColumn)exported);
            } else if (exported instanceof DeIndex) {
                table.indices.add((DeIndex)exported);
            } else if (exported instanceof DeForeignKey) {
                table.foreignKeys.add((DeForeignKey)exported);
            } else if (exported instanceof DeTableKey) {
                table.keys.add((DeTableKey)exported);
            } else if (exported instanceof DeConstraint) {
                table.constraints.add((DeConstraint)exported);
            }
        }

        protected void processTableInlinePk(@NotNull SchemaExportHelper helper, @NotNull DeTable table, @NotNull BasicTable object) {
            JBIterable key2;
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(12);
            }
            if (table == null) {
                DeTableExporter.$$$reportNull$$$0(13);
            }
            if (object == null) {
                DeTableExporter.$$$reportNull$$$0(14);
            }
            if (!(key2 = object.getColumns().jbi().filter(child -> {
                if (object == null) {
                    DeTableExporter.$$$reportNull$$$0(15);
                }
                return object.getColumnAttrs((DasColumn)child).contains(DasColumn.Attribute.PRIMARY_KEY);
            }).collect()).isEmpty()) {
                DeTableKey primaryKey = new DeTableKey(table.name + "_autogenerated_pk", table, helper.getModel());
                for (BasicTableOrViewColumn column2 : key2) {
                    primaryKey.columns.add(helper.export(column2, true));
                }
                if (table.keys.getPrimaryKey() != null) {
                    this.myLogger.warn("Already have primary key");
                }
                table.keys.setPrimaryKey(primaryKey);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter";
                    break;
                }
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "exportChildren";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "processTableChild";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "processTableInlinePk";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$processTableInlinePk$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeObjectCloner
    extends DeObjectExporterBase<DeObject, DeObject> {
        public DeObjectCloner() {
            super(DeObject.class, DeObject.class, null);
        }

        @Override
        public void apply(SchemaApplyHelper helper, @NotNull DeObject from, @NotNull DeObject to) {
            if (from == null) {
                DeObjectCloner.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeObjectCloner.$$$reportNull$$$0(1);
            }
            throw new AssertionError((Object)"Should not happen");
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeObject to, @NotNull DeObject from) {
            if (helper == null) {
                DeObjectCloner.$$$reportNull$$$0(2);
            }
            if (to == null) {
                DeObjectCloner.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeObjectCloner.$$$reportNull$$$0(4);
            }
            to.copyFrom(from, false, helper.getCopier());
            DeObject parent2 = to.getParent();
            if (parent2 instanceof DeTable) {
                helper.export(parent2.getEditedObject(), true);
            }
            to.setEditedObject(from);
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull DeObject to, @NotNull DeObject from) {
            if (helper == null) {
                DeObjectCloner.$$$reportNull$$$0(5);
            }
            if (to == null) {
                DeObjectCloner.$$$reportNull$$$0(6);
            }
            if (from == null) {
                DeObjectCloner.$$$reportNull$$$0(7);
            }
            to.copyChildrenFrom(from, helper.getCopier());
        }

        @Override
        @NotNull
        public DeObject create(@NotNull SchemaExportHelper helper, @NotNull DeObject from) {
            if (helper == null) {
                DeObjectCloner.$$$reportNull$$$0(8);
            }
            if (from == null) {
                DeObjectCloner.$$$reportNull$$$0(9);
            }
            DeObject object = from.emptyClone(helper.getModel());
            if (from.getParent() == null && Iterables.contains(from.model.getModelRoots(), (Object)from)) {
                object.model.addRoot(object);
            }
            DeObject deObject = object;
            if (deObject == null) {
                DeObjectCloner.$$$reportNull$$$0(10);
            }
            return deObject;
        }

        @Override
        public void applyChildren(SchemaApplyHelper helper, @NotNull DeObject from, @NotNull DeObject to) {
            if (from == null) {
                DeObjectCloner.$$$reportNull$$$0(11);
            }
            if (to == null) {
                DeObjectCloner.$$$reportNull$$$0(12);
            }
            throw new AssertionError((Object)"Should not happen");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectCloner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectCloner";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "exportChildren";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 10: {
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "applyChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class DeObjectExporter<De extends DeObject, Das extends BasicElement, MDas extends BasicModElement>
    extends DeObjectExporterBase<De, Das> {
        public DeObjectExporter(@NotNull Class<De> exportedClass, @NotNull Class<Das> exportableClass, @Nullable ObjectKind kindFilter) {
            if (exportedClass == null) {
                DeObjectExporter.$$$reportNull$$$0(0);
            }
            if (exportableClass == null) {
                DeObjectExporter.$$$reportNull$$$0(1);
            }
            super(exportedClass, exportableClass, kindFilter);
        }

        @Override
        public void apply(SchemaApplyHelper helper, @NotNull De from, @NotNull Das to) {
            if (from == null) {
                DeObjectExporter.$$$reportNull$$$0(2);
            }
            if (to == null) {
                DeObjectExporter.$$$reportNull$$$0(3);
            }
            this.applyImpl(helper, from, (BasicModElement)to);
        }

        protected void applyImpl(SchemaApplyHelper helper, De from, MDas to) {
            BasicModNamedElement named = (BasicModNamedElement)ObjectUtils.tryCast(to, BasicModNamedElement.class);
            if (named != null) {
                boolean quoted = helper.getContext().getDialect().isQuotedIdentifier(((DeObject)from).name);
                BasicNamedElement edited = (BasicNamedElement)ObjectUtils.tryCast((Object)DbRenamePsiElementProcessor.unwrapDeElement(from), BasicNamedElement.class);
                boolean isSql = edited == null || edited.isNameScripted();
                named.setName(this.getName((DeObject)from));
                named.setNameScripted(isSql);
                named.setNameSurrogate(this.isNameSurrogate(named, quoted, edited));
                named.setNameQuoted(isSql && quoted);
                named.setComment(((DeObject)from).comment);
            }
        }

        private boolean isNameSurrogate(@NotNull BasicModNamedElement named, boolean quoted, @Nullable BasicNamedElement edited) {
            if (named == null) {
                DeObjectExporter.$$$reportNull$$$0(4);
            }
            if (edited != null && named.getName().equals(edited.getName())) {
                return edited.isNameSurrogate();
            }
            return !quoted && StringUtil.isEmpty((String)named.getName());
        }

        @NotNull
        protected String getName(@Nullable DeObject from) {
            if (from == null) {
                String string = DasUtil.NO_NAME;
                if (string == null) {
                    DeObjectExporter.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = from.model.getExportHelper().getContext().getDialect().unquoteIdentifier(from.name);
            if (string == null) {
                DeObjectExporter.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        protected String getName(@Nullable BasicElement e, @Nullable DeObject obj2) {
            if (e != null) {
                String string = DasUtil.getName((DasObject)e);
                if (string == null) {
                    DeObjectExporter.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = this.getName(obj2);
            if (string == null) {
                DeObjectExporter.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeObjectExporter.$$$reportNull$$$0(9);
            }
            if (to == null) {
                DeObjectExporter.$$$reportNull$$$0(10);
            }
            if (from == null) {
                DeObjectExporter.$$$reportNull$$$0(11);
            }
            ((DeObject)to).comment = StringUtil.nullize((String)from.getComment());
            ((DeObject)to).setEditedObject((BasicElement)from);
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeObjectExporter.$$$reportNull$$$0(12);
            }
            if (to == null) {
                DeObjectExporter.$$$reportNull$$$0(13);
            }
            if (from == null) {
                DeObjectExporter.$$$reportNull$$$0(14);
            }
            assert (from.getDasChildren(null).isEmpty());
        }

        @Override
        public void applyChildren(SchemaApplyHelper helper, @NotNull De from, @NotNull Das to) {
            if (from == null) {
                DeObjectExporter.$$$reportNull$$$0(15);
            }
            if (to == null) {
                DeObjectExporter.$$$reportNull$$$0(16);
            }
            if (DasUtil.getSchemaObject(to) != null) {
                for (DeObject child : ((DeObject)from).getDasChildren(null)) {
                    helper.apply(child);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportedClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportableClass";
                    break;
                }
                case 2: 
                case 11: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 3: 
                case 10: 
                case 13: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "named";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter";
                    break;
                }
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isNameSurrogate";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "exportChildren";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "applyChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class DeObjectExporterBase<De extends DeObject, Das extends DasObject>
    implements SchemaExporters.Exporter<De, Das> {
        protected final Logger myLogger;
        private final Class<De> myExportedClass;
        private final Class<Das> myExportableClass;
        private final ObjectKind myKindFilter;

        public DeObjectExporterBase(@NotNull Class<De> exportedClass, @NotNull Class<Das> exportableClass, @Nullable ObjectKind kindFilter) {
            if (exportedClass == null) {
                DeObjectExporterBase.$$$reportNull$$$0(0);
            }
            if (exportableClass == null) {
                DeObjectExporterBase.$$$reportNull$$$0(1);
            }
            this.myLogger = Logger.getInstance(this.getClass());
            this.myExportedClass = exportedClass;
            this.myExportableClass = exportableClass;
            this.myKindFilter = kindFilter;
        }

        @Override
        @NotNull
        public Class<De> getExportedClass() {
            Class<De> clazz = this.myExportedClass;
            if (clazz == null) {
                DeObjectExporterBase.$$$reportNull$$$0(2);
            }
            return clazz;
        }

        @Override
        @NotNull
        public Class<Das> getExportableClass() {
            Class<Das> clazz = this.myExportableClass;
            if (clazz == null) {
                DeObjectExporterBase.$$$reportNull$$$0(3);
            }
            return clazz;
        }

        @Override
        public int compareTo(SchemaExporters.Exporter<? extends DeObject, ? extends DasObject> o) {
            return Comparing.compare((int)System.identityHashCode(this), (int)System.identityHashCode(o));
        }

        @Override
        public boolean canExport(@NotNull Das object) {
            if (object == null) {
                DeObjectExporterBase.$$$reportNull$$$0(4);
            }
            return this.myKindFilter == null || this.myKindFilter == object.getKind();
        }

        @NotNull
        protected static String getName(@NotNull SchemaExportHelper helper, @NotNull BasicElement object) {
            if (helper == null) {
                DeObjectExporterBase.$$$reportNull$$$0(5);
            }
            if (object == null) {
                DeObjectExporterBase.$$$reportNull$$$0(6);
            }
            String name = object.getName();
            if (!DbSqlUtil.isSqlObject(object) || !DbSqlUtil.isQuoted(object)) {
                String string = name;
                if (string == null) {
                    DeObjectExporterBase.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = helper.getContext().getDialect().quoteIdentifier(name, true, false);
            if (string == null) {
                DeObjectExporterBase.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportedClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportableClass";
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporterBase";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporterBase";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExportedClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExportableClass";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canExport";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

