/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.mssql.AbstractTsqlDialect;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MssqlDialect
extends AbstractTsqlDialect
implements DatabaseDialect {
    public static final MssqlDialect INSTANCE = new MssqlDialect();

    public MssqlDialect() {
        super(new TypeHelper.MssqlTypeHelper(), Casing.create((Case)Case.MIXED, (Case)Case.MIXED));
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.MSSQL;
        if (dbms == null) {
            MssqlDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.SqlServer;
        if (icon == null) {
            MssqlDialect.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("SQL Server" == null) {
            MssqlDialect.$$$reportNull$$$0(2);
        }
        return "SQL Server";
    }

    @Override
    public boolean supportsInsertDefaultValues() {
        return true;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        String sqlType;
        if (dataType == null) {
            MssqlDialect.$$$reportNull$$$0(3);
        }
        if ("money".equals(sqlType = dataType.getSpecification())) {
            if ("money" == null) {
                MssqlDialect.$$$reportNull$$$0(4);
            }
            return "money";
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            MssqlDialect.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            MssqlDialect.$$$reportNull$$$0(6);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element2) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName(element2, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            MssqlDialect.$$$reportNull$$$0(7);
        }
        return pair;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            MssqlDialect.$$$reportNull$$$0(8);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element2) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName((DasObject)element2, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            MssqlDialect.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            MssqlDialect.$$$reportNull$$$0(10);
        }
        if (qualifier == null) {
            MssqlDialect.$$$reportNull$$$0(11);
        }
        boolean needQualify = this.qualify(qualifier);
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DasObject catalog = DasUtil.getCatalogObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), (DasObject)(needQualify ? catalog : null), needQualify ? DasUtil.getName((DasObject)catalog) : null, null, null);
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(12);
        }
        return ddlBuilder;
    }

    public boolean qualify(DasObject qualifier) {
        if (!(qualifier instanceof DasTable)) {
            return false;
        }
        ObjectKind kind = qualifier.getKind();
        return kind == ObjectKind.TABLE;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element2, @NotNull DatabaseConnection connection2) throws Exception {
        if (element2 == null) {
            MssqlDialect.$$$reportNull$$$0(13);
        }
        if (connection2 == null) {
            MssqlDialect.$$$reportNull$$$0(14);
        }
        DdlBuilder builder = new DdlBuilder().configureFor((DbElement)element2);
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection2, String.format("EXEC sp_spaceused '%s'", DbImplUtil.escapeStr(builder.qualifiedRef((DasObject)element2).getStatement())), "rows", "rows");
        if (map == null) {
            MssqlDialect.$$$reportNull$$$0(15);
        }
        return map;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection2) throws Exception {
        Serializable toCols;
        if (table == null) {
            MssqlDialect.$$$reportNull$$$0(16);
        }
        if (connection2 == null) {
            MssqlDialect.$$$reportNull$$$0(17);
        }
        String tableName = table.getName().replace("'", "''");
        String tableSchema = DasUtil.getSchema((DasObject)table).replace("'", "''");
        String tableCatalog = DasUtil.getCatalog((DasObject)table).replace("'", "''");
        String columns = String.format("SELECT * FROM INFORMATION_SCHEMA.TABLES AS T INNER JOIN     INFORMATION_SCHEMA.COLUMNS AS C ON \n                                    T.TABLE_NAME = C.TABLE_NAME                                    AND T.TABLE_SCHEMA = C.TABLE_SCHEMA                                    AND T.TABLE_CATALOG = C.TABLE_CATALOG  WHERE      T.TABLE_NAME = N'%s'  AND T.TABLE_SCHEMA = N'%s'  AND T.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        String pkColumnsQuery = String.format("SELECT U.COLUMN_NAME FROM  INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C  INNER JOIN  INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS U ON U.CONSTRAINT_NAME = C.CONSTRAINT_NAME  WHERE C.CONSTRAINT_TYPE = 'PRIMARY KEY'  AND C.TABLE_NAME = N'%s'  AND C.TABLE_SCHEMA = N'%s'  AND C.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        SmartStatements statements2 = SmartStatements.poweredBy(connection2);
        List<String> pkColumns = statements2.simple().noisy().execute(pkColumnsQuery, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.listOfStrings("column_name"));
        boolean isSinglePk = pkColumns.size() == 1;
        int spaces = 2;
        DdlBuilder ddl = table instanceof DbElement ? DatabaseDialogsHelper.createDdlBuilder((DbElement)table, false) : new DdlBuilder().withDialect(this);
        ddl.keywords("create", "table").space().qualifiedRef((DasObject)table).space().symbol("(");
        statements2.simple().noisy().execute(columns, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<ResultSet, Exception>)((ThrowableConsumer)rs -> {
            boolean first = true;
            while (rs.next()) {
                if (first) {
                    first = false;
                } else {
                    ddl.symbol(",");
                }
                String name = JdbcUtil.getStringSafe((ResultSet)rs, (String)"column_name", null);
                String defaults = JdbcUtil.getStringSafe((ResultSet)rs, (String)"column_default", null);
                String type = JdbcUtil.getStringSafe((ResultSet)rs, (String)"data_type", null);
                String length = JdbcUtil.getStringSafe((ResultSet)rs, (String)"character_maximum_length", null);
                String precision = JdbcUtil.getStringSafe((ResultSet)rs, (String)"numeric_precision", null);
                String scale = JdbcUtil.getStringSafe((ResultSet)rs, (String)"numeric_scale", null);
                String isNullableStr = JdbcUtil.getStringSafe((ResultSet)rs, (String)"is_nullable", null);
                boolean isNotNull = "NO".equals(isNullableStr);
                length = MssqlDialect.isMax(type, length) ? String.valueOf(Integer.MAX_VALUE) : length;
                String substitution = this.getTypeWithSubstitution(type != null ? type : "<type>", StringUtil.parseInt((String)length, (int)-1), StringUtil.parseInt((String)precision, (int)-1), StringUtil.parseInt((String)scale, (int)-1));
                ddl.newLine().space(spaces).columnRef(name != null ? name : "<name>").space().type(substitution);
                if (isSinglePk && ((String)pkColumns.iterator().next()).equals(name)) {
                    ddl.space().keywords("primary", "key");
                }
                if (defaults != null) {
                    ddl.space().keywords("default").space().literal(defaults);
                }
                if (!isNotNull) continue;
                ddl.space().keywords("not", "null");
            }
        })));
        if (pkColumns.size() > 1) {
            ddl.symbol(",").newLine().space(spaces).keywords("primary", "key").space().symbol("(");
            boolean f = true;
            for (String string : pkColumns) {
                if (f) {
                    f = false;
                } else {
                    ddl.symbol(",").space();
                }
                ddl.identifier(string);
            }
            ddl.symbol(")");
        }
        String fkQuery = String.format("SELECT C.CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C WHERE      C.CONSTRAINT_TYPE = 'FOREIGN KEY'  AND C.TABLE_NAME = N'%s'  AND C.TABLE_SCHEMA = N'%s'  AND C.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        List fkNames = statements2.simple().noisy().execute(fkQuery, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.resultsTransformer(rs -> {
            List result2 = ContainerUtil.newSmartList();
            while (rs.next()) {
                result2.add(rs.getString("constraint_name"));
            }
            return result2;
        }, ContainerUtil.emptyList()));
        for (String fkName : fkNames) {
            String fkCols = String.format("SELECT\n    U.COLUMN_NAME AS FROM_COL,    K.TABLE_NAME,    K.COLUMN_NAME  FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C   INNER JOIN INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS U ON U.CONSTRAINT_NAME = C.CONSTRAINT_NAME  INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS R ON R.CONSTRAINT_NAME = C.CONSTRAINT_NAME  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE K ON K.CONSTRAINT_NAME = R.UNIQUE_CONSTRAINT_NAME  WHERE C.CONSTRAINT_NAME = '%s'", fkName);
            LinkedHashSet fromCols = ContainerUtil.newLinkedHashSet();
            toCols = ContainerUtil.newLinkedHashSet();
            String refTableName = "<ref_table>";
            try (ClosableResultsProducer producer = statements2.simple().noisy().execute(fkCols, StandardExecutionMode.QUERY);){
                ResultSet rs2;
                ResultSet resultSet = rs2 = producer.advance() ? producer.processCurrent(StandardResultsProcessors.RESULT_SET) : null;
                if (rs2 != null) {
                    while (rs2.next()) {
                        refTableName = rs2.getString("table_name");
                        ContainerUtil.addIfNotNull((Collection)fromCols, (Object)rs2.getString("from_col"));
                        ContainerUtil.addIfNotNull((Collection)((Object)toCols), (Object)rs2.getString("column_name"));
                    }
                }
            }
            ddl.symbol(",").newLine().space(spaces).keywords("foreign", "key").space().symbol("(");
            DialectUtils.appendStringList(ddl, fromCols);
            ddl.symbol(")");
            ddl.space().keyword("references").space().identifier(refTableName).space().symbol("(");
            DialectUtils.appendStringList(ddl, (Iterable<String>)((Object)toCols));
            ddl.symbol(")");
        }
        ddl.newLine().symbol(")").symbol(";");
        String string = String.format("select  ind.name as index_name,  t.name as table_name,  col.name as col_name,  ind.is_unique from sys.indexes ind  inner join sys.index_columns ic on ind.object_id = ic.object_id and ind.index_id = ic.index_id  inner join sys.columns col on ic.object_id = col.object_id and ic.column_id = col.column_id  inner join sys.tables t on ind.object_id = t.object_id where ind.is_primary_key = 0 and t.is_ms_shipped = 0  and t.name = N'%s'", tableName);
        MultiMap indexColumns = new MultiMap();
        HashMap<String, Boolean> indexUnique = new HashMap<String, Boolean>();
        ClosableResultsProducer producer = statements2.simple().noisy().execute(string, StandardExecutionMode.QUERY);
        toCols = null;
        try {
            ResultSet rs3;
            ResultSet resultSet = rs3 = producer.advance() ? producer.processCurrent(StandardResultsProcessors.RESULT_SET) : null;
            if (rs3 != null) {
                while (rs3.next()) {
                    String indexName = rs3.getString("index_name");
                    String columnName = rs3.getString("col_name");
                    boolean isUnique = rs3.getBoolean("is_unique");
                    indexColumns.putValue((Object)indexName, (Object)columnName);
                    indexUnique.put(indexName, isUnique);
                }
            }
        }
        catch (Throwable rs3) {
            toCols = rs3;
            throw rs3;
        }
        finally {
            if (producer != null) {
                if (toCols != null) {
                    try {
                        producer.close();
                    }
                    catch (Throwable rs3) {
                        ((Throwable)toCols).addSuppressed(rs3);
                    }
                } else {
                    producer.close();
                }
            }
        }
        for (String i2 : indexColumns.keySet()) {
            Collection colNames = indexColumns.get((Object)i2);
            Boolean isUnique = (Boolean)indexUnique.get(i2);
            ddl.newLine().keywords("create").space();
            if (isUnique.booleanValue()) {
                ddl.keyword("unique").space();
            }
            ddl.keyword("index").space().identifier(i2).space().keyword("on").space().identifier(tableName).space().symbol("(");
            boolean first = true;
            for (String col : colNames) {
                if (first) {
                    first = false;
                } else {
                    ddl.symbol(",").space();
                }
                ddl.identifier(col);
            }
            ddl.symbol(")").symbol(";");
        }
        String string2 = ddl.getStatement();
        if (string2 == null) {
            MssqlDialect.$$$reportNull$$$0(18);
        }
        return string2;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(19);
        }
        if (statement == null) {
            MssqlDialect.$$$reportNull$$$0(20);
        }
        builder.keywords("set", "showplan_text", "on").newStatement();
        builder.keywords("go").newLine();
        if (!analyze) {
            builder.keywords("set", "noexec", "on").newStatement();
        }
        builder.plain(statement).newStatement();
        if (!analyze) {
            builder.keywords("set", "noexec", "off").newStatement();
        }
        builder.keywords("go").newLine();
        builder.keywords("set", "showplan_text", "off").newStatement();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(21);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlPostExplainPlan(@NotNull DdlBuilder builder, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(22);
        }
        if (!analyze) {
            builder.keywords("set", "noexec", "off").newStatement();
        }
        builder.keywords("go").newLine();
        builder.keywords("set", "showplan_text", "off").newStatement();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(23);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAlterAutoIncrement() {
        return false;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection2) throws SQLException {
        if (connection2 == null) {
            MssqlDialect.$$$reportNull$$$0(24);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection2, "SELECT [name] FROM sys.databases d WHERE d.database_id > 4", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            MssqlDialect.$$$reportNull$$$0(25);
        }
        return list;
    }

    private static boolean isMax(@Nullable String type, @Nullable String length) {
        return type != null && length != null && StringUtil.equals((CharSequence)"-1", (CharSequence)length) && !MssqlDialect.isLargeType(type);
    }

    private static boolean isLargeType(@Nullable String type) {
        return StringUtil.findIgnoreCase((String)type, (String[])new String[]{"xml", "image", "text", "ntext"});
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        if (system == null) {
            return false;
        }
        Version productVersion = system.getVersion();
        return DataSourceUiUtil.isMsSql2008(productVersion);
    }

    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DasDataSource system) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(26);
        }
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("%%physloc%% as \"%%physloc%%\"");
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/MssqlDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 6: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 14: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/MssqlDialect";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlViewDefinition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPostExplainPlan";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRowId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sqlPostExplainPlan";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "appendRowId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

