/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.view.ui.DatabaseDriverGeneralPanel;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;

public class DataSourceOptionsPanel {
    private JPanel myRootPanel;
    private JBCheckBox myGenericIntrospector;
    private JEditorPane myObjectFilterHelp;
    private RawCommandLineEditor myObjectFilterField;
    private ComboBox<DBIntrospectionOptions.SourceLoading> mySourceLoading;
    private ComboBox<DatabaseDriver.SchemaControl> mySwitchControlBox;
    private JBCheckBox mySingleDatabase;
    private ComboBox<String> myCodeStyleComboBox;
    private JBCheckBox mySingleConnectionCheckBox;
    private JBCheckBox myCheckOutdatedCheckBox;

    public DataSourceOptionsPanel(@NotNull DataSourceConfigurable dialog) {
        if (dialog == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.mySourceLoading.setModel((ComboBoxModel)new EnumComboBoxModel(DBIntrospectionOptions.SourceLoading.class));
        this.mySourceLoading.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DBIntrospectionOptions.SourceLoading>(){

            public void customize(JList list, DBIntrospectionOptions.SourceLoading value, int index2, boolean selected, boolean hasFocus) {
                String text2 = "None";
                if (value == DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES) {
                    text2 = "All schemas";
                }
                if (value == DBIntrospectionOptions.SourceLoading.USER_SOURCES) {
                    text2 = "All excl. system schemas";
                }
                this.setText(text2);
            }
        });
        this.mySwitchControlBox.setModel((ComboBoxModel)new EnumComboBoxModel(DatabaseDriver.SchemaControl.class));
        this.mySwitchControlBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DatabaseDriver.SchemaControl>(){

            public void customize(JList list, DatabaseDriver.SchemaControl value, int index2, boolean selected, boolean hasFocus) {
                this.setText(DataSourceOptionsPanel.getText(value));
            }
        });
        this.myRootPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        LocalDataSource dataSource = (LocalDataSource)dialog.getDataSource();
        this.myObjectFilterField.setText(StringUtil.notNullize((String)dataSource.getObjectPattern()));
        this.myObjectFilterHelp.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                RegExHelpPopup.createRegExLinkRunnable((Component)this.myRootPanel, null).run();
            }
        });
        this.myGenericIntrospector.setVisible(DBIntrospectorFactory.hasNativeIntrospector(dataSource.getDbms()));
        this.myGenericIntrospector.setSelected(dataSource.useLegacyIntrospector());
        this.mySingleDatabase.setVisible(JdbcUrlParserUtil.isDatabaseBounded(dataSource));
        this.mySingleDatabase.setSelected(!dataSource.isRewriteBounds());
        this.mySingleConnectionCheckBox.setSelected(dataSource.isSingleConnection());
        this.myCheckOutdatedCheckBox.setSelected(dataSource.shouldCheckOutdated());
        this.mySourceLoading.setSelectedItem((Object)dataSource.getSourceLoading());
        SortedComboBoxModel codeStyleNamesModel = new SortedComboBoxModel(String.CASE_INSENSITIVE_ORDER);
        List allSchemes = CodeStyleSchemesImpl.getSchemeManager().getAllSchemes();
        for (CodeStyleScheme scheme : allSchemes) {
            codeStyleNamesModel.add((Object)scheme.getName());
        }
        this.myCodeStyleComboBox.setModel((ComboBoxModel)codeStyleNamesModel);
    }

    @NotNull
    private static String getText(DatabaseDriver.SchemaControl value) {
        if (value == DatabaseDriver.SchemaControl.FORBID) {
            if ("Disabled" == null) {
                DataSourceOptionsPanel.$$$reportNull$$$0(1);
            }
            return "Disabled";
        }
        String string = StringUtil.capitalize((String)StringUtil.toLowerCase((String)((DatabaseDriver.SchemaControl)((Object)ObjectUtils.chooseNotNull((Object)((Object)value), (Object)((Object)DatabaseDriver.SchemaControl.AUTOMATIC)))).name()));
        if (string == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading mode) {
        if (mode == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(3);
        }
        this.mySourceLoading.setSelectedItem((Object)mode);
    }

    public JPanel getComponent() {
        return this.myRootPanel;
    }

    public void saveData(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(4);
        }
        dataSource.setObjectPattern(StringUtil.nullize((String)this.myObjectFilterField.getText()));
        dataSource.setUseLegacyIntrospector(this.myGenericIntrospector.isSelected());
        dataSource.setRewriteBounds(!this.mySingleDatabase.isSelected());
        dataSource.setSourceLoading((DBIntrospectionOptions.SourceLoading)((Object)ObjectUtils.chooseNotNull((Object)((Object)((DBIntrospectionOptions.SourceLoading)((Object)this.mySourceLoading.getSelectedItem()))), (Object)((Object)DBIntrospectionOptions.SourceLoading.NO_SOURCES))));
        dataSource.setSchemaControl((DatabaseDriver.SchemaControl)((Object)ObjectUtils.chooseNotNull((Object)((Object)((DatabaseDriver.SchemaControl)((Object)this.mySwitchControlBox.getSelectedItem()))), (Object)((Object)DatabaseDriver.SchemaControl.AUTOMATIC))));
        dataSource.setCodeStyleName(DatabaseDriverGeneralPanel.nullizeCS((String)this.myCodeStyleComboBox.getSelectedItem(), "Default"));
        dataSource.setSingleConnection(this.mySingleConnectionCheckBox.isSelected());
        dataSource.setCheckOutdated(this.myCheckOutdatedCheckBox.isSelected());
    }

    public void reset(LocalDataSource source) {
        this.mySourceLoading.setSelectedItem((Object)source.getSourceLoading());
        this.mySwitchControlBox.setSelectedItem((Object)source.getSchemaControl());
        this.myGenericIntrospector.setSelected(source.useLegacyIntrospector());
        this.mySingleDatabase.setSelected(!source.isRewriteBounds());
        this.myObjectFilterField.setText(StringUtil.notNullize((String)source.getObjectPattern()));
        this.myCodeStyleComboBox.setSelectedItem((Object)StringUtil.notNullize((String)source.getCodeStyleName(), (String)"Default"));
        this.mySingleConnectionCheckBox.setSelected(source.isSingleConnection());
        this.myCheckOutdatedCheckBox.setSelected(source.shouldCheckOutdated());
    }

    private void createUIComponents() {
        this.myObjectFilterField = new RawCommandLineEditor(s -> JBIterable.of((Object[])s.split("\\|\\|")).transform(StringUtil.TRIMMER).toList(), strings -> StringUtil.join((Iterable)JBIterable.from((Iterable)strings).transform(StringUtil.TRIMMER), (String)"||"));
        this.myObjectFilterField.setDialogCaption("Object Filter");
        this.myObjectFilterHelp = IdeTooltipManager.initPane((String)"", (HintHint)new HintHint(), null);
        this.myObjectFilterHelp.setEditable(false);
        NonOpaquePanel.setTransparent((JComponent)this.myObjectFilterHelp);
        this.myObjectFilterHelp.setBorder(null);
        this.myObjectFilterHelp.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        StyleSheet sheet = ((HTMLDocument)this.myObjectFilterHelp.getDocument()).getStyleSheet();
        sheet.addRule("a { color: #" + ColorUtil.toHex((Color)JBColor.link()) + " }");
        sheet.addRule("ol { margin: 0px; padding-left: 10px; padding-bottom: 4px; list-style-type:none; }");
        sheet.addRule(UIUtil.displayPropertiesToCSS((Font)JBUI.Fonts.smallFont(), (Color)UIUtil.getLabelDisabledForeground()));
        this.myObjectFilterHelp.setText("<html>A &lt;pattern&gt; or a list of &lt;type&gt;:[-]&lt;pattern&gt; separated by ||. Where:<ol>  <li>&lt;type&gt; is a <b>" + StringUtil.join((Collection)ContainerUtil.sorted(DataSourceUiUtil.FILTER_BY_NAME.keySet()), (String)"</b>, <b>") + "</b>,</li>  <li>&lt;pattern&gt is a <a href=\"#help\">regular expression</a>; prepend with - (minus) for exclusion.</li></ol>Examples: <b>table:CUR_.*</b> or <b>table:-OLD_.*||routine:DO.*||view:V_.*</b></html>");
        this.myObjectFilterHelp.setPreferredSize(new Dimension(150, 90));
        this.myObjectFilterHelp.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)4, (int)4));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceOptionsPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceOptionsPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSourceLoading";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        ComboBox comboBox;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JBCheckBox jBCheckBox4;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JEditorPane jEditorPane = this.myObjectFilterHelp;
        jPanel.add((Component)jEditorPane, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, null, null, null, 3));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Object filter:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myObjectFilterField;
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myGenericIntrospector = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Introspect using JDBC metadata");
        jBCheckBox4.setMnemonic('M');
        jBCheckBox4.setDisplayedMnemonicIndex(22);
        jPanel.add((Component)jBCheckBox4, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(6, 0, 1, 2, 8, 2, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Load sources for:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.mySourceLoading = comboBox3 = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox3.setModel(defaultComboBoxModel);
        jPanel2.add((Component)comboBox3, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.mySwitchControlBox = comboBox2 = new ComboBox();
        jPanel2.add((Component)comboBox2, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myCodeStyleComboBox = comboBox = new ComboBox();
        comboBox.setEnabled(true);
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Switch schema:");
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Code style:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySingleDatabase = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Single database mode");
        jBCheckBox3.setMnemonic('S');
        jBCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox3, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.mySingleConnectionCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Single connection mode");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myCheckOutdatedCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Notify me when an outdated object is opened");
        jPanel.add((Component)jBCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor((Component)rawCommandLineEditor);
        jBLabel3.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

